/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.spatial.Coordinate;
import org.neo4j.graphdb.spatial.Geometry;
import org.neo4j.graphdb.spatial.Point;
import org.neo4j.kernel.impl.util.NodeProxyWrappingNodeValue;
import org.neo4j.kernel.impl.util.RelationshipProxyWrappingEdgeValue;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.NumberValue;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.EdgeValue;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.NodeValue;
import org.neo4j.values.virtual.PathValue;
import org.neo4j.values.virtual.VirtualValues;

public final class ValueUtils {
    private ValueUtils() {
        throw new UnsupportedOperationException("do not instantiate");
    }

    public static AnyValue of(Object object) {
        Value value = Values.unsafeOf((Object)object, (boolean)true);
        if (value != null) {
            return value;
        }
        if (object instanceof Entity) {
            if (object instanceof Node) {
                return ValueUtils.fromNodeProxy((Node)object);
            }
            if (object instanceof Relationship) {
                return ValueUtils.fromRelationshipProxy((Relationship)object);
            }
            throw new IllegalArgumentException("Unknown entity + " + object.getClass().getName());
        }
        if (object instanceof Iterable) {
            if (object instanceof Path) {
                return ValueUtils.asPathValue((Path)object);
            }
            if (object instanceof List) {
                return ValueUtils.asListValue((List)object);
            }
            return ValueUtils.asListValue((Iterable)object);
        }
        if (object instanceof Map) {
            return ValueUtils.asMapValue((Map)object);
        }
        if (object instanceof Iterator) {
            ArrayList objects = new ArrayList();
            Iterator iterator = (Iterator)object;
            while (iterator.hasNext()) {
                objects.add(iterator.next());
            }
            return ValueUtils.asListValue(objects);
        }
        if (object instanceof Object[]) {
            Object[] array = (Object[])object;
            AnyValue[] anyValues = new AnyValue[array.length];
            for (int i = 0; i < array.length; ++i) {
                anyValues[i] = ValueUtils.of(array[i]);
            }
            return VirtualValues.list((AnyValue[])anyValues);
        }
        if (object instanceof Stream) {
            return ValueUtils.asListValue(((Stream)object).collect(Collectors.toList()));
        }
        if (object instanceof Geometry) {
            if (object instanceof Point) {
                return ValueUtils.asPointValue((Point)object);
            }
            return ValueUtils.asGeometryValue((Geometry)object);
        }
        throw new IllegalArgumentException(String.format("Cannot convert %s to AnyValue", object.getClass().getName()));
    }

    public static PointValue asPointValue(Point point) {
        return ValueUtils.toPoint((Geometry)point);
    }

    public static PointValue asGeometryValue(Geometry geometry) {
        if (!geometry.getGeometryType().equals("Point")) {
            throw new IllegalArgumentException("Cannot handle geometry type: " + geometry.getCRS().getType());
        }
        return ValueUtils.toPoint(geometry);
    }

    private static PointValue toPoint(Geometry geometry) {
        List coordinate = ((Coordinate)geometry.getCoordinates().get(0)).getCoordinate();
        double[] primitiveCoordinate = new double[coordinate.size()];
        for (int i = 0; i < coordinate.size(); ++i) {
            primitiveCoordinate[i] = (Double)coordinate.get(i);
        }
        if (geometry.getCRS().getCode() == CoordinateReferenceSystem.Cartesian.getCode()) {
            return Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])primitiveCoordinate);
        }
        if (geometry.getCRS().getCode() == CoordinateReferenceSystem.WGS84.getCode()) {
            return Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])primitiveCoordinate);
        }
        throw new IllegalArgumentException("Unknown coordinate reference system " + geometry.getCRS());
    }

    public static ListValue asListValue(List<?> collection) {
        ArrayList<AnyValue> values = new ArrayList<AnyValue>(collection.size());
        for (Object o : collection) {
            values.add(ValueUtils.of(o));
        }
        return VirtualValues.fromList(values);
    }

    public static ListValue asListValue(Iterable<?> collection) {
        ArrayList<AnyValue> values = new ArrayList<AnyValue>();
        for (Object o : collection) {
            values.add(ValueUtils.of(o));
        }
        return VirtualValues.fromList(values);
    }

    public static AnyValue asNodeOrEdgeValue(PropertyContainer container) {
        if (container instanceof Node) {
            return ValueUtils.fromNodeProxy((Node)container);
        }
        if (container instanceof Relationship) {
            return ValueUtils.fromRelationshipProxy((Relationship)container);
        }
        throw new IllegalArgumentException("Cannot produce a node or edge from " + container.getClass().getName());
    }

    public static PathValue asPathValue(Path path) {
        NodeValue[] nodes = (NodeValue[])StreamSupport.stream(path.nodes().spliterator(), false).map(ValueUtils::fromNodeProxy).toArray(NodeValue[]::new);
        EdgeValue[] edges = (EdgeValue[])StreamSupport.stream(path.relationships().spliterator(), false).map(ValueUtils::fromRelationshipProxy).toArray(EdgeValue[]::new);
        return VirtualValues.path((NodeValue[])nodes, (EdgeValue[])edges);
    }

    public static ListValue asListOfEdges(Iterable<Relationship> rels) {
        return VirtualValues.list((AnyValue[])((AnyValue[])StreamSupport.stream(rels.spliterator(), false).map(ValueUtils::fromRelationshipProxy).toArray(EdgeValue[]::new)));
    }

    public static ListValue asListOfEdges(Relationship[] rels) {
        EdgeValue[] edgeValues = new EdgeValue[rels.length];
        for (int i = 0; i < edgeValues.length; ++i) {
            edgeValues[i] = ValueUtils.fromRelationshipProxy(rels[i]);
        }
        return VirtualValues.list((AnyValue[])edgeValues);
    }

    public static MapValue asMapValue(Map<String, Object> map) {
        return VirtualValues.map(ValueUtils.mapValues(map));
    }

    public static PointValue fromMap(MapValue map) {
        if (map.containsKey("x") && map.containsKey("y")) {
            double x = ((NumberValue)map.get("x")).doubleValue();
            double y = ((NumberValue)map.get("y")).doubleValue();
            if (!map.containsKey("crs")) {
                return Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{x, y});
            }
            TextValue crs = (TextValue)map.get("crs");
            if (crs.stringValue().equals(CoordinateReferenceSystem.Cartesian.getName())) {
                return Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{x, y});
            }
            if (crs.stringValue().equals(CoordinateReferenceSystem.WGS84.getName())) {
                return Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{x, y});
            }
            throw new IllegalArgumentException("Unknown coordinate reference system: " + crs.stringValue());
        }
        if (map.containsKey("latitude") && map.containsKey("longitude")) {
            double latitude = ((NumberValue)map.get("latitude")).doubleValue();
            double longitude = ((NumberValue)map.get("longitude")).doubleValue();
            if (!map.containsKey("crs")) {
                return Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{longitude, latitude});
            }
            TextValue crs = (TextValue)map.get("crs");
            if (crs.stringValue().equals(CoordinateReferenceSystem.WGS84.getName())) {
                return Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{longitude, latitude});
            }
            throw new IllegalArgumentException("Geographic points does not support coordinate reference system: " + crs.stringValue());
        }
        throw new IllegalArgumentException("A point must contain either 'x' and 'y' or 'latitude' and 'longitude'");
    }

    private static Map<String, AnyValue> mapValues(Map<String, Object> map) {
        HashMap<String, AnyValue> newMap = new HashMap<String, AnyValue>(map.size());
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            newMap.put(entry.getKey(), ValueUtils.of(entry.getValue()));
        }
        return newMap;
    }

    public static NodeValue fromNodeProxy(Node node) {
        return new NodeProxyWrappingNodeValue(node);
    }

    public static EdgeValue fromRelationshipProxy(Relationship relationship) {
        return new RelationshipProxyWrappingEdgeValue(relationship);
    }
}

