/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.collection;

import java.util.Arrays;
import java.util.concurrent.locks.StampedLock;
import org.neo4j.collection.primitive.PrimitiveIntIterable;
import org.neo4j.collection.primitive.PrimitiveIntIterator;

public class SimpleBitSet
extends StampedLock
implements PrimitiveIntIterable {
    private long lastCheckPointKey;
    private long[] data;

    public SimpleBitSet(int size) {
        int capacity;
        int initialCapacity = size / 64;
        for (capacity = 1; capacity < initialCapacity; capacity <<= 1) {
        }
        long stamp = this.writeLock();
        this.data = new long[capacity];
        this.unlockWrite(stamp);
    }

    public boolean contains(int key) {
        boolean result;
        long stamp;
        int idx = key >>> 6;
        do {
            stamp = this.tryOptimisticRead();
            boolean bl = result = this.data.length > idx && (this.data[idx] & 1L << (key & 0x3F)) != 0L;
        } while (!this.validate(stamp));
        return result;
    }

    public void put(int key) {
        long stamp = this.writeLock();
        int idx = key >>> 6;
        this.ensureCapacity(idx);
        this.data[idx] = this.data[idx] | 1L << (key & 0x3F);
        this.unlockWrite(stamp);
    }

    public void put(SimpleBitSet other) {
        long stamp = this.writeLock();
        this.ensureCapacity(other.data.length - 1);
        for (int i = 0; i < this.data.length && i < other.data.length; ++i) {
            this.data[i] = this.data[i] | other.data[i];
        }
        this.unlockWrite(stamp);
    }

    public void remove(int key) {
        long stamp = this.writeLock();
        int idx = key >>> 6;
        if (this.data.length > idx) {
            this.data[idx] = this.data[idx] & (1L << (key & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
        }
        this.unlockWrite(stamp);
    }

    public void remove(SimpleBitSet other) {
        long stamp = this.writeLock();
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = this.data[i] & (other.data[i] ^ 0xFFFFFFFFFFFFFFFFL);
        }
        this.unlockWrite(stamp);
    }

    public long checkPointAndPut(long checkPoint, int key) {
        if (!this.validate(checkPoint) || (long)key != this.lastCheckPointKey) {
            long stamp = this.writeLock();
            int idx = key >>> 6;
            if (idx < this.data.length) {
                Arrays.fill(this.data, 0L);
            } else {
                int len = this.data.length;
                len = this.findNewLength(idx, len);
                this.data = new long[len];
            }
            this.data[idx] = this.data[idx] | 1L << (key & 0x3F);
            this.lastCheckPointKey = key;
            checkPoint = this.tryConvertToOptimisticRead(stamp);
        }
        return checkPoint;
    }

    private int findNewLength(int idx, int len) {
        while (len <= idx) {
            len *= 2;
        }
        return len;
    }

    public int size() {
        int size = 0;
        for (int i = 0; i < this.data.length; ++i) {
            size += Long.bitCount(this.data[i]);
        }
        return size;
    }

    private void ensureCapacity(int arrayIndex) {
        this.data = Arrays.copyOf(this.data, this.findNewLength(arrayIndex, this.data.length));
    }

    public PrimitiveIntIterator iterator() {
        return new PrimitiveIntIterator(){
            private int next;
            private final int size;
            {
                this.size = SimpleBitSet.this.data.length * 64;
                while (this.next < this.size && !SimpleBitSet.this.contains(this.next)) {
                    ++this.next;
                }
            }

            public boolean hasNext() {
                return this.next < this.size;
            }

            public int next() {
                int current = this.next++;
                while (this.next < this.size && !SimpleBitSet.this.contains(this.next)) {
                    ++this.next;
                }
                return current;
            }
        };
    }
}

