/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.unsafe.impl.batchimport.input.Group;
import org.neo4j.unsafe.impl.batchimport.input.HeaderException;

public class Groups {
    private final Map<String, Group> byName = new HashMap<String, Group>();
    private int nextId;
    private Boolean globalMode;

    public synchronized Group getOrCreate(String name) {
        boolean global;
        boolean bl = global = name == null;
        if (this.globalMode == null) {
            this.globalMode = global;
        } else if (global != this.globalMode) {
            throw this.mixingOfGroupModesException();
        }
        if (name == null) {
            return Group.GLOBAL;
        }
        Group group = this.byName.get(name);
        if (group == null) {
            group = new Group.Adapter(this.nextId++, name);
            this.byName.put(name, group);
        }
        return group;
    }

    private IllegalStateException mixingOfGroupModesException() {
        return new IllegalStateException("Mixing specified and unspecified group belongings in a single import isn't supported");
    }

    public synchronized Group get(String name) {
        boolean global;
        boolean bl = global = name == null;
        if (this.globalMode != null && global != this.globalMode) {
            throw this.mixingOfGroupModesException();
        }
        if (name == null) {
            return Group.GLOBAL;
        }
        Group group = this.byName.get(name);
        if (group == null) {
            throw new HeaderException("Group '" + name + "' not found. Available groups are: " + this.groupNames());
        }
        return group;
    }

    private String groupNames() {
        return Arrays.toString(this.byName.keySet().toArray(new String[this.byName.keySet().size()]));
    }
}

