/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration;

import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.neo4j.graphdb.config.BaseSetting;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.kernel.configuration.BoltConnector;
import org.neo4j.kernel.configuration.Connector;
import org.neo4j.kernel.configuration.ConnectorValidator;
import org.neo4j.kernel.configuration.Settings;

public class BoltConnectorValidator
extends ConnectorValidator {
    public BoltConnectorValidator() {
        super(Connector.ConnectorType.BOLT);
    }

    @Override
    @Nonnull
    protected Optional<Setting<Object>> getSettingFor(@Nonnull String settingName, @Nonnull Map<String, String> params) {
        BaseSetting setting;
        String subsetting;
        String[] parts = settingName.split("\\.");
        String name = parts[2];
        switch (subsetting = parts[3]) {
            case "enabled": {
                setting = (BaseSetting)Settings.setting(settingName, Settings.BOOLEAN, "false");
                setting.setDescription("Enable this connector.");
                break;
            }
            case "type": {
                setting = (BaseSetting)Settings.setting(settingName, Settings.options(Connector.ConnectorType.class), Settings.NO_DEFAULT);
                setting.setDeprecated(true);
                setting.setDescription("Connector type. This setting is deprecated and its value will instead be inferred from the name of the connector.");
                break;
            }
            case "tls_level": {
                setting = (BaseSetting)Settings.setting(settingName, Settings.options(BoltConnector.EncryptionLevel.class), BoltConnector.EncryptionLevel.OPTIONAL.name());
                setting.setDescription("Encryption level to require this connector to use.");
                break;
            }
            case "address": {
                setting = Settings.listenAddress(settingName, 7687);
                setting.setDeprecated(true);
                setting.setReplacement("dbms.connector." + name + ".listen_address");
                setting.setDescription("Address the connector should bind to. Deprecated and replaced by " + setting.replacement().get() + ".");
                break;
            }
            case "listen_address": {
                setting = Settings.listenAddress(settingName, 7687);
                setting.setDescription("Address the connector should bind to.");
                break;
            }
            case "advertised_address": {
                setting = Settings.advertisedAddress(settingName, Settings.listenAddress(settingName, 7687));
                setting.setDescription("Advertised address for this connector.");
                break;
            }
            case "thread_pool_core_size": {
                setting = (BaseSetting)Settings.setting(settingName, Settings.INTEGER, Settings.NO_DEFAULT);
                setting.setDescription("The number of threads to keep in the thread pool bound to this connector, even if they are idle.");
                break;
            }
            case "thread_pool_max_size": {
                setting = (BaseSetting)Settings.setting(settingName, Settings.INTEGER, Settings.NO_DEFAULT);
                setting.setDescription("The maximum number of threads allowed in the thread pool bound to this connector.");
                break;
            }
            case "thread_pool_keep_alive": {
                setting = (BaseSetting)Settings.setting(settingName, Settings.DURATION, Settings.NO_DEFAULT);
                setting.setDescription("The maximum time an idle thread in the thread pool bound to this connector will wait for new tasks.");
                break;
            }
            case "thread_pool_queue_size": {
                setting = (BaseSetting)Settings.setting(settingName, Settings.INTEGER, Settings.NO_DEFAULT);
                setting.setDescription("The queue size of the thread pool bound to this connector (-1 for unbounded, 0 for direct handoff, > 0 for bounded)");
                break;
            }
            default: {
                return Optional.empty();
            }
        }
        if (this.isDeprecatedConnectorName(name) && !setting.deprecated()) {
            setting.setDeprecated(true);
            setting.setReplacement(String.format("%s.%s.%s.%s", parts[0], parts[1], "bolt", subsetting));
        }
        return Optional.of(setting);
    }
}

