/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.schema;

import java.util.Iterator;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveIntSet;
import org.neo4j.function.ThrowingBiConsumer;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptorSupplier;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.operations.EntityReadOperations;
import org.neo4j.storageengine.api.NodeItem;

public class NodeSchemaMatcher {
    private final EntityReadOperations readOps;

    public NodeSchemaMatcher(EntityReadOperations readOps) {
        this.readOps = readOps;
    }

    public <SUPPLIER extends SchemaDescriptorSupplier, EXCEPTION extends Exception> void onMatchingSchema(KernelStatement state, Iterator<SUPPLIER> schemaSuppliers, NodeItem node, int specialPropertyId, ThrowingBiConsumer<SUPPLIER, PrimitiveIntSet, EXCEPTION> callback) throws EXCEPTION {
        PrimitiveIntSet nodePropertyIds = null;
        while (schemaSuppliers.hasNext()) {
            SchemaDescriptorSupplier schemaSupplier = (SchemaDescriptorSupplier)schemaSuppliers.next();
            SchemaDescriptor schema = schemaSupplier.schema();
            if (!node.labels().contains(schema.keyId())) continue;
            if (nodePropertyIds == null) {
                nodePropertyIds = Primitive.intSet();
                nodePropertyIds.addAll(this.readOps.nodeGetPropertyKeys(state, node).iterator());
            }
            if (!NodeSchemaMatcher.nodeHasSchemaProperties(nodePropertyIds, schema.getPropertyIds(), specialPropertyId)) continue;
            callback.accept((Object)schemaSupplier, (Object)nodePropertyIds);
        }
    }

    public static boolean nodeHasSchemaProperties(PrimitiveIntSet nodeProperties, int[] indexPropertyIds, int changedPropertyId) {
        for (int indexPropertyId : indexPropertyIds) {
            if (indexPropertyId == changedPropertyId || nodeProperties.contains(indexPropertyId)) continue;
            return false;
        }
        return true;
    }
}

