/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Header;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.impl.index.schema.NativeSchemaValue;
import org.neo4j.kernel.impl.index.schema.SpatialIndexCache;
import org.neo4j.kernel.impl.index.schema.SpatialLayout;
import org.neo4j.kernel.impl.index.schema.SpatialSchemaKey;
import org.neo4j.kernel.impl.index.schema.config.SpaceFillingCurveSettings;
import org.neo4j.kernel.impl.index.schema.config.SpaceFillingCurveSettingsFactory;
import org.neo4j.values.storable.CoordinateReferenceSystem;

class SpatialIndexFiles {
    private static final Pattern CRS_DIR_PATTERN = Pattern.compile("(\\d+)-(\\d+)");
    private final FileSystemAbstraction fs;
    private final SpaceFillingCurveSettingsFactory settingsFactory;
    private final File indexDirectory;

    SpatialIndexFiles(IndexDirectoryStructure directoryStructure, long indexId, FileSystemAbstraction fs, SpaceFillingCurveSettingsFactory settingsFactory) {
        this.fs = fs;
        this.settingsFactory = settingsFactory;
        this.indexDirectory = directoryStructure.directoryForIndex(indexId);
    }

    Iterable<SpatialFileLayout> existing() {
        ArrayList<SpatialFileLayout> existing = new ArrayList<SpatialFileLayout>();
        this.addExistingFiles(existing);
        return existing;
    }

    <T, E extends Exception> void loadExistingIndexes(SpatialIndexCache<T, E> indexCache) throws E {
        for (SpatialFileLayout fileLayout : this.existing()) {
            indexCache.select(fileLayout.crs);
        }
    }

    SpatialFileLayout forCrs(CoordinateReferenceSystem crs) {
        return new SpatialFileLayout(crs, this.settingsFactory.settingsFor(crs), this.indexDirectory);
    }

    private void addExistingFiles(List<SpatialFileLayout> existing) {
        File[] files = this.fs.listFiles(this.indexDirectory);
        if (files != null) {
            for (File file : files) {
                String name = file.getName();
                Matcher matcher = CRS_DIR_PATTERN.matcher(name);
                if (!matcher.matches()) continue;
                int tableId = Integer.parseInt(matcher.group(1));
                int code = Integer.parseInt(matcher.group(2));
                CoordinateReferenceSystem crs = CoordinateReferenceSystem.get((int)tableId, (int)code);
                existing.add(this.forCrs(crs));
            }
        }
    }

    static class SpatialFileLayout {
        final File indexFile;
        final SpaceFillingCurveSettings settings;
        private final CoordinateReferenceSystem crs;
        Layout<SpatialSchemaKey, NativeSchemaValue> layout;

        private SpatialFileLayout(CoordinateReferenceSystem crs, SpaceFillingCurveSettings settings, File indexDirectory) {
            this.crs = crs;
            this.settings = settings;
            this.layout = new SpatialLayout(crs, settings.curve());
            String s = crs.getTable().getTableId() + "-" + Integer.toString(crs.getCode());
            this.indexFile = new File(indexDirectory, s);
        }

        public void readHeader(PageCache pageCache) throws IOException {
            GBPTree.readHeader((PageCache)pageCache, (File)this.indexFile, (Header.Reader)this.settings.headerReader());
            this.layout = new SpatialLayout(this.crs, this.settings.curve());
        }
    }
}

