/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.config;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.function.Consumer;
import org.neo4j.gis.spatial.index.Envelope;
import org.neo4j.gis.spatial.index.curves.HilbertSpaceFillingCurve2D;
import org.neo4j.gis.spatial.index.curves.HilbertSpaceFillingCurve3D;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurve;
import org.neo4j.index.internal.gbptree.Header;
import org.neo4j.io.pagecache.PageCursor;

public class SpaceFillingCurveSettings {
    private int dimensions;
    private int maxLevels;
    private Envelope extents;

    public SpaceFillingCurveSettings(int dimensions, int maxBits, Envelope extents) {
        this.dimensions = dimensions;
        this.extents = extents;
        int maxConfigured = maxBits / dimensions;
        int maxSupported = dimensions == 2 ? 30 : 20;
        this.maxLevels = Math.min(maxConfigured, maxSupported);
    }

    public int getDimensions() {
        return this.dimensions;
    }

    public int maxLevels() {
        return this.maxLevels;
    }

    public Envelope indexExtents() {
        return this.extents;
    }

    public SpaceFillingCurve curve() {
        if (this.dimensions == 2) {
            return new HilbertSpaceFillingCurve2D(this.extents, this.maxLevels);
        }
        if (this.dimensions == 3) {
            return new HilbertSpaceFillingCurve3D(this.extents, this.maxLevels);
        }
        throw new IllegalArgumentException("Cannot create spatial index with other than 2D or 3D coordinate reference system: " + this.dimensions + "D");
    }

    public String toString() {
        return String.format("Space filling curves settings: dimensions=%d, maxLevels=%d, min=%s, max=%s", this.dimensions, this.maxLevels, Arrays.toString(this.extents.getMin()), Arrays.toString(this.extents.getMax()));
    }

    public Consumer<PageCursor> headerWriter(byte initialIndexState) {
        return cursor -> {
            cursor.putByte(initialIndexState);
            cursor.putInt(SpatialIndexType.SingleSpaceFillingCurve.id);
            SpatialIndexType.SingleSpaceFillingCurve.writeHeader(this, (PageCursor)cursor);
        };
    }

    public Header.Reader headerReader() {
        return headerBytes -> {
            headerBytes.get();
            int typeId = headerBytes.getInt();
            SpatialIndexType indexType = SpatialIndexType.get(typeId);
            if (indexType == null) {
                throw new IllegalArgumentException("Unknown spatial index type: " + typeId);
            }
            indexType.readHeader(this, headerBytes);
        };
    }

    private static enum SpatialIndexType {
        SingleSpaceFillingCurve(1){

            @Override
            public void writeHeader(SpaceFillingCurveSettings settings, PageCursor cursor) {
                cursor.putInt(settings.maxLevels);
                cursor.putInt(settings.dimensions);
                double[] min = settings.extents.getMin();
                double[] max = settings.extents.getMax();
                for (int i = 0; i < settings.dimensions; ++i) {
                    cursor.putLong(Double.doubleToLongBits(min[i]));
                    cursor.putLong(Double.doubleToLongBits(max[i]));
                }
            }

            @Override
            public void readHeader(SpaceFillingCurveSettings settings, ByteBuffer headerBytes) {
                settings.maxLevels = headerBytes.getInt();
                settings.dimensions = headerBytes.getInt();
                double[] min = new double[settings.dimensions];
                double[] max = new double[settings.dimensions];
                for (int i = 0; i < settings.dimensions; ++i) {
                    min[i] = headerBytes.getDouble();
                    max[i] = headerBytes.getDouble();
                }
                settings.extents = new Envelope(min, max);
            }
        };

        private int id;

        public abstract void writeHeader(SpaceFillingCurveSettings var1, PageCursor var2);

        public abstract void readHeader(SpaceFillingCurveSettings var1, ByteBuffer var2);

        private SpatialIndexType(int id) {
            this.id = id;
        }

        static SpatialIndexType get(int id) {
            for (SpatialIndexType type : SpatialIndexType.values()) {
                if (type.id != id) continue;
                return type;
            }
            return null;
        }
    }
}

