/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.query;

import java.util.function.Supplier;
import org.neo4j.function.Suppliers;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.internal.kernel.api.Kernel;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.query.ExecutingQuery;
import org.neo4j.kernel.guard.Guard;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.coreapi.PropertyContainerLocker;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.query.Neo4jTransactionalContext;
import org.neo4j.kernel.impl.query.TransactionalContextFactory;
import org.neo4j.kernel.impl.query.clientconnection.ClientConnectionInfo;
import org.neo4j.values.virtual.MapValue;

public class Neo4jTransactionalContextFactory
implements TransactionalContextFactory {
    private final Supplier<Statement> statementSupplier;
    private final Neo4jTransactionalContext.Creator contextCreator;

    public static TransactionalContextFactory create(GraphDatabaseFacade.SPI spi, Guard guard, ThreadToStatementContextBridge txBridge, PropertyContainerLocker locker) {
        Suppliers.Lazy queryService = Suppliers.lazySingleton(spi::queryService);
        Suppliers.Lazy kernel = Suppliers.lazySingleton(spi::kernel);
        Neo4jTransactionalContext.Creator contextCreator = (arg_0, arg_1, arg_2, arg_3) -> Neo4jTransactionalContextFactory.lambda$create$0((Supplier)queryService, guard, txBridge, locker, (Supplier)kernel, arg_0, arg_1, arg_2, arg_3);
        return new Neo4jTransactionalContextFactory(txBridge, contextCreator);
    }

    @Deprecated
    public static TransactionalContextFactory create(GraphDatabaseQueryService queryService, PropertyContainerLocker locker) {
        DependencyResolver resolver = queryService.getDependencyResolver();
        ThreadToStatementContextBridge txBridge = (ThreadToStatementContextBridge)resolver.resolveDependency(ThreadToStatementContextBridge.class);
        Kernel kernel = (Kernel)resolver.resolveDependency(Kernel.class);
        Guard guard = (Guard)resolver.resolveDependency(Guard.class);
        Neo4jTransactionalContext.Creator contextCreator = (statementSupplier, tx, initialStatement, executingQuery) -> new Neo4jTransactionalContext(queryService, statementSupplier, guard, txBridge, locker, tx, initialStatement, executingQuery, kernel);
        return new Neo4jTransactionalContextFactory(txBridge, contextCreator);
    }

    private Neo4jTransactionalContextFactory(Supplier<Statement> statementSupplier, Neo4jTransactionalContext.Creator contextCreator) {
        this.statementSupplier = statementSupplier;
        this.contextCreator = contextCreator;
    }

    @Override
    public final Neo4jTransactionalContext newContext(ClientConnectionInfo clientConnection, InternalTransaction tx, String queryText, MapValue queryParameters) {
        Statement initialStatement = this.statementSupplier.get();
        ClientConnectionInfo connectionWithUserName = clientConnection.withUsername(tx.securityContext().subject().username());
        ExecutingQuery executingQuery = initialStatement.queryRegistration().startQueryExecution(connectionWithUserName, queryText, queryParameters);
        return this.contextCreator.create(this.statementSupplier, tx, initialStatement, executingQuery);
    }

    private static /* synthetic */ Neo4jTransactionalContext lambda$create$0(Supplier queryService, Guard guard, ThreadToStatementContextBridge txBridge, PropertyContainerLocker locker, Supplier kernel, Supplier statementSupplier, InternalTransaction tx, Statement initialStatement, ExecutingQuery executingQuery) {
        return new Neo4jTransactionalContext((GraphDatabaseQueryService)queryService.get(), statementSupplier, guard, txBridge, locker, tx, initialStatement, executingQuery, (Kernel)kernel.get());
    }
}

