/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.collection.PrimitiveLongResourceIterator;
import org.neo4j.cursor.RawCursor;
import org.neo4j.index.internal.gbptree.Hit;
import org.neo4j.kernel.impl.index.schema.NativeSchemaKey;
import org.neo4j.kernel.impl.index.schema.NativeSchemaValue;
import org.neo4j.values.storable.Value;

public class NativeHitIterator<KEY extends NativeSchemaKey<KEY>, VALUE extends NativeSchemaValue>
extends PrimitiveLongCollections.PrimitiveLongBaseIterator
implements PrimitiveLongResourceIterator {
    private final RawCursor<Hit<KEY, VALUE>, IOException> seeker;
    private final Collection<RawCursor<Hit<KEY, VALUE>, IOException>> toRemoveFromWhenExhausted;
    private boolean closed;

    NativeHitIterator(RawCursor<Hit<KEY, VALUE>, IOException> seeker, Collection<RawCursor<Hit<KEY, VALUE>, IOException>> toRemoveFromWhenExhausted) {
        this.seeker = seeker;
        this.toRemoveFromWhenExhausted = toRemoveFromWhenExhausted;
    }

    protected boolean fetchNext() {
        try {
            while (this.seeker.next()) {
                NativeSchemaKey key = (NativeSchemaKey)((Object)((Hit)this.seeker.get()).key());
                if (!this.acceptValue(key.asValue())) continue;
                return this.next(key.getEntityId());
            }
            return false;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    boolean acceptValue(Value value) {
        return true;
    }

    private void ensureCursorClosed() throws IOException {
        if (!this.closed) {
            this.seeker.close();
            this.toRemoveFromWhenExhausted.remove(this.seeker);
            this.closed = true;
        }
    }

    public void close() {
        try {
            this.ensureCursorClosed();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

