/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.function.Consumer;
import org.neo4j.helpers.Format;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.impl.index.schema.NativeSchemaKey;
import org.neo4j.kernel.impl.index.schema.NativeSchemaValue;

abstract class NativeSchemaIndex<KEY extends NativeSchemaKey<KEY>, VALUE extends NativeSchemaValue> {
    final PageCache pageCache;
    final File storeFile;
    final Layout<KEY, VALUE> layout;
    final FileSystemAbstraction fileSystem;
    final SchemaIndexDescriptor descriptor;
    private final long indexId;
    private final IndexProvider.Monitor monitor;
    protected GBPTree<KEY, VALUE> tree;

    NativeSchemaIndex(PageCache pageCache, FileSystemAbstraction fs, File storeFile, Layout<KEY, VALUE> layout, IndexProvider.Monitor monitor, SchemaIndexDescriptor descriptor, long indexId) {
        this.pageCache = pageCache;
        this.storeFile = storeFile;
        this.layout = layout;
        this.fileSystem = fs;
        this.descriptor = descriptor;
        this.indexId = indexId;
        this.monitor = monitor;
    }

    void instantiateTree(RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, Consumer<PageCursor> headerWriter) throws IOException {
        this.ensureDirectoryExist();
        GBPTree.Monitor monitor = this.treeMonitor();
        this.tree = new GBPTree(this.pageCache, this.storeFile, this.layout, 0, monitor, GBPTree.NO_HEADER_READER, headerWriter, recoveryCleanupWorkCollector);
    }

    private GBPTree.Monitor treeMonitor() {
        return new GBPTree.Monitor.Adaptor(){

            public void cleanupFinished(long numberOfPagesVisited, long numberOfCleanedCrashPointers, long durationMillis) {
                NativeSchemaIndex.this.monitor.recoveryCompleted(NativeSchemaIndex.this.descriptor, NativeSchemaIndex.this.storeFile.getAbsolutePath(), MapUtil.map((Object[])new Object[]{"Number of pages visited", numberOfPagesVisited, "Number of cleaned crashed pointers", numberOfCleanedCrashPointers, "Time spent", Format.duration(durationMillis)}));
            }
        };
    }

    private void ensureDirectoryExist() throws IOException {
        this.fileSystem.mkdirs(this.storeFile.getParentFile());
    }

    void closeTree() throws IOException {
        this.tree = this.closeIfPresent((Closeable)this.tree);
    }

    private <T extends Closeable> T closeIfPresent(T closeable) throws IOException {
        if (closeable != null) {
            closeable.close();
        }
        return null;
    }

    void assertOpen() {
        if (this.tree == null) {
            throw new IllegalStateException("Index has been closed");
        }
    }
}

