/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import org.neo4j.gis.spatial.index.curves.PartialOverlapConfiguration;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurveConfiguration;
import org.neo4j.gis.spatial.index.curves.StandardConfiguration;
import org.neo4j.index.internal.gbptree.MetadataMismatchException;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.kernel.api.IndexCapability;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexValueCapability;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.index.schema.NativeSchemaIndexes;
import org.neo4j.kernel.impl.index.schema.SpatialIndexAccessor;
import org.neo4j.kernel.impl.index.schema.SpatialIndexFiles;
import org.neo4j.kernel.impl.index.schema.SpatialIndexPopulator;
import org.neo4j.kernel.impl.index.schema.config.SpaceFillingCurveSettingsFactory;
import org.neo4j.kernel.impl.index.schema.config.SpatialIndexSettings;
import org.neo4j.kernel.impl.storemigration.StoreMigrationParticipant;
import org.neo4j.values.storable.ValueCategory;

public class SpatialIndexProvider
extends IndexProvider {
    public static final String KEY = "spatial";
    static final IndexCapability CAPABILITY = new SpatialIndexCapability();
    private static final IndexProvider.Descriptor SPATIAL_PROVIDER_DESCRIPTOR = new IndexProvider.Descriptor("spatial", "1.0");
    private final PageCache pageCache;
    private final FileSystemAbstraction fs;
    private final IndexProvider.Monitor monitor;
    private final RecoveryCleanupWorkCollector recoveryCleanupWorkCollector;
    private final boolean readOnly;
    private final SpaceFillingCurveConfiguration configuration;
    private final SpaceFillingCurveSettingsFactory settingsFactory;

    public SpatialIndexProvider(PageCache pageCache, FileSystemAbstraction fs, IndexDirectoryStructure.Factory directoryStructure, IndexProvider.Monitor monitor, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, boolean readOnly, Config config) {
        super(SPATIAL_PROVIDER_DESCRIPTOR, 0, directoryStructure);
        this.pageCache = pageCache;
        this.fs = fs;
        this.monitor = monitor;
        this.recoveryCleanupWorkCollector = recoveryCleanupWorkCollector;
        this.readOnly = readOnly;
        this.configuration = SpatialIndexProvider.getConfiguredSpaceFillingCurveConfiguration(config);
        this.settingsFactory = this.getConfiguredSpaceFillingCurveSettings(config);
    }

    private SpaceFillingCurveSettingsFactory getConfiguredSpaceFillingCurveSettings(Config config) {
        return new SpaceFillingCurveSettingsFactory(config);
    }

    private static SpaceFillingCurveConfiguration getConfiguredSpaceFillingCurveConfiguration(Config config) {
        int extraLevels = config.get(SpatialIndexSettings.space_filling_curve_extra_levels);
        double topThreshold = config.get(SpatialIndexSettings.space_filling_curve_top_threshold);
        double bottomThreshold = config.get(SpatialIndexSettings.space_filling_curve_bottom_threshold);
        if (topThreshold == 0.0 || bottomThreshold == 0.0) {
            return new StandardConfiguration(extraLevels);
        }
        return new PartialOverlapConfiguration(extraLevels, topThreshold, bottomThreshold);
    }

    @Override
    public IndexPopulator getPopulator(long indexId, SchemaIndexDescriptor descriptor, IndexSamplingConfig samplingConfig) {
        if (this.readOnly) {
            throw new UnsupportedOperationException("Can't create populator for read only index");
        }
        SpatialIndexFiles files = new SpatialIndexFiles(this.directoryStructure(), indexId, this.fs, this.settingsFactory);
        return new SpatialIndexPopulator(indexId, descriptor, samplingConfig, files, this.pageCache, this.fs, this.monitor, this.configuration);
    }

    @Override
    public IndexAccessor getOnlineAccessor(long indexId, SchemaIndexDescriptor descriptor, IndexSamplingConfig samplingConfig) throws IOException {
        SpatialIndexFiles files = new SpatialIndexFiles(this.directoryStructure(), indexId, this.fs, this.settingsFactory);
        return new SpatialIndexAccessor(indexId, descriptor, samplingConfig, this.pageCache, this.fs, this.recoveryCleanupWorkCollector, this.monitor, files, this.configuration);
    }

    @Override
    public String getPopulationFailure(long indexId, SchemaIndexDescriptor descriptor) throws IllegalStateException {
        SpatialIndexFiles spatialIndexFiles = new SpatialIndexFiles(this.directoryStructure(), indexId, this.fs, this.settingsFactory);
        try {
            for (SpatialIndexFiles.SpatialFileLayout subIndex : spatialIndexFiles.existing()) {
                String indexFailure = NativeSchemaIndexes.readFailureMessage(this.pageCache, subIndex.indexFile);
                if (indexFailure == null) continue;
                return indexFailure;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        throw new IllegalStateException("Index " + indexId + " isn't failed");
    }

    @Override
    public InternalIndexState getInitialState(long indexId, SchemaIndexDescriptor descriptor) {
        SpatialIndexFiles spatialIndexFiles = new SpatialIndexFiles(this.directoryStructure(), indexId, this.fs, this.settingsFactory);
        Iterable<SpatialIndexFiles.SpatialFileLayout> existing = spatialIndexFiles.existing();
        InternalIndexState state = InternalIndexState.ONLINE;
        for (SpatialIndexFiles.SpatialFileLayout subIndex : existing) {
            try {
                switch (NativeSchemaIndexes.readState(this.pageCache, subIndex.indexFile)) {
                    case FAILED: {
                        return InternalIndexState.FAILED;
                    }
                    case POPULATING: {
                        state = InternalIndexState.POPULATING;
                    }
                }
            }
            catch (IOException | MetadataMismatchException e) {
                this.monitor.failedToOpenIndex(indexId, descriptor, "Requesting re-population.", (Exception)e);
                return InternalIndexState.POPULATING;
            }
        }
        return state;
    }

    @Override
    public IndexCapability getCapability(SchemaIndexDescriptor indexDescriptor) {
        return CAPABILITY;
    }

    @Override
    public StoreMigrationParticipant storeMigrationParticipant(FileSystemAbstraction fs, PageCache pageCache) {
        return StoreMigrationParticipant.NOT_PARTICIPATING;
    }

    private static class SpatialIndexCapability
    implements IndexCapability {
        private SpatialIndexCapability() {
        }

        public IndexOrder[] orderCapability(ValueCategory ... valueCategories) {
            return ORDER_NONE;
        }

        public IndexValueCapability valueCapability(ValueCategory ... valueCategories) {
            return IndexValueCapability.NO;
        }
    }
}

