/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.participant;

import java.io.IOException;
import org.neo4j.kernel.api.AssertOpen;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.StorePropertyCursor;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.RecordCursor;
import org.neo4j.kernel.impl.store.RecordCursors;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.unsafe.impl.batchimport.input.InputChunk;
import org.neo4j.unsafe.impl.batchimport.input.InputEntityVisitor;

abstract class StoreScanChunk<T extends PrimitiveRecord>
implements InputChunk {
    protected final StorePropertyCursor storePropertyCursor;
    protected final RecordCursors recordCursors;
    private final RecordCursor<T> cursor;
    private final boolean requiresPropertyMigration;
    private long id;
    private long endId;

    StoreScanChunk(RecordCursor<T> cursor, NeoStores neoStores, boolean requiresPropertyMigration) {
        this.cursor = cursor;
        this.recordCursors = new RecordCursors(neoStores);
        this.requiresPropertyMigration = requiresPropertyMigration;
        this.storePropertyCursor = new StorePropertyCursor(this.recordCursors, ignored -> {});
    }

    void visitProperties(T record, InputEntityVisitor visitor) {
        if (!this.requiresPropertyMigration) {
            visitor.propertyId(((PrimitiveRecord)record).getNextProp());
        } else {
            this.storePropertyCursor.init(((PrimitiveRecord)record).getNextProp(), LockService.NO_LOCK, AssertOpen.ALWAYS_OPEN);
            while (this.storePropertyCursor.next()) {
                visitor.property(this.storePropertyCursor.propertyKeyId(), this.storePropertyCursor.value().asObject());
            }
            this.storePropertyCursor.close();
        }
    }

    @Override
    public void close() {
        this.recordCursors.close();
        this.cursor.close();
    }

    @Override
    public boolean next(InputEntityVisitor visitor) throws IOException {
        if (this.id < this.endId) {
            if (this.cursor.next(this.id)) {
                this.visitRecord((PrimitiveRecord)this.cursor.get(), visitor);
                visitor.endOfEntity();
            }
            ++this.id;
            return true;
        }
        return false;
    }

    public void initialize(long startId, long endId) {
        this.id = startId;
        this.endId = endId;
    }

    abstract void visitRecord(T var1, InputEntityVisitor var2);
}

