/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.command;

import org.neo4j.kernel.impl.api.BatchTransactionApplier;
import org.neo4j.kernel.impl.api.TransactionApplier;
import org.neo4j.kernel.impl.core.CacheAccessBackDoor;
import org.neo4j.kernel.impl.locking.LockGroup;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.command.NeoStoreTransactionApplier;
import org.neo4j.storageengine.api.CommandsToApply;

public class NeoStoreBatchTransactionApplier
extends BatchTransactionApplier.Adapter {
    private final Command.Version version;
    private final NeoStores neoStores;
    private final CacheAccessBackDoor cacheAccess;
    private final LockService lockService;

    public NeoStoreBatchTransactionApplier(NeoStores store, CacheAccessBackDoor cacheAccess, LockService lockService) {
        this(Command.Version.AFTER, store, cacheAccess, lockService);
    }

    public NeoStoreBatchTransactionApplier(Command.Version version, NeoStores store, CacheAccessBackDoor cacheAccess, LockService lockService) {
        this.version = version;
        this.neoStores = store;
        this.cacheAccess = cacheAccess;
        this.lockService = lockService;
    }

    @Override
    public TransactionApplier startTx(CommandsToApply transaction) {
        throw new RuntimeException("NeoStoreTransactionApplier requires a LockGroup");
    }

    @Override
    public TransactionApplier startTx(CommandsToApply transaction, LockGroup lockGroup) {
        return new NeoStoreTransactionApplier(this.version, this.neoStores, this.cacheAccess, this.lockService, transaction.transactionId(), lockGroup);
    }
}

