/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.map.primitive.LongObjectMap;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.impl.api.index.IndexingUpdateService;
import org.neo4j.kernel.impl.api.index.NodeUpdates;
import org.neo4j.kernel.impl.api.index.PropertyPhysicalToLogicalConverter;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.state.IndexUpdates;

public class OnlineIndexUpdates
implements IndexUpdates {
    private final NodeStore nodeStore;
    private final IndexingUpdateService updateService;
    private final PropertyPhysicalToLogicalConverter converter;
    private final Collection<IndexEntryUpdate<SchemaDescriptor>> updates = new ArrayList<IndexEntryUpdate<SchemaDescriptor>>();
    private NodeRecord nodeRecord;

    public OnlineIndexUpdates(NodeStore nodeStore, IndexingUpdateService updateService, PropertyPhysicalToLogicalConverter converter) {
        this.nodeStore = nodeStore;
        this.updateService = updateService;
        this.converter = converter;
    }

    @Override
    public Iterator<IndexEntryUpdate<SchemaDescriptor>> iterator() {
        return this.updates.iterator();
    }

    @Override
    public void feed(LongObjectMap<List<Command.PropertyCommand>> propertyCommands, LongObjectMap<Command.NodeCommand> nodeCommands) {
        this.allKeys(nodeCommands, propertyCommands).forEach((LongProcedure & Serializable)nodeId -> this.gatherUpdatesFor(nodeId, (Command.NodeCommand)nodeCommands.get(nodeId), (List)propertyCommands.get(nodeId)));
    }

    private LongSet allKeys(LongObjectMap ... maps) {
        LongHashSet keys = new LongHashSet();
        for (LongObjectMap map : maps) {
            keys.addAll((LongIterable)map.keySet());
        }
        return keys;
    }

    @Override
    public boolean hasUpdates() {
        return !this.updates.isEmpty();
    }

    private void gatherUpdatesFor(long nodeId, Command.NodeCommand nodeCommand, List<Command.PropertyCommand> propertyCommands) {
        NodeUpdates.Builder nodePropertyUpdate = this.gatherUpdatesFromCommandsForNode(nodeId, nodeCommand, propertyCommands);
        NodeUpdates nodeUpdates = nodePropertyUpdate.build();
        for (IndexEntryUpdate<SchemaDescriptor> update : this.updateService.convertToIndexUpdates(nodeUpdates)) {
            this.updates.add(update);
        }
    }

    private NodeUpdates.Builder gatherUpdatesFromCommandsForNode(long nodeId, Command.NodeCommand nodeChanges, List<Command.PropertyCommand> propertyCommandsForNode) {
        long[] nodeLabelsAfter;
        long[] nodeLabelsBefore;
        if (nodeChanges != null) {
            nodeLabelsBefore = NodeLabelsField.parseLabelsField((NodeRecord)nodeChanges.getBefore()).get(this.nodeStore);
            nodeLabelsAfter = NodeLabelsField.parseLabelsField((NodeRecord)nodeChanges.getAfter()).get(this.nodeStore);
        } else {
            NodeRecord nodeRecord = this.loadNode(nodeId);
            nodeLabelsBefore = nodeLabelsAfter = NodeLabelsField.parseLabelsField(nodeRecord).get(this.nodeStore);
        }
        NodeUpdates.Builder nodePropertyUpdates = NodeUpdates.forNode(nodeId, nodeLabelsBefore, nodeLabelsAfter);
        if (propertyCommandsForNode != null) {
            this.converter.convertPropertyRecord(nodeId, Iterables.cast(propertyCommandsForNode), nodePropertyUpdates);
        }
        return nodePropertyUpdates;
    }

    private NodeRecord loadNode(long nodeId) {
        if (this.nodeRecord == null) {
            this.nodeRecord = (NodeRecord)this.nodeStore.newRecord();
        }
        this.nodeStore.getRecord(nodeId, this.nodeRecord, RecordLoad.NORMAL);
        return this.nodeRecord;
    }
}

