/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.schema.constaints;

import org.neo4j.internal.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.RelationTypeSchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaComputer;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaUtil;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.api.schema.constaints.ConstraintDescriptor;
import org.neo4j.kernel.api.schema.constaints.NodeExistenceConstraintDescriptor;
import org.neo4j.kernel.api.schema.constaints.NodeKeyConstraintDescriptor;
import org.neo4j.kernel.api.schema.constaints.RelExistenceConstraintDescriptor;
import org.neo4j.kernel.api.schema.constaints.UniquenessConstraintDescriptor;

public class ConstraintDescriptorFactory {
    private static SchemaComputer<ConstraintDescriptor> convertToExistenceConstraint = new SchemaComputer<ConstraintDescriptor>(){

        public ConstraintDescriptor computeSpecific(LabelSchemaDescriptor schema) {
            return new NodeExistenceConstraintDescriptor(schema);
        }

        public ConstraintDescriptor computeSpecific(RelationTypeSchemaDescriptor schema) {
            return new RelExistenceConstraintDescriptor(schema);
        }

        public ConstraintDescriptor computeSpecific(SchemaDescriptor schema) {
            throw new UnsupportedOperationException(String.format("Cannot create existence constraint for schema '%s' of type %s", schema.userDescription(SchemaUtil.idTokenNameLookup), schema.getClass().getSimpleName()));
        }
    };
    private static SchemaComputer<UniquenessConstraintDescriptor> convertToUniquenessConstraint = new SchemaComputer<UniquenessConstraintDescriptor>(){

        public UniquenessConstraintDescriptor computeSpecific(LabelSchemaDescriptor schema) {
            return new UniquenessConstraintDescriptor(schema);
        }

        public UniquenessConstraintDescriptor computeSpecific(RelationTypeSchemaDescriptor schema) {
            throw new UnsupportedOperationException(String.format("Cannot create uniqueness constraint for schema '%s' of type %s", schema.userDescription(SchemaUtil.idTokenNameLookup), schema.getClass().getSimpleName()));
        }

        public UniquenessConstraintDescriptor computeSpecific(SchemaDescriptor schema) {
            throw new UnsupportedOperationException(String.format("Cannot create uniqueness constraint for schema '%s' of type %s", schema.userDescription(SchemaUtil.idTokenNameLookup), schema.getClass().getSimpleName()));
        }
    };
    private static SchemaComputer<NodeKeyConstraintDescriptor> convertToNodeKeyConstraint = new SchemaComputer<NodeKeyConstraintDescriptor>(){

        public NodeKeyConstraintDescriptor computeSpecific(LabelSchemaDescriptor schema) {
            return new NodeKeyConstraintDescriptor(schema);
        }

        public NodeKeyConstraintDescriptor computeSpecific(RelationTypeSchemaDescriptor schema) {
            throw new UnsupportedOperationException(String.format("Cannot create node key constraint for schema '%s' of type %s", schema.userDescription(SchemaUtil.idTokenNameLookup), schema.getClass().getSimpleName()));
        }

        public NodeKeyConstraintDescriptor computeSpecific(SchemaDescriptor schema) {
            throw new UnsupportedOperationException(String.format("Cannot create node key constraint for schema '%s' of type %s", schema.userDescription(SchemaUtil.idTokenNameLookup), schema.getClass().getSimpleName()));
        }
    };

    private ConstraintDescriptorFactory() {
    }

    public static NodeExistenceConstraintDescriptor existsForLabel(int labelId, int ... propertyIds) {
        return new NodeExistenceConstraintDescriptor(SchemaDescriptorFactory.forLabel(labelId, propertyIds));
    }

    public static RelExistenceConstraintDescriptor existsForRelType(int relTypeId, int ... propertyIds) {
        return new RelExistenceConstraintDescriptor(SchemaDescriptorFactory.forRelType(relTypeId, propertyIds));
    }

    public static UniquenessConstraintDescriptor uniqueForLabel(int labelId, int ... propertyIds) {
        return new UniquenessConstraintDescriptor(SchemaDescriptorFactory.forLabel(labelId, propertyIds));
    }

    public static NodeKeyConstraintDescriptor nodeKeyForLabel(int labelId, int ... propertyIds) {
        return new NodeKeyConstraintDescriptor(SchemaDescriptorFactory.forLabel(labelId, propertyIds));
    }

    public static ConstraintDescriptor existsForSchema(SchemaDescriptor schema) {
        return (ConstraintDescriptor)schema.computeWith(convertToExistenceConstraint);
    }

    public static NodeExistenceConstraintDescriptor existsForSchema(LabelSchemaDescriptor schema) {
        return new NodeExistenceConstraintDescriptor(schema);
    }

    public static RelExistenceConstraintDescriptor existsForSchema(RelationTypeSchemaDescriptor schema) {
        return new RelExistenceConstraintDescriptor(schema);
    }

    public static UniquenessConstraintDescriptor uniqueForSchema(SchemaDescriptor schema) {
        return (UniquenessConstraintDescriptor)schema.computeWith(convertToUniquenessConstraint);
    }

    public static NodeKeyConstraintDescriptor nodeKeyForSchema(SchemaDescriptor schema) {
        return (NodeKeyConstraintDescriptor)schema.computeWith(convertToNodeKeyConstraint);
    }
}

