/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.constraints;

import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.NodeLabelIndexCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.RelationTypeSchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.constraints.ConstraintDescriptor;
import org.neo4j.kernel.api.exceptions.schema.CreateConstraintFailureException;
import org.neo4j.kernel.api.schema.constaints.ConstraintDescriptorFactory;
import org.neo4j.kernel.api.schema.constaints.NodeKeyConstraintDescriptor;
import org.neo4j.kernel.api.schema.constaints.UniquenessConstraintDescriptor;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.store.record.ConstraintRule;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;
import org.neo4j.storageengine.api.txstate.TxStateVisitor;

public class StandardConstraintSemantics
implements ConstraintSemantics {
    public static final String ERROR_MESSAGE_EXISTS = "Property existence constraint requires Neo4j Enterprise Edition";
    public static final String ERROR_MESSAGE_NODE_KEY = "Node Key constraint requires Neo4j Enterprise Edition";

    @Override
    public void validateNodeKeyConstraint(NodeLabelIndexCursor allNodes, NodeCursor nodeCursor, PropertyCursor propertyCursor, LabelSchemaDescriptor descriptor) throws CreateConstraintFailureException {
        throw this.nodeKeyConstraintsNotAllowed((SchemaDescriptor)descriptor);
    }

    @Override
    public void validateNodePropertyExistenceConstraint(NodeLabelIndexCursor allNodes, NodeCursor nodeCursor, PropertyCursor propertyCursor, LabelSchemaDescriptor descriptor) throws CreateConstraintFailureException {
        throw this.propertyExistenceConstraintsNotAllowed((SchemaDescriptor)descriptor);
    }

    @Override
    public void validateRelationshipPropertyExistenceConstraint(RelationshipScanCursor relationshipCursor, PropertyCursor propertyCursor, RelationTypeSchemaDescriptor descriptor) throws CreateConstraintFailureException {
        throw this.propertyExistenceConstraintsNotAllowed((SchemaDescriptor)descriptor);
    }

    @Override
    public ConstraintDescriptor readConstraint(ConstraintRule rule) {
        ConstraintDescriptor desc = rule.getConstraintDescriptor();
        switch (desc.type()) {
            case EXISTS: {
                return this.readNonStandardConstraint(rule, ERROR_MESSAGE_EXISTS);
            }
            case UNIQUE_EXISTS: {
                return this.readNonStandardConstraint(rule, ERROR_MESSAGE_NODE_KEY);
            }
        }
        return desc;
    }

    protected ConstraintDescriptor readNonStandardConstraint(ConstraintRule rule, String errorMessage) {
        throw new IllegalStateException(errorMessage);
    }

    private CreateConstraintFailureException propertyExistenceConstraintsNotAllowed(SchemaDescriptor descriptor) {
        return new CreateConstraintFailureException((ConstraintDescriptor)ConstraintDescriptorFactory.existsForSchema(descriptor), ERROR_MESSAGE_EXISTS);
    }

    private CreateConstraintFailureException nodeKeyConstraintsNotAllowed(SchemaDescriptor descriptor) {
        return new CreateConstraintFailureException((ConstraintDescriptor)ConstraintDescriptorFactory.existsForSchema(descriptor), ERROR_MESSAGE_NODE_KEY);
    }

    @Override
    public ConstraintRule createUniquenessConstraintRule(long ruleId, UniquenessConstraintDescriptor descriptor, long indexId) {
        return ConstraintRule.constraintRule(ruleId, descriptor, indexId);
    }

    @Override
    public ConstraintRule createNodeKeyConstraintRule(long ruleId, NodeKeyConstraintDescriptor descriptor, long indexId) throws CreateConstraintFailureException {
        throw this.nodeKeyConstraintsNotAllowed((SchemaDescriptor)descriptor.schema());
    }

    @Override
    public ConstraintRule createExistenceConstraint(long ruleId, ConstraintDescriptor descriptor) throws CreateConstraintFailureException {
        throw this.propertyExistenceConstraintsNotAllowed(descriptor.schema());
    }

    @Override
    public TxStateVisitor decorateTxStateVisitor(StorageReader storageReader, Read read, CursorFactory cursorFactory, ReadableTransactionState state, TxStateVisitor visitor) {
        return visitor;
    }
}

