/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi.schema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.graphdb.index.IndexPopulationProgress;
import org.neo4j.graphdb.schema.ConstraintCreator;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.IndexCreator;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.IndexReference;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.TokenNameLookup;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.TokenWrite;
import org.neo4j.internal.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.internal.kernel.api.exceptions.LabelNotFoundKernelException;
import org.neo4j.internal.kernel.api.exceptions.PropertyKeyIdNotFoundKernelException;
import org.neo4j.internal.kernel.api.exceptions.schema.IllegalTokenNameException;
import org.neo4j.internal.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.internal.kernel.api.exceptions.schema.TooManyLabelsException;
import org.neo4j.internal.kernel.api.schema.RelationTypeSchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.constraints.ConstraintDescriptor;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.SilentTokenNameLookup;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.schema.AlreadyConstrainedException;
import org.neo4j.kernel.api.exceptions.schema.AlreadyIndexedException;
import org.neo4j.kernel.api.exceptions.schema.CreateConstraintFailureException;
import org.neo4j.kernel.api.exceptions.schema.DropConstraintFailureException;
import org.neo4j.kernel.api.exceptions.schema.DropIndexFailureException;
import org.neo4j.kernel.api.exceptions.schema.RepeatedPropertyInCompositeSchemaException;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.api.schema.constaints.ConstraintDescriptorFactory;
import org.neo4j.kernel.api.schema.constaints.NodeExistenceConstraintDescriptor;
import org.neo4j.kernel.api.schema.constaints.NodeKeyConstraintDescriptor;
import org.neo4j.kernel.api.schema.constaints.RelExistenceConstraintDescriptor;
import org.neo4j.kernel.api.schema.constaints.UniquenessConstraintDescriptor;
import org.neo4j.kernel.impl.coreapi.schema.BaseNodeConstraintCreator;
import org.neo4j.kernel.impl.coreapi.schema.IndexCreatorImpl;
import org.neo4j.kernel.impl.coreapi.schema.IndexDefinitionImpl;
import org.neo4j.kernel.impl.coreapi.schema.InternalSchemaActions;
import org.neo4j.kernel.impl.coreapi.schema.NodeKeyConstraintDefinition;
import org.neo4j.kernel.impl.coreapi.schema.NodePropertyExistenceConstraintDefinition;
import org.neo4j.kernel.impl.coreapi.schema.PropertyNameUtils;
import org.neo4j.kernel.impl.coreapi.schema.RelationshipPropertyExistenceConstraintDefinition;
import org.neo4j.kernel.impl.coreapi.schema.UniquenessConstraintDefinition;
import org.neo4j.storageengine.api.schema.PopulationProgress;
import org.neo4j.storageengine.api.schema.SchemaRule;

public class SchemaImpl
implements Schema {
    private final Supplier<KernelTransaction> transactionSupplier;
    private final InternalSchemaActions actions;

    public SchemaImpl(Supplier<KernelTransaction> transactionSupplier) {
        this.transactionSupplier = transactionSupplier;
        this.actions = new GDBSchemaActions(transactionSupplier);
    }

    public IndexCreator indexFor(Label label) {
        return new IndexCreatorImpl(this.actions, label);
    }

    public Iterable<IndexDefinition> getIndexes(Label label) {
        KernelTransaction transaction = this.transactionSupplier.get();
        try (Statement ignore = transaction.acquireStatement();){
            TokenRead tokenRead = transaction.tokenRead();
            SchemaRead schemaRead = transaction.schemaRead();
            ArrayList<IndexDefinition> definitions = new ArrayList<IndexDefinition>();
            int labelId = tokenRead.nodeLabel(label.name());
            if (labelId == -1) {
                List<IndexDefinition> list = Collections.emptyList();
                return list;
            }
            Iterator indexes = schemaRead.indexesGetForLabel(labelId);
            this.addDefinitions(definitions, tokenRead, IndexReference.sortByType((Iterator)indexes));
            ArrayList<IndexDefinition> arrayList = definitions;
            return arrayList;
        }
    }

    public Iterable<IndexDefinition> getIndexes() {
        KernelTransaction transaction = this.transactionSupplier.get();
        SchemaRead schemaRead = transaction.schemaRead();
        try (Statement ignore = transaction.acquireStatement();){
            ArrayList<IndexDefinition> definitions = new ArrayList<IndexDefinition>();
            Iterator indexes = schemaRead.indexesGetAll();
            this.addDefinitions(definitions, transaction.tokenRead(), IndexReference.sortByType((Iterator)indexes));
            ArrayList<IndexDefinition> arrayList = definitions;
            return arrayList;
        }
    }

    private IndexDefinition descriptorToDefinition(TokenRead tokenRead, IndexReference index) {
        try {
            Label label = Label.label((String)tokenRead.nodeLabelName(index.label()));
            boolean constraintIndex = index.isUnique();
            String[] propertyNames = PropertyNameUtils.getPropertyKeys(tokenRead, index.properties());
            return new IndexDefinitionImpl(this.actions, label, propertyNames, constraintIndex);
        }
        catch (LabelNotFoundKernelException | PropertyKeyIdNotFoundKernelException e) {
            throw new RuntimeException(e);
        }
    }

    private void addDefinitions(List<IndexDefinition> definitions, TokenRead tokenRead, Iterator<IndexReference> indexes) {
        Iterators.addToCollection((Iterator)Iterators.map(index -> this.descriptorToDefinition(tokenRead, (IndexReference)index), indexes), definitions);
    }

    public void awaitIndexOnline(IndexDefinition index, long duration, TimeUnit unit) {
        this.actions.assertInOpenTransaction();
        long timeout = System.currentTimeMillis() + unit.toMillis(duration);
        do {
            Schema.IndexState state = this.getIndexState(index);
            switch (state) {
                case ONLINE: {
                    return;
                }
                case FAILED: {
                    throw new IllegalStateException("Index entered a FAILED state. Please see database logs.");
                }
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (System.currentTimeMillis() < timeout);
        throw new IllegalStateException("Expected index to come online within a reasonable time.");
    }

    public void awaitIndexesOnline(long duration, TimeUnit unit) {
        this.actions.assertInOpenTransaction();
        long millisLeft = TimeUnit.MILLISECONDS.convert(duration, unit);
        ArrayList<IndexDefinition> onlineIndexes = new ArrayList<IndexDefinition>();
        Iterator<IndexDefinition> iter = this.getIndexes().iterator();
        while (iter.hasNext()) {
            if (millisLeft < 0L) {
                throw new IllegalStateException("Expected all indexes to come online within a reasonable time.Indexes brought online: " + onlineIndexes + ". Indexes not guaranteed to be online: " + Iterators.asCollection(iter));
            }
            IndexDefinition index = iter.next();
            long millisBefore = System.currentTimeMillis();
            this.awaitIndexOnline(index, millisLeft, TimeUnit.MILLISECONDS);
            millisLeft -= System.currentTimeMillis() - millisBefore;
            onlineIndexes.add(index);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Schema.IndexState getIndexState(IndexDefinition index) {
        KernelTransaction transaction = SchemaImpl.safeAcquireTransaction(this.transactionSupplier);
        try (Statement ignore = transaction.acquireStatement();){
            SchemaRead schemaRead = transaction.schemaRead();
            IndexReference reference = SchemaImpl.getIndexReference(schemaRead, transaction.tokenRead(), index);
            InternalIndexState indexState = schemaRead.indexGetState(reference);
            switch (indexState) {
                case POPULATING: {
                    Schema.IndexState indexState2 = Schema.IndexState.POPULATING;
                    return indexState2;
                }
                case ONLINE: {
                    Schema.IndexState indexState3 = Schema.IndexState.ONLINE;
                    return indexState3;
                }
                case FAILED: {
                    Schema.IndexState indexState4 = Schema.IndexState.FAILED;
                    return indexState4;
                }
            }
            throw new IllegalArgumentException(String.format("Illegal index state %s", indexState));
        }
        catch (IndexNotFoundKernelException | SchemaRuleNotFoundException e) {
            throw new NotFoundException(String.format("No index for label %s on property %s", index.getLabel().name(), index.getPropertyKeys()));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IndexPopulationProgress getIndexPopulationProgress(IndexDefinition index) {
        KernelTransaction transaction = SchemaImpl.safeAcquireTransaction(this.transactionSupplier);
        try (Statement ignore = transaction.acquireStatement();){
            SchemaRead schemaRead = transaction.schemaRead();
            IndexReference descriptor = SchemaImpl.getIndexReference(schemaRead, transaction.tokenRead(), index);
            PopulationProgress progress = schemaRead.indexGetPopulationProgress(descriptor);
            IndexPopulationProgress indexPopulationProgress = new IndexPopulationProgress(progress.getCompleted(), progress.getTotal());
            return indexPopulationProgress;
        }
        catch (IndexNotFoundKernelException | SchemaRuleNotFoundException e) {
            throw new NotFoundException(String.format("No index for label %s on property %s", index.getLabel().name(), index.getPropertyKeys()));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getIndexFailure(IndexDefinition index) {
        KernelTransaction transaction = SchemaImpl.safeAcquireTransaction(this.transactionSupplier);
        try (Statement ignore = transaction.acquireStatement();){
            SchemaRead schemaRead = transaction.schemaRead();
            IndexReference descriptor = SchemaImpl.getIndexReference(schemaRead, transaction.tokenRead(), index);
            String string = schemaRead.indexGetFailure(descriptor);
            return string;
        }
        catch (IndexNotFoundKernelException | SchemaRuleNotFoundException e) {
            throw new NotFoundException(String.format("No index for label %s on property %s", index.getLabel().name(), index.getPropertyKeys()));
        }
    }

    public ConstraintCreator constraintFor(Label label) {
        this.actions.assertInOpenTransaction();
        return new BaseNodeConstraintCreator(this.actions, label);
    }

    public Iterable<ConstraintDefinition> getConstraints() {
        KernelTransaction transaction = SchemaImpl.safeAcquireTransaction(this.transactionSupplier);
        try (Statement ignore = transaction.acquireStatement();){
            Iterable<ConstraintDefinition> iterable = this.asConstraintDefinitions(transaction.schemaRead().constraintsGetAll(), transaction.tokenRead());
            return iterable;
        }
    }

    public Iterable<ConstraintDefinition> getConstraints(Label label) {
        KernelTransaction transaction = SchemaImpl.safeAcquireTransaction(this.transactionSupplier);
        try (Statement ignore = transaction.acquireStatement();){
            TokenRead tokenRead = transaction.tokenRead();
            SchemaRead schemaRead = transaction.schemaRead();
            int labelId = tokenRead.nodeLabel(label.name());
            if (labelId == -1) {
                List<ConstraintDefinition> list = Collections.emptyList();
                return list;
            }
            Iterable<ConstraintDefinition> iterable = this.asConstraintDefinitions(schemaRead.constraintsGetForLabel(labelId), tokenRead);
            return iterable;
        }
    }

    public Iterable<ConstraintDefinition> getConstraints(RelationshipType type) {
        KernelTransaction transaction = SchemaImpl.safeAcquireTransaction(this.transactionSupplier);
        try (Statement ignore = transaction.acquireStatement();){
            TokenRead tokenRead = transaction.tokenRead();
            SchemaRead schemaRead = transaction.schemaRead();
            int typeId = tokenRead.relationshipType(type.name());
            if (typeId == -1) {
                List<ConstraintDefinition> list = Collections.emptyList();
                return list;
            }
            Iterable<ConstraintDefinition> iterable = this.asConstraintDefinitions(schemaRead.constraintsGetForRelationshipType(typeId), tokenRead);
            return iterable;
        }
    }

    private static IndexReference getIndexReference(SchemaRead schemaRead, TokenRead tokenRead, IndexDefinition index) throws SchemaRuleNotFoundException {
        int labelId = tokenRead.nodeLabel(index.getLabel().name());
        int[] propertyKeyIds = PropertyNameUtils.getPropertyIds(tokenRead, index.getPropertyKeys());
        SchemaImpl.assertValidLabel(index.getLabel(), labelId);
        SchemaImpl.assertValidProperties(index.getPropertyKeys(), propertyKeyIds);
        IndexReference reference = schemaRead.index(labelId, propertyKeyIds);
        if (reference == IndexReference.NO_INDEX) {
            throw new SchemaRuleNotFoundException(SchemaRule.Kind.INDEX_RULE, (SchemaDescriptor)SchemaDescriptorFactory.forLabel(labelId, propertyKeyIds));
        }
        return reference;
    }

    private static void assertValidLabel(Label label, int labelId) {
        if (labelId == -1) {
            throw new NotFoundException(String.format("Label %s not found", label.name()));
        }
    }

    private static void assertValidProperties(Iterable<String> properties, int[] propertyIds) {
        for (int i = 0; i < propertyIds.length; ++i) {
            if (propertyIds[i] != -1) continue;
            throw new NotFoundException(String.format("Property key %s not found", ((String[])Iterables.asArray(String.class, properties))[i]));
        }
    }

    private Iterable<ConstraintDefinition> asConstraintDefinitions(Iterator<? extends ConstraintDescriptor> constraints, TokenRead tokenRead) {
        ArrayList<ConstraintDefinition> definitions = new ArrayList<ConstraintDefinition>();
        while (constraints.hasNext()) {
            ConstraintDescriptor constraint = constraints.next();
            definitions.add(this.asConstraintDefinition(constraint, tokenRead));
        }
        return definitions;
    }

    private ConstraintDefinition asConstraintDefinition(ConstraintDescriptor constraint, TokenRead tokenRead) {
        SilentTokenNameLookup lookup = new SilentTokenNameLookup(tokenRead);
        if (constraint instanceof NodeExistenceConstraintDescriptor || constraint instanceof NodeKeyConstraintDescriptor || constraint instanceof UniquenessConstraintDescriptor) {
            SchemaDescriptor schemaDescriptor = constraint.schema();
            Label label = Label.label((String)lookup.labelGetName(schemaDescriptor.keyId()));
            String[] propertyKeys = (String[])Arrays.stream(schemaDescriptor.getPropertyIds()).mapToObj(lookup::propertyKeyGetName).toArray(String[]::new);
            if (constraint instanceof NodeExistenceConstraintDescriptor) {
                return new NodePropertyExistenceConstraintDefinition(this.actions, label, propertyKeys);
            }
            if (constraint instanceof UniquenessConstraintDescriptor) {
                return new UniquenessConstraintDefinition(this.actions, new IndexDefinitionImpl(this.actions, label, propertyKeys, true));
            }
            return new NodeKeyConstraintDefinition(this.actions, new IndexDefinitionImpl(this.actions, label, propertyKeys, true));
        }
        if (constraint instanceof RelExistenceConstraintDescriptor) {
            RelationTypeSchemaDescriptor descriptor = (RelationTypeSchemaDescriptor)constraint.schema();
            return new RelationshipPropertyExistenceConstraintDefinition(this.actions, RelationshipType.withName((String)lookup.relationshipTypeGetName(descriptor.getRelTypeId())), lookup.propertyKeyGetName(descriptor.getPropertyId()));
        }
        throw new IllegalArgumentException("Unknown constraint " + constraint);
    }

    private static KernelTransaction safeAcquireTransaction(Supplier<KernelTransaction> transactionSupplier) {
        KernelTransaction transaction = transactionSupplier.get();
        if (transaction.isTerminated()) {
            Status terminationReason = (Status)transaction.getReasonIfTerminated().orElse(Status.Transaction.Terminated);
            throw new TransactionTerminatedException(terminationReason);
        }
        return transaction;
    }

    private static class GDBSchemaActions
    implements InternalSchemaActions {
        private final Supplier<KernelTransaction> transactionSupplier;

        GDBSchemaActions(Supplier<KernelTransaction> transactionSupplier) {
            this.transactionSupplier = transactionSupplier;
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public IndexDefinition createIndexDefinition(Label label, String ... propertyKeys) {
            KernelTransaction transaction = SchemaImpl.safeAcquireTransaction(this.transactionSupplier);
            Throwable throwable = null;
            try (Statement ignore = transaction.acquireStatement();){
                IndexDefinitionImpl indexDefinition = new IndexDefinitionImpl(this, label, propertyKeys, false);
                TokenWrite tokenWrite = transaction.tokenWrite();
                int labelId = tokenWrite.labelGetOrCreateForName(indexDefinition.getLabel().name());
                int[] propertyKeyIds = PropertyNameUtils.getOrCreatePropertyKeyIds(tokenWrite, indexDefinition);
                LabelSchemaDescriptor descriptor = SchemaDescriptorFactory.forLabel(labelId, propertyKeyIds);
                transaction.schemaWrite().indexCreate((SchemaDescriptor)descriptor);
                IndexDefinitionImpl indexDefinitionImpl = indexDefinition;
                return indexDefinitionImpl;
            }
            catch (IllegalTokenNameException e) {
                try {
                    throw new IllegalArgumentException(e);
                    catch (InvalidTransactionTypeKernelException | SchemaKernelException e2) {
                        throw new ConstraintViolationException(e2.getUserMessage((TokenNameLookup)new SilentTokenNameLookup(transaction.tokenRead())), e2);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }

        @Override
        public void dropIndexDefinitions(IndexDefinition indexDefinition) {
            KernelTransaction transaction = SchemaImpl.safeAcquireTransaction(this.transactionSupplier);
            try (Statement ignore = transaction.acquireStatement();){
                try {
                    transaction.schemaWrite().indexDrop(SchemaImpl.getIndexReference(transaction.schemaRead(), transaction.tokenRead(), indexDefinition));
                }
                catch (NotFoundException notFoundException) {
                }
                catch (DropIndexFailureException | SchemaRuleNotFoundException e) {
                    throw new ConstraintViolationException(e.getUserMessage((TokenNameLookup)new SilentTokenNameLookup(transaction.tokenRead())), (Throwable)e);
                }
                catch (InvalidTransactionTypeKernelException | SchemaKernelException e) {
                    throw new ConstraintViolationException(e.getMessage(), e);
                }
            }
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public ConstraintDefinition createPropertyUniquenessConstraint(IndexDefinition indexDefinition) {
            KernelTransaction transaction = SchemaImpl.safeAcquireTransaction(this.transactionSupplier);
            Throwable throwable = null;
            try (Statement ignore = transaction.acquireStatement();){
                TokenWrite tokenWrite = transaction.tokenWrite();
                int labelId = tokenWrite.labelGetOrCreateForName(indexDefinition.getLabel().name());
                int[] propertyKeyIds = PropertyNameUtils.getOrCreatePropertyKeyIds(tokenWrite, indexDefinition);
                transaction.schemaWrite().uniquePropertyConstraintCreate((SchemaDescriptor)SchemaDescriptorFactory.forLabel(labelId, propertyKeyIds));
                UniquenessConstraintDefinition uniquenessConstraintDefinition = new UniquenessConstraintDefinition((InternalSchemaActions)this, indexDefinition);
                return uniquenessConstraintDefinition;
            }
            catch (AlreadyConstrainedException | AlreadyIndexedException | CreateConstraintFailureException | RepeatedPropertyInCompositeSchemaException e) {
                try {
                    throw new ConstraintViolationException(e.getUserMessage((TokenNameLookup)new SilentTokenNameLookup(transaction.tokenRead())), (Throwable)e);
                    catch (IllegalTokenNameException e2) {
                        throw new IllegalArgumentException(e2);
                    }
                    catch (TooManyLabelsException e3) {
                        throw new IllegalStateException(e3);
                    }
                    catch (InvalidTransactionTypeKernelException | SchemaKernelException e4) {
                        throw new ConstraintViolationException(e4.getMessage(), e4);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public ConstraintDefinition createNodeKeyConstraint(IndexDefinition indexDefinition) {
            KernelTransaction transaction = SchemaImpl.safeAcquireTransaction(this.transactionSupplier);
            Throwable throwable = null;
            try (Statement ignore = transaction.acquireStatement();){
                TokenWrite tokenWrite = transaction.tokenWrite();
                int labelId = tokenWrite.labelGetOrCreateForName(indexDefinition.getLabel().name());
                int[] propertyKeyIds = PropertyNameUtils.getOrCreatePropertyKeyIds(tokenWrite, indexDefinition);
                transaction.schemaWrite().nodeKeyConstraintCreate((org.neo4j.internal.kernel.api.schema.LabelSchemaDescriptor)SchemaDescriptorFactory.forLabel(labelId, propertyKeyIds));
                NodeKeyConstraintDefinition nodeKeyConstraintDefinition = new NodeKeyConstraintDefinition((InternalSchemaActions)this, indexDefinition);
                return nodeKeyConstraintDefinition;
            }
            catch (AlreadyConstrainedException | AlreadyIndexedException | CreateConstraintFailureException | RepeatedPropertyInCompositeSchemaException e) {
                try {
                    throw new ConstraintViolationException(e.getUserMessage((TokenNameLookup)new SilentTokenNameLookup(transaction.tokenRead())), (Throwable)e);
                    catch (IllegalTokenNameException e2) {
                        throw new IllegalArgumentException(e2);
                    }
                    catch (TooManyLabelsException e3) {
                        throw new IllegalStateException(e3);
                    }
                    catch (InvalidTransactionTypeKernelException | SchemaKernelException e4) {
                        throw new ConstraintViolationException(e4.getMessage(), e4);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public ConstraintDefinition createPropertyExistenceConstraint(Label label, String ... propertyKeys) {
            KernelTransaction transaction = SchemaImpl.safeAcquireTransaction(this.transactionSupplier);
            Throwable throwable = null;
            try (Statement ignore = transaction.acquireStatement();){
                TokenWrite tokenWrite = transaction.tokenWrite();
                int labelId = tokenWrite.labelGetOrCreateForName(label.name());
                int[] propertyKeyIds = PropertyNameUtils.getOrCreatePropertyKeyIds(tokenWrite, propertyKeys);
                transaction.schemaWrite().nodePropertyExistenceConstraintCreate((org.neo4j.internal.kernel.api.schema.LabelSchemaDescriptor)SchemaDescriptorFactory.forLabel(labelId, propertyKeyIds));
                NodePropertyExistenceConstraintDefinition nodePropertyExistenceConstraintDefinition = new NodePropertyExistenceConstraintDefinition(this, label, propertyKeys);
                return nodePropertyExistenceConstraintDefinition;
            }
            catch (AlreadyConstrainedException | CreateConstraintFailureException | RepeatedPropertyInCompositeSchemaException e) {
                try {
                    throw new ConstraintViolationException(e.getUserMessage((TokenNameLookup)new SilentTokenNameLookup(transaction.tokenRead())), (Throwable)e);
                    catch (IllegalTokenNameException e2) {
                        throw new IllegalArgumentException(e2);
                    }
                    catch (TooManyLabelsException e3) {
                        throw new IllegalStateException(e3);
                    }
                    catch (InvalidTransactionTypeKernelException | SchemaKernelException e4) {
                        throw new ConstraintViolationException(e4.getMessage(), e4);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public ConstraintDefinition createPropertyExistenceConstraint(RelationshipType type, String propertyKey) {
            KernelTransaction transaction = SchemaImpl.safeAcquireTransaction(this.transactionSupplier);
            Throwable throwable = null;
            try (Statement ignore = transaction.acquireStatement();){
                TokenWrite tokenWrite = transaction.tokenWrite();
                int typeId = tokenWrite.relationshipTypeGetOrCreateForName(type.name());
                int[] propertyKeyId = PropertyNameUtils.getOrCreatePropertyKeyIds(tokenWrite, propertyKey);
                transaction.schemaWrite().relationshipPropertyExistenceConstraintCreate((RelationTypeSchemaDescriptor)SchemaDescriptorFactory.forRelType(typeId, propertyKeyId));
                RelationshipPropertyExistenceConstraintDefinition relationshipPropertyExistenceConstraintDefinition = new RelationshipPropertyExistenceConstraintDefinition(this, type, propertyKey);
                return relationshipPropertyExistenceConstraintDefinition;
            }
            catch (AlreadyConstrainedException | CreateConstraintFailureException | RepeatedPropertyInCompositeSchemaException e) {
                try {
                    throw new ConstraintViolationException(e.getUserMessage((TokenNameLookup)new SilentTokenNameLookup(transaction.tokenRead())), (Throwable)e);
                    catch (IllegalTokenNameException e2) {
                        throw new IllegalArgumentException(e2);
                    }
                    catch (InvalidTransactionTypeKernelException | SchemaKernelException e3) {
                        throw new ConstraintViolationException(e3.getMessage(), e3);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }

        @Override
        public void dropPropertyUniquenessConstraint(Label label, String[] properties) {
            KernelTransaction transaction = SchemaImpl.safeAcquireTransaction(this.transactionSupplier);
            try (Statement ignore = transaction.acquireStatement();){
                try {
                    TokenRead tokenRead = transaction.tokenRead();
                    int labelId = tokenRead.nodeLabel(label.name());
                    int[] propertyKeyIds = PropertyNameUtils.getPropertyIds(tokenRead, properties);
                    transaction.schemaWrite().constraintDrop((ConstraintDescriptor)ConstraintDescriptorFactory.uniqueForLabel(labelId, propertyKeyIds));
                }
                catch (DropConstraintFailureException e) {
                    throw new ConstraintViolationException(e.getUserMessage(new SilentTokenNameLookup(transaction.tokenRead())), (Throwable)((Object)e));
                }
                catch (InvalidTransactionTypeKernelException | SchemaKernelException e) {
                    throw new ConstraintViolationException(e.getMessage(), e);
                }
            }
        }

        @Override
        public void dropNodeKeyConstraint(Label label, String[] properties) {
            KernelTransaction transaction = SchemaImpl.safeAcquireTransaction(this.transactionSupplier);
            try (Statement ignore = transaction.acquireStatement();){
                try {
                    TokenRead tokenRead = transaction.tokenRead();
                    int labelId = tokenRead.nodeLabel(label.name());
                    int[] propertyKeyIds = PropertyNameUtils.getPropertyIds(tokenRead, properties);
                    transaction.schemaWrite().constraintDrop((ConstraintDescriptor)ConstraintDescriptorFactory.nodeKeyForLabel(labelId, propertyKeyIds));
                }
                catch (DropConstraintFailureException e) {
                    throw new ConstraintViolationException(e.getUserMessage(new SilentTokenNameLookup(transaction.tokenRead())), (Throwable)((Object)e));
                }
                catch (InvalidTransactionTypeKernelException | SchemaKernelException e) {
                    throw new ConstraintViolationException(e.getMessage(), e);
                }
            }
        }

        @Override
        public void dropNodePropertyExistenceConstraint(Label label, String[] properties) {
            KernelTransaction transaction = SchemaImpl.safeAcquireTransaction(this.transactionSupplier);
            try (Statement ignore = transaction.acquireStatement();){
                try {
                    TokenRead tokenRead = transaction.tokenRead();
                    int labelId = tokenRead.nodeLabel(label.name());
                    int[] propertyKeyIds = PropertyNameUtils.getPropertyIds(tokenRead, properties);
                    transaction.schemaWrite().constraintDrop((ConstraintDescriptor)ConstraintDescriptorFactory.existsForLabel(labelId, propertyKeyIds));
                }
                catch (DropConstraintFailureException e) {
                    throw new ConstraintViolationException(e.getUserMessage(new SilentTokenNameLookup(transaction.tokenRead())), (Throwable)((Object)e));
                }
                catch (InvalidTransactionTypeKernelException | SchemaKernelException e) {
                    throw new ConstraintViolationException(e.getMessage(), e);
                }
            }
        }

        @Override
        public void dropRelationshipPropertyExistenceConstraint(RelationshipType type, String propertyKey) {
            KernelTransaction transaction = SchemaImpl.safeAcquireTransaction(this.transactionSupplier);
            try (Statement ignore = transaction.acquireStatement();){
                try {
                    TokenRead tokenRead = transaction.tokenRead();
                    int typeId = tokenRead.relationshipType(type.name());
                    int propertyKeyId = tokenRead.propertyKey(propertyKey);
                    transaction.schemaWrite().constraintDrop((ConstraintDescriptor)ConstraintDescriptorFactory.existsForRelType(typeId, propertyKeyId));
                }
                catch (DropConstraintFailureException e) {
                    throw new ConstraintViolationException(e.getUserMessage(new SilentTokenNameLookup(transaction.tokenRead())), (Throwable)((Object)e));
                }
                catch (InvalidTransactionTypeKernelException | SchemaKernelException e) {
                    throw new ConstraintViolationException(e.getMessage(), e);
                }
            }
        }

        @Override
        public String getUserMessage(KernelException e) {
            KernelTransaction transaction = SchemaImpl.safeAcquireTransaction(this.transactionSupplier);
            try (Statement ignore = transaction.acquireStatement();){
                String string = e.getUserMessage((TokenNameLookup)new SilentTokenNameLookup(transaction.tokenRead()));
                return string;
            }
        }

        @Override
        public void assertInOpenTransaction() {
            KernelTransaction transaction = this.transactionSupplier.get();
            if (transaction.isTerminated()) {
                Status terminationReason = (Status)transaction.getReasonIfTerminated().orElse(Status.Transaction.Terminated);
                throw new TransactionTerminatedException(terminationReason);
            }
        }
    }
}

