/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storageengine.impl.recordstorage;

import java.io.Serializable;
import java.util.Iterator;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.neo4j.internal.kernel.api.schema.constraints.ConstraintDescriptor;
import org.neo4j.kernel.api.exceptions.schema.CreateConstraintFailureException;
import org.neo4j.kernel.api.exceptions.schema.DuplicateSchemaRuleException;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.schema.constaints.IndexBackedConstraintDescriptor;
import org.neo4j.kernel.api.schema.constaints.NodeKeyConstraintDescriptor;
import org.neo4j.kernel.api.schema.constaints.UniquenessConstraintDescriptor;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.api.schema.index.StoreIndexDescriptor;
import org.neo4j.kernel.impl.api.SchemaState;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.TransactionRecordState;
import org.neo4j.kernel.impl.store.SchemaStorage;
import org.neo4j.storageengine.api.StorageProperty;
import org.neo4j.storageengine.api.txstate.TxStateVisitor;

class TransactionToRecordStateVisitor
extends TxStateVisitor.Adapter {
    private boolean clearSchemaState;
    private final TransactionRecordState recordState;
    private final SchemaState schemaState;
    private final SchemaStorage schemaStorage;
    private final ConstraintSemantics constraintSemantics;

    TransactionToRecordStateVisitor(TransactionRecordState recordState, SchemaState schemaState, SchemaStorage schemaStorage, ConstraintSemantics constraintSemantics) {
        this.recordState = recordState;
        this.schemaState = schemaState;
        this.schemaStorage = schemaStorage;
        this.constraintSemantics = constraintSemantics;
    }

    @Override
    public void close() {
        try {
            if (this.clearSchemaState) {
                this.schemaState.clear();
            }
        }
        finally {
            this.clearSchemaState = false;
        }
    }

    @Override
    public void visitCreatedNode(long id) {
        this.recordState.nodeCreate(id);
    }

    @Override
    public void visitDeletedNode(long id) {
        this.recordState.nodeDelete(id);
    }

    @Override
    public void visitCreatedRelationship(long id, int type, long startNode, long endNode) {
        this.recordState.relCreate(id, type, startNode, endNode);
    }

    @Override
    public void visitDeletedRelationship(long id) {
        this.recordState.relDelete(id);
    }

    @Override
    public void visitNodePropertyChanges(long id, Iterator<StorageProperty> added, Iterator<StorageProperty> changed, IntIterable removed) {
        StorageProperty prop;
        removed.each((IntProcedure & Serializable)propId -> this.recordState.nodeRemoveProperty(id, propId));
        while (changed.hasNext()) {
            prop = changed.next();
            this.recordState.nodeChangeProperty(id, prop.propertyKeyId(), prop.value());
        }
        while (added.hasNext()) {
            prop = added.next();
            this.recordState.nodeAddProperty(id, prop.propertyKeyId(), prop.value());
        }
    }

    @Override
    public void visitRelPropertyChanges(long id, Iterator<StorageProperty> added, Iterator<StorageProperty> changed, IntIterable removed) {
        StorageProperty prop;
        removed.each((IntProcedure & Serializable)relId -> this.recordState.relRemoveProperty(id, relId));
        while (changed.hasNext()) {
            prop = changed.next();
            this.recordState.relChangeProperty(id, prop.propertyKeyId(), prop.value());
        }
        while (added.hasNext()) {
            prop = added.next();
            this.recordState.relAddProperty(id, prop.propertyKeyId(), prop.value());
        }
    }

    @Override
    public void visitGraphPropertyChanges(Iterator<StorageProperty> added, Iterator<StorageProperty> changed, IntIterable removed) {
        StorageProperty prop;
        removed.each(this.recordState::graphRemoveProperty);
        while (changed.hasNext()) {
            prop = changed.next();
            this.recordState.graphChangeProperty(prop.propertyKeyId(), prop.value());
        }
        while (added.hasNext()) {
            prop = added.next();
            this.recordState.graphAddProperty(prop.propertyKeyId(), prop.value());
        }
    }

    @Override
    public void visitNodeLabelChanges(long id, LongSet added, LongSet removed) {
        removed.each((LongProcedure & Serializable)label -> this.recordState.removeLabelFromNode(label, id));
        added.each((LongProcedure & Serializable)label -> this.recordState.addLabelToNode(label, id));
    }

    @Override
    public void visitAddedIndex(IndexDescriptor index) {
        StoreIndexDescriptor rule = index.withId(this.schemaStorage.newRuleId());
        this.recordState.createSchemaRule(rule);
    }

    @Override
    public void visitRemovedIndex(IndexDescriptor index) {
        StoreIndexDescriptor rule = this.schemaStorage.indexGetForSchema(index);
        if (rule != null) {
            this.recordState.dropSchemaRule(rule);
        }
    }

    @Override
    public void visitAddedConstraint(ConstraintDescriptor constraint) throws CreateConstraintFailureException {
        this.clearSchemaState = true;
        long constraintId = this.schemaStorage.newRuleId();
        switch (constraint.type()) {
            case UNIQUE: {
                this.visitAddedUniquenessConstraint((UniquenessConstraintDescriptor)constraint, constraintId);
                break;
            }
            case UNIQUE_EXISTS: {
                this.visitAddedNodeKeyConstraint((NodeKeyConstraintDescriptor)constraint, constraintId);
                break;
            }
            case EXISTS: {
                this.recordState.createSchemaRule(this.constraintSemantics.createExistenceConstraint(this.schemaStorage.newRuleId(), constraint));
                break;
            }
            default: {
                throw new IllegalStateException(constraint.type().toString());
            }
        }
    }

    private void visitAddedUniquenessConstraint(UniquenessConstraintDescriptor uniqueConstraint, long constraintId) {
        StoreIndexDescriptor indexRule = this.schemaStorage.indexGetForSchema(uniqueConstraint.ownedIndexDescriptor());
        this.recordState.createSchemaRule(this.constraintSemantics.createUniquenessConstraintRule(constraintId, uniqueConstraint, indexRule.getId()));
        this.recordState.setConstraintIndexOwner(indexRule, constraintId);
    }

    private void visitAddedNodeKeyConstraint(NodeKeyConstraintDescriptor uniqueConstraint, long constraintId) throws CreateConstraintFailureException {
        StoreIndexDescriptor indexRule = this.schemaStorage.indexGetForSchema(uniqueConstraint.ownedIndexDescriptor());
        this.recordState.createSchemaRule(this.constraintSemantics.createNodeKeyConstraintRule(constraintId, uniqueConstraint, indexRule.getId()));
        this.recordState.setConstraintIndexOwner(indexRule, constraintId);
    }

    @Override
    public void visitRemovedConstraint(ConstraintDescriptor constraint) {
        this.clearSchemaState = true;
        try {
            this.recordState.dropSchemaRule(this.schemaStorage.constraintsGetSingle(constraint));
        }
        catch (SchemaRuleNotFoundException e) {
            throw new IllegalStateException("Constraint to be removed should exist, since its existence should have been validated earlier and the schema should have been locked.");
        }
        catch (DuplicateSchemaRuleException e) {
            throw new IllegalStateException("Multiple constraints found for specified label and property.");
        }
        if (constraint.enforcesUniqueness()) {
            this.visitRemovedIndex(((IndexBackedConstraintDescriptor)constraint).ownedIndexDescriptor());
        }
    }

    @Override
    public void visitCreatedLabelToken(long id, String name) {
        this.recordState.createLabelToken(name, id);
    }

    @Override
    public void visitCreatedPropertyKeyToken(long id, String name) {
        this.recordState.createPropertyKeyToken(name, id);
    }

    @Override
    public void visitCreatedRelationshipTypeToken(long id, String name) {
        this.recordState.createRelationshipTypeToken(name, id);
    }
}

