/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.checkpoint;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.neo4j.function.ThrowingAction;
import org.neo4j.graphdb.Resource;

public class StoreCopyCheckPointMutex {
    private final ReadWriteLock lock;
    private int storeCopyCount;
    private volatile boolean storeCopyActionCompleted;
    private volatile Throwable storeCopyActionError;

    public StoreCopyCheckPointMutex() {
        this(new ReentrantReadWriteLock(true));
    }

    public StoreCopyCheckPointMutex(ReadWriteLock lock) {
        this.lock = lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource storeCopy(ThrowingAction<IOException> beforeFirstConcurrentStoreCopy) throws IOException {
        Lock readLock = this.lock.readLock();
        boolean firstConcurrentRead = this.incrementCount() == 0;
        boolean success = false;
        try {
            if (firstConcurrentRead) {
                try {
                    beforeFirstConcurrentStoreCopy.apply();
                }
                catch (IOException e) {
                    this.storeCopyActionError = e;
                    throw e;
                }
                catch (Throwable e) {
                    this.storeCopyActionError = e;
                    throw new IOException(e);
                }
                this.storeCopyActionCompleted = true;
            } else {
                this.waitForFirstStoreCopyActionToComplete();
            }
            success = true;
        }
        finally {
            if (success) {
                readLock.lock();
            } else {
                this.decrementCount();
            }
        }
        return () -> {
            this.decrementCount();
            readLock.unlock();
        };
    }

    private void waitForFirstStoreCopyActionToComplete() throws IOException {
        while (!this.storeCopyActionCompleted) {
            if (this.storeCopyActionError != null) {
                throw new IOException("Co-operative action before store-copy failed", this.storeCopyActionError);
            }
            StoreCopyCheckPointMutex.parkAWhile();
        }
    }

    private synchronized void decrementCount() {
        --this.storeCopyCount;
        if (this.storeCopyCount == 0) {
            this.clear();
        }
    }

    private void clear() {
        this.storeCopyActionCompleted = false;
        this.storeCopyActionError = null;
    }

    private synchronized int incrementCount() {
        return this.storeCopyCount++;
    }

    private static void parkAWhile() {
        LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(100L));
    }

    public Resource tryCheckPoint() {
        Lock writeLock = this.lock.writeLock();
        return writeLock.tryLock() ? writeLock::unlock : null;
    }

    public Resource checkPoint() {
        Lock writeLock = this.lock.writeLock();
        writeLock.lock();
        return writeLock::unlock;
    }
}

