/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.function.Function;
import org.neo4j.function.ThrowingSupplier;
import org.neo4j.kernel.impl.index.schema.IndexPartsCache;
import org.neo4j.values.storable.ValueGroup;

class TemporalIndexCache<T>
extends IndexPartsCache<Offset, T> {
    private final Factory<T> factory;

    TemporalIndexCache(Factory<T> factory) {
        this.factory = factory;
    }

    T uncheckedSelect(ValueGroup valueGroup) {
        switch (valueGroup) {
            case DATE: {
                return this.date();
            }
            case LOCAL_DATE_TIME: {
                return this.localDateTime();
            }
            case ZONED_DATE_TIME: {
                return this.zonedDateTime();
            }
            case LOCAL_TIME: {
                return this.localTime();
            }
            case ZONED_TIME: {
                return this.zonedTime();
            }
            case DURATION: {
                return this.duration();
            }
        }
        throw new IllegalStateException("Unsupported value group " + valueGroup);
    }

    T select(ValueGroup valueGroup) throws IOException {
        try {
            return this.uncheckedSelect(valueGroup);
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    <RESULT> RESULT selectOrElse(ValueGroup valueGroup, Function<T, RESULT> function, RESULT orElse) {
        Object cachedValue;
        switch (valueGroup) {
            case DATE: {
                cachedValue = this.cache.get((Object)Offset.date);
                break;
            }
            case LOCAL_DATE_TIME: {
                cachedValue = this.cache.get((Object)Offset.localDateTime);
                break;
            }
            case ZONED_DATE_TIME: {
                cachedValue = this.cache.get((Object)Offset.zonedDateTime);
                break;
            }
            case LOCAL_TIME: {
                cachedValue = this.cache.get((Object)Offset.localTime);
                break;
            }
            case ZONED_TIME: {
                cachedValue = this.cache.get((Object)Offset.zonedTime);
                break;
            }
            case DURATION: {
                cachedValue = this.cache.get((Object)Offset.duration);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported value group " + valueGroup);
            }
        }
        return cachedValue != null ? function.apply(cachedValue) : orElse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T getOrCreatePart(Offset key, ThrowingSupplier<T, IOException> factory) throws UncheckedIOException {
        Object existing = this.cache.get((Object)key);
        if (existing != null) {
            return (T)existing;
        }
        this.instantiateCloseLock.lock();
        try {
            this.assertOpen();
            Object object = this.cache.computeIfAbsent(key, k -> {
                try {
                    return factory.get();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
            return (T)object;
        }
        finally {
            this.instantiateCloseLock.unlock();
        }
    }

    private T date() throws UncheckedIOException {
        return this.getOrCreatePart(Offset.date, this.factory::newDate);
    }

    private T localDateTime() throws UncheckedIOException {
        return this.getOrCreatePart(Offset.localDateTime, this.factory::newLocalDateTime);
    }

    private T zonedDateTime() throws UncheckedIOException {
        return this.getOrCreatePart(Offset.zonedDateTime, this.factory::newZonedDateTime);
    }

    private T localTime() throws UncheckedIOException {
        return this.getOrCreatePart(Offset.localTime, this.factory::newLocalTime);
    }

    private T zonedTime() throws UncheckedIOException {
        return this.getOrCreatePart(Offset.zonedTime, this.factory::newZonedTime);
    }

    private T duration() throws UncheckedIOException {
        return this.getOrCreatePart(Offset.duration, this.factory::newDuration);
    }

    void loadAll() {
        try {
            this.date();
            this.zonedDateTime();
            this.localDateTime();
            this.zonedTime();
            this.localTime();
            this.duration();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static interface Factory<T> {
        public T newDate() throws IOException;

        public T newLocalDateTime() throws IOException;

        public T newZonedDateTime() throws IOException;

        public T newLocalTime() throws IOException;

        public T newZonedTime() throws IOException;

        public T newDuration() throws IOException;
    }

    static enum Offset {
        date,
        localDateTime,
        zonedDateTime,
        localTime,
        zonedTime,
        duration;

    }
}

