/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import java.util.ArrayList;
import java.util.EnumMap;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.function.ThrowingFunction;
import org.neo4j.helpers.Exceptions;
import org.neo4j.kernel.impl.index.schema.fusion.IndexSlot;

class InstanceSelector<T> {
    final EnumMap<IndexSlot, T> instances;
    boolean closed;

    InstanceSelector() {
        this(new EnumMap(IndexSlot.class));
    }

    InstanceSelector(EnumMap<IndexSlot, T> map) {
        this.instances = map;
    }

    void put(IndexSlot slot, T instance) {
        this.instances.put(slot, instance);
    }

    T select(IndexSlot slot) {
        if (!this.instances.containsKey((Object)slot)) {
            throw new IllegalStateException("Instance is not instantiated");
        }
        return this.instances.get((Object)slot);
    }

    <R, E extends Exception> EnumMap<IndexSlot, R> map(ThrowingFunction<T, R, E> converter) throws E {
        EnumMap<IndexSlot, Object> result = new EnumMap<IndexSlot, Object>(IndexSlot.class);
        for (IndexSlot slot : IndexSlot.values()) {
            result.put(slot, converter.apply(this.select(slot)));
        }
        return result;
    }

    <R, E extends Exception> Iterable<R> transform(ThrowingFunction<T, R, E> converter) throws E {
        ArrayList<Object> result = new ArrayList<Object>();
        for (IndexSlot slot : IndexSlot.values()) {
            result.add(converter.apply(this.select(slot)));
        }
        return result;
    }

    <E extends Exception> void forAll(ThrowingConsumer<T, E> consumer) throws E {
        Object exception = null;
        for (IndexSlot slot : IndexSlot.values()) {
            exception = this.consumeAndChainException(this.select(slot), consumer, exception);
        }
        if (exception != null) {
            throw exception;
        }
    }

    <E extends Exception> void close(ThrowingConsumer<T, E> consumer) throws E {
        if (!this.closed) {
            try {
                this.forInstantiated(consumer);
            }
            finally {
                this.closed = true;
            }
        }
    }

    public String toString() {
        return this.instances.toString();
    }

    private <E extends Exception> void forInstantiated(ThrowingConsumer<T, E> consumer) throws E {
        Object exception = null;
        for (T instance : this.instances.values()) {
            if (instance == null) continue;
            exception = this.consumeAndChainException(instance, consumer, exception);
        }
        if (exception != null) {
            throw exception;
        }
    }

    private <E extends Exception> E consumeAndChainException(T instance, ThrowingConsumer<T, E> consumer, E exception) {
        try {
            consumer.accept(instance);
        }
        catch (Exception e) {
            exception = (Exception)Exceptions.chain(exception, (Throwable)e);
        }
        return exception;
    }
}

