/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.Iterator;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.collections.api.set.primitive.IntSet;
import org.eclipse.collections.impl.set.mutable.primitive.IntHashSet;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.kernel.api.schema.index.CapableIndexDescriptor;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.index.IndexingProvidersService;
import org.neo4j.kernel.impl.newapi.NodeSchemaMatcher;
import org.neo4j.kernel.impl.newapi.Read;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueTuple;
import org.neo4j.values.storable.Values;

public class IndexTxStateUpdater {
    private final StorageReader storageReader;
    private final Read read;
    private final IndexingProvidersService indexProviders;

    public IndexTxStateUpdater(StorageReader storageReader, Read read, IndexingProvidersService indexProviders) {
        this.storageReader = storageReader;
        this.read = read;
        this.indexProviders = indexProviders;
    }

    void onLabelChange(int labelId, NodeCursor node, PropertyCursor propertyCursor, LabelChangeType changeType) {
        assert (this.noSchemaChangedInTx());
        Iterator<CapableIndexDescriptor> indexes = this.storageReader.indexesGetForLabel(labelId);
        if (!indexes.hasNext()) {
            return;
        }
        IntHashSet nodePropertyIds = new IntHashSet();
        node.properties(propertyCursor);
        while (propertyCursor.next()) {
            nodePropertyIds.add(propertyCursor.propertyKey());
        }
        block5: while (indexes.hasNext()) {
            IndexDescriptor index = indexes.next();
            int[] indexPropertyIds = index.schema().getPropertyIds();
            if (!IndexTxStateUpdater.nodeHasIndexProperties((IntSet)nodePropertyIds, indexPropertyIds)) continue;
            Value[] values = this.getValueTuple(node, propertyCursor, indexPropertyIds);
            switch (changeType) {
                case ADDED_LABEL: {
                    this.indexProviders.validateBeforeCommit(index.schema(), values);
                    this.read.txState().indexDoUpdateEntry(index.schema(), node.nodeReference(), null, ValueTuple.of((Value[])values));
                    continue block5;
                }
                case REMOVED_LABEL: {
                    this.read.txState().indexDoUpdateEntry(index.schema(), node.nodeReference(), ValueTuple.of((Value[])values), null);
                    continue block5;
                }
            }
            throw new IllegalStateException((Object)((Object)changeType) + " is not a supported event");
        }
    }

    private boolean noSchemaChangedInTx() {
        return !this.read.txState().hasChanges() || this.read.txState().hasDataChanges();
    }

    void onPropertyAdd(NodeCursor node, PropertyCursor propertyCursor, int propertyKeyId, Value value) {
        assert (this.noSchemaChangedInTx());
        Iterator<CapableIndexDescriptor> indexes = this.storageReader.indexesGetRelatedToProperty(propertyKeyId);
        NodeSchemaMatcher.onMatchingSchema(indexes, node, propertyCursor, propertyKeyId, (index, propertyKeyIds) -> {
            Value[] values = this.getValueTuple(node, propertyCursor, propertyKeyId, value, index.schema().getPropertyIds());
            this.indexProviders.validateBeforeCommit(index.schema(), values);
            this.read.txState().indexDoUpdateEntry(index.schema(), node.nodeReference(), null, ValueTuple.of((Value[])values));
        });
    }

    void onPropertyRemove(NodeCursor node, PropertyCursor propertyCursor, int propertyKeyId, Value value) {
        assert (this.noSchemaChangedInTx());
        Iterator<CapableIndexDescriptor> indexes = this.storageReader.indexesGetRelatedToProperty(propertyKeyId);
        NodeSchemaMatcher.onMatchingSchema(indexes, node, propertyCursor, propertyKeyId, (index, propertyKeyIds) -> {
            Value[] values = this.getValueTuple(node, propertyCursor, propertyKeyId, value, index.schema().getPropertyIds());
            this.read.txState().indexDoUpdateEntry(index.schema(), node.nodeReference(), ValueTuple.of((Value[])values), null);
        });
    }

    void onPropertyChange(NodeCursor node, PropertyCursor propertyCursor, int propertyKeyId, Value beforeValue, Value afterValue) {
        assert (this.noSchemaChangedInTx());
        Iterator<CapableIndexDescriptor> indexes = this.storageReader.indexesGetRelatedToProperty(propertyKeyId);
        NodeSchemaMatcher.onMatchingSchema(indexes, node, propertyCursor, propertyKeyId, (index, propertyKeyIds) -> {
            int[] indexPropertyIds = index.schema().getPropertyIds();
            Value[] valuesBefore = new Value[indexPropertyIds.length];
            Value[] valuesAfter = new Value[indexPropertyIds.length];
            for (int i = 0; i < indexPropertyIds.length; ++i) {
                int indexPropertyId = indexPropertyIds[i];
                if (indexPropertyId == propertyKeyId) {
                    valuesBefore[i] = beforeValue;
                    valuesAfter[i] = afterValue;
                    continue;
                }
                node.properties(propertyCursor);
                Value value = Values.NO_VALUE;
                while (propertyCursor.next()) {
                    if (propertyCursor.propertyKey() != indexPropertyId) continue;
                    value = propertyCursor.propertyValue();
                }
                valuesBefore[i] = value;
                valuesAfter[i] = value;
            }
            this.indexProviders.validateBeforeCommit(index.schema(), valuesAfter);
            this.read.txState().indexDoUpdateEntry(index.schema(), node.nodeReference(), ValueTuple.of((Value[])valuesBefore), ValueTuple.of((Value[])valuesAfter));
        });
    }

    private Value[] getValueTuple(NodeCursor node, PropertyCursor propertyCursor, int[] indexPropertyIds) {
        return this.getValueTuple(node, propertyCursor, -1, Values.NO_VALUE, indexPropertyIds);
    }

    private Value[] getValueTuple(NodeCursor node, PropertyCursor propertyCursor, int changedPropertyKeyId, Value changedValue, int[] indexPropertyIds) {
        int k;
        Value[] values = new Value[indexPropertyIds.length];
        node.properties(propertyCursor);
        while (propertyCursor.next()) {
            k = ArrayUtils.indexOf((int[])indexPropertyIds, (int)propertyCursor.propertyKey());
            if (k < 0) continue;
            values[k] = indexPropertyIds[k] == changedPropertyKeyId ? changedValue : propertyCursor.propertyValue();
        }
        if (changedPropertyKeyId != -1 && (k = ArrayUtils.indexOf((int[])indexPropertyIds, (int)changedPropertyKeyId)) >= 0) {
            values[k] = changedValue;
        }
        return values;
    }

    private static boolean nodeHasIndexProperties(IntSet nodeProperties, int[] indexPropertyIds) {
        for (int indexPropertyId : indexPropertyIds) {
            if (nodeProperties.contains(indexPropertyId)) continue;
            return false;
        }
        return true;
    }

    public static enum LabelChangeType {
        ADDED_LABEL,
        REMOVED_LABEL;

    }
}

