/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import java.util.Collections;
import java.util.Iterator;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.impl.factory.primitive.IntSets;
import org.neo4j.kernel.impl.api.RelationshipVisitor;
import org.neo4j.kernel.impl.api.state.PropertyContainerStateImpl;
import org.neo4j.kernel.impl.util.collection.CollectionsFactory;
import org.neo4j.storageengine.api.StorageProperty;
import org.neo4j.storageengine.api.txstate.RelationshipState;

class RelationshipStateImpl
extends PropertyContainerStateImpl
implements RelationshipState {
    static final RelationshipState EMPTY = new RelationshipState(){

        @Override
        public long getId() {
            throw new UnsupportedOperationException("id not defined");
        }

        @Override
        public <EX extends Exception> boolean accept(RelationshipVisitor<EX> visitor) {
            return false;
        }

        @Override
        public Iterator<StorageProperty> addedProperties() {
            return Collections.emptyIterator();
        }

        @Override
        public Iterator<StorageProperty> changedProperties() {
            return Collections.emptyIterator();
        }

        @Override
        public IntIterable removedProperties() {
            return IntSets.immutable.empty();
        }

        @Override
        public Iterator<StorageProperty> addedAndChangedProperties() {
            return Collections.emptyIterator();
        }

        @Override
        public boolean hasPropertyChanges() {
            return false;
        }

        @Override
        public boolean isPropertyChangedOrRemoved(int propertyKey) {
            return false;
        }
    };
    private long startNode = -1L;
    private long endNode = -1L;
    private int type = -1;

    RelationshipStateImpl(long id, CollectionsFactory collectionsFactory) {
        super(id, collectionsFactory);
    }

    void setMetaData(long startNode, long endNode, int type) {
        this.startNode = startNode;
        this.endNode = endNode;
        this.type = type;
    }

    @Override
    public <EX extends Exception> boolean accept(RelationshipVisitor<EX> visitor) throws EX {
        if (this.type != -1) {
            visitor.visit(this.getId(), this.type, this.startNode, this.endNode);
            return true;
        }
        return false;
    }
}

