/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi.schema;

import java.util.Arrays;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.kernel.impl.coreapi.schema.InternalSchemaActions;

public class IndexDefinitionImpl
implements IndexDefinition {
    private final InternalSchemaActions actions;
    private final Label label;
    private final String[] propertyKeys;
    private final boolean constraintIndex;

    public IndexDefinitionImpl(InternalSchemaActions actions, Label label, String[] propertyKeys, boolean constraintIndex) {
        this.actions = actions;
        this.label = label;
        this.propertyKeys = propertyKeys;
        this.constraintIndex = constraintIndex;
        this.assertInUnterminatedTransaction();
    }

    public Label getLabel() {
        this.assertInUnterminatedTransaction();
        return this.label;
    }

    public Iterable<String> getPropertyKeys() {
        this.assertInUnterminatedTransaction();
        return Arrays.asList(this.propertyKeys);
    }

    public String[] getPropertyKeysArrayShared() {
        this.assertInUnterminatedTransaction();
        return this.propertyKeys;
    }

    public void drop() {
        try {
            this.actions.dropIndexDefinitions(this);
        }
        catch (ConstraintViolationException e) {
            if (this.isConstraintIndex()) {
                throw new IllegalStateException("Constraint indexes cannot be dropped directly, instead drop the owning uniqueness constraint.", e);
            }
            throw e;
        }
    }

    public boolean isConstraintIndex() {
        this.assertInUnterminatedTransaction();
        return this.constraintIndex;
    }

    public int hashCode() {
        return 31 * this.label.name().hashCode() + Arrays.hashCode(this.propertyKeys);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IndexDefinitionImpl other = (IndexDefinitionImpl)obj;
        return this.label.name().equals(other.label.name()) && Arrays.equals(this.propertyKeys, other.propertyKeys);
    }

    public String toString() {
        return "IndexDefinition[label:" + this.label + ", on:" + String.join((CharSequence)",", this.propertyKeys) + "]";
    }

    private void assertInUnterminatedTransaction() {
        this.actions.assertInOpenTransaction();
    }
}

