/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.Arrays;
import java.util.StringJoiner;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.index.schema.GenericKeyState;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;

class CompositeGenericKey
extends NativeIndexKey<CompositeGenericKey> {
    private GenericKeyState[] states;

    CompositeGenericKey(int slots) {
        this.states = new GenericKeyState[slots];
        for (int i = 0; i < this.states.length; ++i) {
            this.states[i] = new GenericKeyState();
        }
    }

    @Override
    void writeValue(int stateSlot, Value value, NativeIndexKey.Inclusion inclusion) {
        this.states[stateSlot].writeValue(value, inclusion);
    }

    @Override
    void assertValidValue(int stateSlot, Value value) {
        GenericKeyState.assertCorrectType(value);
    }

    @Override
    void initialize(long entityId) {
        super.initialize(entityId);
        for (GenericKeyState state : this.states) {
            state.clear();
        }
    }

    @Override
    String propertiesAsString() {
        return Arrays.toString(this.asValues());
    }

    @Override
    Value[] asValues() {
        Value[] values = new Value[this.states.length];
        for (int i = 0; i < this.states.length; ++i) {
            values[i] = this.states[i].asValue();
        }
        return values;
    }

    @Override
    void initValueAsLowest(int stateSlot, ValueGroup valueGroup) {
        this.states[stateSlot].initValueAsLowest(valueGroup);
    }

    @Override
    void initValueAsHighest(int stateSlot, ValueGroup valueGroup) {
        this.states[stateSlot].initValueAsHighest(valueGroup);
    }

    @Override
    int compareValueTo(CompositeGenericKey other) {
        for (int i = 0; i < this.states.length; ++i) {
            int comparison = this.states[i].compareValueTo(other.states[i]);
            if (comparison == 0) continue;
            return comparison;
        }
        return 0;
    }

    void initAsPrefixLow(int stateSlot, String prefix) {
        this.states[stateSlot].initAsPrefixLow(prefix);
    }

    void initAsPrefixHigh(int stateSlot, String prefix) {
        this.states[stateSlot].initAsPrefixHigh(prefix);
    }

    void copyValuesFrom(CompositeGenericKey key) {
        if (key.states.length != this.states.length) {
            throw new IllegalArgumentException("Different state lengths " + key.states.length + " vs " + this.states.length);
        }
        for (int i = 0; i < key.states.length; ++i) {
            this.states[i].copyFrom(key.states[i]);
        }
    }

    int size() {
        int size = 8;
        for (GenericKeyState state : this.states) {
            size += state.size();
        }
        return size;
    }

    void write(PageCursor cursor) {
        cursor.putLong(this.getEntityId());
        for (GenericKeyState state : this.states) {
            state.put(cursor);
        }
    }

    void read(PageCursor cursor, int keySize) {
        if (keySize < 8) {
            this.initializeToDummyValue(cursor, String.format("keySize < ENTITY_ID_SIZE, more precisely %d", keySize));
            return;
        }
        this.initialize(cursor.getLong());
        int offset = cursor.getOffset();
        int stateOffset = 0;
        for (GenericKeyState state : this.states) {
            if (!state.read(cursor, keySize)) {
                this.initializeToDummyValue(cursor, String.format("Unable to read state[%d] from offset:%d and keySize:%d", stateOffset, offset, keySize));
                return;
            }
            int offsetAfterRead = cursor.getOffset();
            keySize -= offsetAfterRead - offset;
            offset = offsetAfterRead;
            ++stateOffset;
        }
    }

    private void initializeToDummyValue(PageCursor cursor, String reason) {
        this.setEntityId(Long.MIN_VALUE);
        for (GenericKeyState state : this.states) {
            state.initializeToDummyValue();
        }
        cursor.setCursorException(String.format("Initializing key state to dummy value due to %s", reason));
    }

    @Override
    int numberOfStateSlots() {
        return this.states.length;
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(",", ((Object)((Object)this)).getClass().getSimpleName() + "[", "]");
        for (GenericKeyState state : this.states) {
            joiner.add(state.toString());
        }
        return joiner.toString();
    }
}

