/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.index.schema.CapabilityValidator;
import org.neo4j.kernel.impl.index.schema.CompositeGenericKey;
import org.neo4j.kernel.impl.index.schema.GenericNativeIndexProvider;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexReader;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.Values;

class GenericNativeIndexReader
extends NativeIndexReader<CompositeGenericKey, NativeIndexValue> {
    GenericNativeIndexReader(GBPTree<CompositeGenericKey, NativeIndexValue> tree, Layout<CompositeGenericKey, NativeIndexValue> layout, IndexSamplingConfig samplingConfig, IndexDescriptor descriptor) {
        super(tree, layout, samplingConfig, descriptor);
    }

    @Override
    public boolean hasFullValuePrecision(IndexQuery ... predicates) {
        return true;
    }

    @Override
    void validateQuery(IndexOrder indexOrder, IndexQuery[] predicates) {
        CapabilityValidator.validateQuery(GenericNativeIndexProvider.CAPABILITY, indexOrder, predicates);
    }

    @Override
    boolean initializeRangeForQuery(CompositeGenericKey treeKeyFrom, CompositeGenericKey treeKeyTo, IndexQuery[] predicates) {
        boolean needsFiltering = false;
        block7: for (int i = 0; i < predicates.length; ++i) {
            IndexQuery predicate = predicates[i];
            switch (predicate.type()) {
                case exists: {
                    treeKeyFrom.initValueAsLowest(i, ValueGroup.UNKNOWN);
                    treeKeyTo.initValueAsHighest(i, ValueGroup.UNKNOWN);
                    continue block7;
                }
                case exact: {
                    IndexQuery.ExactPredicate exactPredicate = (IndexQuery.ExactPredicate)predicate;
                    treeKeyFrom.initFromValue(i, exactPredicate.value(), NativeIndexKey.Inclusion.NEUTRAL);
                    treeKeyTo.initFromValue(i, exactPredicate.value(), NativeIndexKey.Inclusion.NEUTRAL);
                    continue block7;
                }
                case range: {
                    IndexQuery.RangePredicate rangePredicate = (IndexQuery.RangePredicate)predicate;
                    GenericNativeIndexReader.initFromForRange(i, rangePredicate, treeKeyFrom);
                    GenericNativeIndexReader.initToForRange(i, rangePredicate, treeKeyTo);
                    continue block7;
                }
                case stringPrefix: {
                    IndexQuery.StringPrefixPredicate prefixPredicate = (IndexQuery.StringPrefixPredicate)predicate;
                    treeKeyFrom.initAsPrefixLow(i, prefixPredicate.prefix());
                    treeKeyTo.initAsPrefixHigh(i, prefixPredicate.prefix());
                    continue block7;
                }
                case stringSuffix: 
                case stringContains: {
                    treeKeyFrom.initValueAsLowest(i, ValueGroup.TEXT);
                    treeKeyTo.initValueAsHighest(i, ValueGroup.TEXT);
                    needsFiltering = true;
                    continue block7;
                }
                default: {
                    throw new IllegalArgumentException("IndexQuery of type " + predicate.type() + " is not supported.");
                }
            }
        }
        return needsFiltering;
    }

    private static void initFromForRange(int stateSlot, IndexQuery.RangePredicate<?> rangePredicate, CompositeGenericKey treeKeyFrom) {
        Value fromValue = rangePredicate.fromValue();
        if (fromValue == Values.NO_VALUE) {
            treeKeyFrom.initValueAsLowest(stateSlot, ValueGroup.UNKNOWN);
        } else {
            treeKeyFrom.initFromValue(stateSlot, fromValue, rangePredicate.fromInclusive() ? NativeIndexKey.Inclusion.LOW : NativeIndexKey.Inclusion.HIGH);
            treeKeyFrom.setCompareId(true);
        }
    }

    private static void initToForRange(int stateSlot, IndexQuery.RangePredicate<?> rangePredicate, CompositeGenericKey treeKeyTo) {
        Value toValue = rangePredicate.toValue();
        if (toValue == Values.NO_VALUE) {
            treeKeyTo.initValueAsHighest(stateSlot, ValueGroup.UNKNOWN);
        } else {
            treeKeyTo.initFromValue(stateSlot, toValue, rangePredicate.toInclusive() ? NativeIndexKey.Inclusion.HIGH : NativeIndexKey.Inclusion.LOW);
            treeKeyTo.setCompareId(true);
        }
    }
}

