/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurveConfiguration;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.BoundedIterable;
import org.neo4j.helpers.collection.CombiningIterable;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.NodePropertyAccessor;
import org.neo4j.kernel.api.schema.index.StoreIndexDescriptor;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.index.schema.NativeIndexAccessor;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.kernel.impl.index.schema.SpatialIndexCache;
import org.neo4j.kernel.impl.index.schema.SpatialIndexFiles;
import org.neo4j.kernel.impl.index.schema.SpatialIndexKey;
import org.neo4j.kernel.impl.index.schema.SpatialIndexPartReader;
import org.neo4j.kernel.impl.index.schema.SpatialIndexPopulator;
import org.neo4j.kernel.impl.index.schema.SpatialIndexReader;
import org.neo4j.kernel.impl.index.schema.SpatialIndexUpdater;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexBase;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.values.storable.CoordinateReferenceSystem;

class SpatialIndexAccessor
extends SpatialIndexCache<PartAccessor>
implements IndexAccessor {
    private final StoreIndexDescriptor descriptor;

    SpatialIndexAccessor(StoreIndexDescriptor descriptor, IndexSamplingConfig samplingConfig, PageCache pageCache, FileSystemAbstraction fs, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, IndexProvider.Monitor monitor, SpatialIndexFiles spatialIndexFiles, SpaceFillingCurveConfiguration searchConfiguration) throws IOException {
        super(new PartFactory(pageCache, fs, recoveryCleanupWorkCollector, monitor, descriptor, samplingConfig, spatialIndexFiles, searchConfiguration));
        this.descriptor = descriptor;
        spatialIndexFiles.loadExistingIndexes(this);
    }

    @Override
    public void drop() {
        FusionIndexBase.forAll(NativeIndexAccessor::drop, this);
    }

    @Override
    public IndexUpdater newUpdater(IndexUpdateMode mode) {
        return new SpatialIndexUpdater(this, mode);
    }

    @Override
    public void force(IOLimiter ioLimiter) {
        for (NativeIndexAccessor part : this) {
            part.force(ioLimiter);
        }
    }

    @Override
    public void refresh() {
    }

    @Override
    public void close() {
        this.closeInstantiateCloseLock();
        FusionIndexBase.forAll(NativeIndexAccessor::close, this);
    }

    @Override
    public IndexReader newReader() {
        return new SpatialIndexReader(this.descriptor, this);
    }

    @Override
    public BoundedIterable<Long> newAllEntriesReader() {
        final ArrayList<BoundedIterable<Long>> allEntriesReader = new ArrayList<BoundedIterable<Long>>();
        for (NativeIndexAccessor part : this) {
            allEntriesReader.add(part.newAllEntriesReader());
        }
        return new BoundedIterable<Long>(){

            @Override
            public long maxCount() {
                long sum = 0L;
                for (BoundedIterable part : allEntriesReader) {
                    long partMaxCount = part.maxCount();
                    if (partMaxCount == -1L) {
                        return -1L;
                    }
                    sum += partMaxCount;
                }
                return sum;
            }

            @Override
            public void close() throws Exception {
                FusionIndexBase.forAll(AutoCloseable::close, allEntriesReader);
            }

            @Override
            public Iterator<Long> iterator() {
                return new CombiningIterable((Iterable)allEntriesReader).iterator();
            }
        };
    }

    @Override
    public ResourceIterator<File> snapshotFiles() {
        ArrayList<ResourceIterator<File>> snapshotFiles = new ArrayList<ResourceIterator<File>>();
        for (NativeIndexAccessor part : this) {
            snapshotFiles.add(part.snapshotFiles());
        }
        return Iterators.concatResourceIterators(snapshotFiles.iterator());
    }

    @Override
    public void verifyDeferredConstraints(NodePropertyAccessor nodePropertyAccessor) {
    }

    @Override
    public boolean isDirty() {
        return Iterators.stream(this.iterator()).anyMatch(NativeIndexAccessor::isDirty);
    }

    static class PartFactory
    implements SpatialIndexCache.Factory<PartAccessor> {
        private final PageCache pageCache;
        private final FileSystemAbstraction fs;
        private final RecoveryCleanupWorkCollector recoveryCleanupWorkCollector;
        private final IndexProvider.Monitor monitor;
        private final StoreIndexDescriptor descriptor;
        private final IndexSamplingConfig samplingConfig;
        private final SpatialIndexFiles spatialIndexFiles;
        private final SpaceFillingCurveConfiguration searchConfiguration;

        PartFactory(PageCache pageCache, FileSystemAbstraction fs, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, IndexProvider.Monitor monitor, StoreIndexDescriptor descriptor, IndexSamplingConfig samplingConfig, SpatialIndexFiles spatialIndexFiles, SpaceFillingCurveConfiguration searchConfiguration) {
            this.pageCache = pageCache;
            this.fs = fs;
            this.recoveryCleanupWorkCollector = recoveryCleanupWorkCollector;
            this.monitor = monitor;
            this.descriptor = descriptor;
            this.samplingConfig = samplingConfig;
            this.spatialIndexFiles = spatialIndexFiles;
            this.searchConfiguration = searchConfiguration;
        }

        @Override
        public PartAccessor newSpatial(CoordinateReferenceSystem crs) throws IOException {
            SpatialIndexFiles.SpatialFile spatialFile = this.spatialIndexFiles.forCrs(crs);
            if (!this.fs.fileExists(spatialFile.indexFile)) {
                SpatialIndexFiles.SpatialFileLayout fileLayout = spatialFile.getLayoutForNewIndex();
                this.createEmptyIndex(fileLayout);
                return this.createPartAccessor(fileLayout);
            }
            return this.createPartAccessor(spatialFile.getLayoutForExistingIndex(this.pageCache));
        }

        private PartAccessor createPartAccessor(SpatialIndexFiles.SpatialFileLayout fileLayout) throws IOException {
            return new PartAccessor(this.pageCache, this.fs, fileLayout, this.recoveryCleanupWorkCollector, this.monitor, this.descriptor, this.samplingConfig, this.searchConfiguration);
        }

        private void createEmptyIndex(SpatialIndexFiles.SpatialFileLayout fileLayout) {
            SpatialIndexPopulator.PartPopulator populator = new SpatialIndexPopulator.PartPopulator(this.pageCache, this.fs, fileLayout, this.monitor, this.descriptor, this.samplingConfig, this.searchConfiguration);
            populator.create();
            populator.close(true);
        }
    }

    static class PartAccessor
    extends NativeIndexAccessor<SpatialIndexKey, NativeIndexValue> {
        private final Layout<SpatialIndexKey, NativeIndexValue> layout;
        private final StoreIndexDescriptor descriptor;
        private final IndexSamplingConfig samplingConfig;
        private final SpaceFillingCurveConfiguration searchConfiguration;

        PartAccessor(PageCache pageCache, FileSystemAbstraction fs, SpatialIndexFiles.SpatialFileLayout fileLayout, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, IndexProvider.Monitor monitor, StoreIndexDescriptor descriptor, IndexSamplingConfig samplingConfig, SpaceFillingCurveConfiguration searchConfiguration) throws IOException {
            super(pageCache, fs, fileLayout.getIndexFile(), fileLayout.layout, recoveryCleanupWorkCollector, monitor, descriptor, samplingConfig);
            this.layout = fileLayout.layout;
            this.descriptor = descriptor;
            this.samplingConfig = samplingConfig;
            this.searchConfiguration = searchConfiguration;
        }

        @Override
        public SpatialIndexPartReader<NativeIndexValue> newReader() {
            this.assertOpen();
            return new SpatialIndexPartReader<NativeIndexValue>(this.tree, this.layout, this.samplingConfig, this.descriptor, this.searchConfiguration);
        }
    }
}

