/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import java.util.function.Supplier;
import org.neo4j.helpers.Listeners;
import org.neo4j.internal.kernel.api.Kernel;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleStatus;

public class DataSourceManager
implements Lifecycle,
Supplier<Kernel> {
    private LifeSupport life = new LifeSupport();
    private final Listeners<Listener> dsRegistrationListeners = new Listeners();
    private NeoStoreDataSource dataSource;

    public void addListener(Listener listener) {
        if (this.life.getStatus().equals((Object)LifecycleStatus.STARTED)) {
            try {
                if (this.dataSource != null) {
                    listener.registered(this.dataSource);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.dsRegistrationListeners.add(listener);
    }

    public void register(NeoStoreDataSource dataSource) {
        if (this.dataSource == null) {
            this.dataSource = dataSource;
            if (this.life.getStatus().equals((Object)LifecycleStatus.STARTED)) {
                this.dsRegistrationListeners.notify(listener -> listener.registered(dataSource));
            }
        }
    }

    public void unregister(NeoStoreDataSource dataSource) {
        this.dataSource = null;
        this.dsRegistrationListeners.notify(listener -> listener.unregistered(dataSource));
        this.life.remove((Lifecycle)dataSource);
    }

    public NeoStoreDataSource getDataSource() {
        return this.dataSource;
    }

    public void init() {
        this.life = new LifeSupport();
        this.life.add((Lifecycle)this.dataSource);
    }

    public void start() {
        this.life.start();
        for (Listener listener : this.dsRegistrationListeners) {
            try {
                if (this.dataSource == null) continue;
                listener.registered(this.dataSource);
            }
            catch (Throwable throwable) {}
        }
    }

    public void stop() {
        this.life.stop();
    }

    public void shutdown() {
        this.life.shutdown();
        this.dataSource = null;
    }

    @Override
    public Kernel get() {
        return this.dataSource.getKernel();
    }

    public static interface Listener {
        public void registered(NeoStoreDataSource var1);

        public void unregistered(NeoStoreDataSource var1);
    }
}

