/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.internal.locker;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.OpenMode;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.StoreLockException;

public class StoreLocker
implements Closeable {
    public static final String STORE_LOCK_FILENAME = "store_lock";
    final FileSystemAbstraction fileSystemAbstraction;
    final File storeLockFile;
    FileLock storeLockFileLock;
    private StoreChannel storeLockFileChannel;

    public StoreLocker(FileSystemAbstraction fileSystemAbstraction, File storeDirectory) {
        this.fileSystemAbstraction = fileSystemAbstraction;
        this.storeLockFile = new File(storeDirectory, STORE_LOCK_FILENAME);
    }

    public void checkLock() throws StoreLockException {
        if (this.haveLockAlready()) {
            return;
        }
        try {
            if (!this.fileSystemAbstraction.fileExists(this.storeLockFile)) {
                this.fileSystemAbstraction.mkdirs(this.storeLockFile.getParentFile());
            }
        }
        catch (IOException e) {
            String message = "Unable to create path for store dir: " + this.storeLockFile.getParent();
            throw StoreLocker.storeLockException(message, e);
        }
        try {
            if (this.storeLockFileChannel == null) {
                this.storeLockFileChannel = this.fileSystemAbstraction.open(this.storeLockFile, OpenMode.READ_WRITE);
            }
            this.storeLockFileLock = this.storeLockFileChannel.tryLock();
            if (this.storeLockFileLock == null) {
                String message = "Store and its lock file has been locked by another process: " + this.storeLockFile;
                throw StoreLocker.storeLockException(message, null);
            }
        }
        catch (IOException | OverlappingFileLockException e) {
            throw this.unableToObtainLockException();
        }
    }

    protected boolean haveLockAlready() {
        return this.storeLockFileLock != null && this.storeLockFileChannel != null;
    }

    StoreLockException unableToObtainLockException() {
        String message = "Unable to obtain lock on store lock file: " + this.storeLockFile;
        return StoreLocker.storeLockException(message, null);
    }

    private static StoreLockException storeLockException(String message, Exception e) {
        String help = "Please ensure no other process is using this database, and that the directory is writable (required even for read-only access)";
        return new StoreLockException(message + ". " + help, e);
    }

    @Override
    public void close() throws IOException {
        if (this.storeLockFileLock != null) {
            this.releaseLock();
        }
        if (this.storeLockFileChannel != null) {
            this.releaseChannel();
        }
    }

    private void releaseChannel() throws IOException {
        this.storeLockFileChannel.close();
        this.storeLockFileChannel = null;
    }

    protected void releaseLock() throws IOException {
        this.storeLockFileLock.release();
        this.storeLockFileLock = null;
    }
}

