/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.neo4j.graphdb.Resource;
import org.neo4j.io.ByteUnit;
import org.neo4j.kernel.impl.api.state.ValuesContainer;
import org.neo4j.kernel.impl.util.collection.Memory;
import org.neo4j.kernel.impl.util.collection.MemoryAllocator;
import org.neo4j.unsafe.impl.internal.dragons.UnsafeUtil;
import org.neo4j.util.Preconditions;
import org.neo4j.util.VisibleForTesting;
import org.neo4j.values.storable.ArrayValue;
import org.neo4j.values.storable.BooleanArray;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.ByteArray;
import org.neo4j.values.storable.ByteValue;
import org.neo4j.values.storable.CharArray;
import org.neo4j.values.storable.CharValue;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.DateArray;
import org.neo4j.values.storable.DateTimeArray;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.DoubleArray;
import org.neo4j.values.storable.DoubleValue;
import org.neo4j.values.storable.DurationArray;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.FloatArray;
import org.neo4j.values.storable.FloatValue;
import org.neo4j.values.storable.IntArray;
import org.neo4j.values.storable.IntValue;
import org.neo4j.values.storable.LocalDateTimeArray;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.LocalTimeArray;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.LongArray;
import org.neo4j.values.storable.LongValue;
import org.neo4j.values.storable.NoValue;
import org.neo4j.values.storable.PointArray;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.ShortArray;
import org.neo4j.values.storable.ShortValue;
import org.neo4j.values.storable.StringArray;
import org.neo4j.values.storable.StringValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.TimeArray;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.storable.TimeZones;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueWriter;
import org.neo4j.values.storable.Values;
import org.neo4j.values.utils.TemporalUtil;

public class AppendOnlyValuesContainer
implements ValuesContainer {
    private static final int CHUNK_SIZE = (int)ByteUnit.kibiBytes((long)512L);
    private static final int REMOVED = 255;
    private final int chunkSize;
    private final List<ByteBuffer> chunks = new ArrayList<ByteBuffer>();
    private final List<Memory> allocated = new ArrayList<Memory>();
    private final Writer writer;
    private final MemoryAllocator allocator;
    private ByteBuffer currentChunk;
    private boolean closed;

    public AppendOnlyValuesContainer(MemoryAllocator allocator) {
        this(CHUNK_SIZE, allocator);
    }

    @VisibleForTesting
    AppendOnlyValuesContainer(int chunkSize, MemoryAllocator allocator) {
        this.chunkSize = chunkSize;
        this.allocator = allocator;
        this.writer = new Writer();
        this.currentChunk = this.addNewChunk(chunkSize);
    }

    @Override
    public long add(@Nonnull Value value) {
        this.assertNotClosed();
        Objects.requireNonNull(value, "value cannot be null");
        ByteBuffer buf = this.writer.write(value);
        if (buf.remaining() > this.currentChunk.remaining()) {
            this.currentChunk = this.addNewChunk(Math.max(this.chunkSize, buf.remaining()));
        }
        long ref = (long)this.chunks.size() - 1L << 32 | (long)this.currentChunk.position();
        this.currentChunk.put(buf);
        return ref;
    }

    @Override
    @Nonnull
    public Value get(long ref) {
        this.assertNotClosed();
        int chunkIdx = (int)(ref >>> 32);
        int offset = (int)ref;
        Preconditions.checkArgument((chunkIdx >= 0 && chunkIdx < this.chunks.size() ? 1 : 0) != 0, (String)"invalid chunk idx %d (total #%d chunks), ref: 0x%X", (Object[])new Object[]{chunkIdx, this.chunks.size(), ref});
        ByteBuffer chunk = this.chunks.get(chunkIdx);
        Preconditions.checkArgument((offset >= 0 && offset < chunk.position() ? 1 : 0) != 0, (String)"invalid chunk offset (%d), ref: 0x%X", (Object[])new Object[]{offset, ref});
        int typeId = chunk.get(offset) & 0xFF;
        Preconditions.checkArgument((typeId != 255 ? 1 : 0) != 0, (String)"element is already removed, ref: 0x%X", (Object[])new Object[]{ref});
        Preconditions.checkArgument((typeId < ValueType.values().length ? 1 : 0) != 0, (String)"invaling typeId (%d) for ref 0x%X", (Object[])new Object[]{typeId, ref});
        ValueType type = ValueType.values()[typeId];
        return type.getReader().read(chunk, ++offset);
    }

    @Override
    @Nonnull
    public Value remove(long ref) {
        this.assertNotClosed();
        Value removed = this.get(ref);
        int chunkIdx = (int)(ref >>> 32);
        int chunkOffset = (int)ref;
        ByteBuffer chunk = this.chunks.get(chunkIdx);
        chunk.put(chunkOffset, (byte)-1);
        return removed;
    }

    public void close() {
        this.assertNotClosed();
        this.closed = true;
        this.allocated.forEach(Memory::free);
        this.allocated.clear();
        this.chunks.clear();
        this.writer.close();
        this.currentChunk = null;
    }

    private void assertNotClosed() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (String)"Container is closed");
    }

    private ByteBuffer addNewChunk(int size) {
        Memory memory = this.allocator.allocate(size);
        ByteBuffer chunk = memory.asByteBuffer();
        this.allocated.add(memory);
        this.chunks.add(chunk);
        return chunk;
    }

    private static BooleanValue readBoolean(ByteBuffer chunk, int offset) {
        return Values.booleanValue((chunk.get(offset) != 0 ? 1 : 0) != 0);
    }

    private static BooleanArray readBooleanArray(ByteBuffer bb, int offset) {
        int len = bb.getInt(offset);
        offset += 4;
        boolean[] array = new boolean[len];
        for (int i = 0; i < len; ++i) {
            array[i] = bb.get(offset) != 0;
            ++offset;
        }
        return Values.booleanArray((boolean[])array);
    }

    private static ByteValue readByte(ByteBuffer chunk, int offset) {
        return Values.byteValue((byte)chunk.get(offset));
    }

    private static ByteArray readByteArray(ByteBuffer bb, int offset) {
        int len = bb.getInt(offset);
        offset += 4;
        byte[] array = new byte[len];
        for (int i = 0; i < len; ++i) {
            array[i] = bb.get(offset);
            ++offset;
        }
        return Values.byteArray((byte[])array);
    }

    private static CharValue readChar(ByteBuffer chunk, int offset) {
        return Values.charValue((char)chunk.getChar(offset));
    }

    private static CharArray readCharArray(ByteBuffer bb, int offset) {
        int len = bb.getInt(offset);
        offset += 4;
        char[] array = new char[len];
        for (int i = 0; i < len; ++i) {
            array[i] = bb.getChar(offset);
            offset += 2;
        }
        return Values.charArray((char[])array);
    }

    private static DateValue readDate(ByteBuffer chunk, int offset) {
        return DateValue.epochDate((long)chunk.getLong(offset));
    }

    private static ArrayValue readDateArray(ByteBuffer bb, int offset) {
        int len = bb.getInt(offset);
        offset += 4;
        LocalDate[] array = new LocalDate[len];
        for (int i = 0; i < len; ++i) {
            array[i] = LocalDate.ofEpochDay(bb.getLong(offset));
            offset += 8;
        }
        return Values.dateArray((LocalDate[])array);
    }

    private static DoubleValue readDouble(ByteBuffer chunk, int offset) {
        return Values.doubleValue((double)chunk.getDouble(offset));
    }

    private static DoubleArray readDoubleArray(ByteBuffer bb, int offset) {
        int len = bb.getInt(offset);
        offset += 4;
        double[] array = new double[len];
        for (int i = 0; i < len; ++i) {
            array[i] = bb.getDouble(offset);
            offset += 8;
        }
        return Values.doubleArray((double[])array);
    }

    private static DurationValue readDuration(ByteBuffer bb, int offset) {
        long months = bb.getLong(offset);
        long days = bb.getLong(offset += 8);
        long seconds = bb.getLong(offset += 8);
        int nanos = bb.getInt(offset += 8);
        return DurationValue.duration((long)months, (long)days, (long)seconds, (long)nanos);
    }

    private static ArrayValue readDurationArray(ByteBuffer bb, int offset) {
        int len = bb.getInt(offset);
        offset += 4;
        DurationValue[] array = new DurationValue[len];
        for (int i = 0; i < len; ++i) {
            array[i] = AppendOnlyValuesContainer.readDuration(bb, offset);
            offset += 28;
        }
        return Values.durationArray((DurationValue[])array);
    }

    private static FloatValue readFloat(ByteBuffer chunk, int offset) {
        return Values.floatValue((float)chunk.getFloat(offset));
    }

    private static FloatArray readFloatArray(ByteBuffer bb, int offset) {
        int len = bb.getInt(offset);
        offset += 4;
        float[] array = new float[len];
        for (int i = 0; i < len; ++i) {
            array[i] = bb.getFloat(offset);
            offset += 4;
        }
        return Values.floatArray((float[])array);
    }

    private static IntValue readInt(ByteBuffer chunk, int offset) {
        return Values.intValue((int)chunk.getInt(offset));
    }

    private static IntArray readIntArray(ByteBuffer bb, int offset) {
        int len = bb.getInt(offset);
        offset += 4;
        int[] array = new int[len];
        for (int i = 0; i < len; ++i) {
            array[i] = bb.getInt(offset);
            offset += 4;
        }
        return Values.intArray((int[])array);
    }

    private static LocalDateTimeValue readLocalDateTime(ByteBuffer bb, int offset) {
        long epochSecond = bb.getLong(offset);
        int nanos = bb.getInt(offset += 8);
        return LocalDateTimeValue.localDateTime((long)epochSecond, (long)nanos);
    }

    private static ArrayValue readLocalDateTimeArray(ByteBuffer bb, int offset) {
        int len = bb.getInt(offset);
        offset += 4;
        LocalDateTime[] array = new LocalDateTime[len];
        for (int i = 0; i < len; ++i) {
            long epochSecond = bb.getLong(offset);
            int nanos = bb.getInt(offset += 8);
            offset += 4;
            array[i] = LocalDateTime.ofEpochSecond(epochSecond, nanos, ZoneOffset.UTC);
        }
        return Values.localDateTimeArray((LocalDateTime[])array);
    }

    private static LocalTimeValue readLocalTime(ByteBuffer chunk, int offset) {
        return LocalTimeValue.localTime((long)chunk.getLong(offset));
    }

    private static ArrayValue readLocalTimeArray(ByteBuffer bb, int offset) {
        int len = bb.getInt(offset);
        offset += 4;
        LocalTime[] array = new LocalTime[len];
        for (int i = 0; i < len; ++i) {
            array[i] = LocalTime.ofNanoOfDay(bb.getLong(offset));
            offset += 8;
        }
        return Values.localTimeArray((LocalTime[])array);
    }

    private static LongValue readLong(ByteBuffer chunk, int offset) {
        return Values.longValue((long)chunk.getLong(offset));
    }

    private static LongArray readLongArray(ByteBuffer bb, int offset) {
        int len = bb.getInt(offset);
        offset += 4;
        long[] array = new long[len];
        for (int i = 0; i < len; ++i) {
            array[i] = bb.getLong(offset);
            offset += 8;
        }
        return Values.longArray((long[])array);
    }

    private static PointValue readPoint(ByteBuffer chunk, int offset) {
        int crsCode = chunk.getInt(offset);
        offset += 4;
        CoordinateReferenceSystem crs = CoordinateReferenceSystem.get((int)crsCode);
        double[] coordinate = new double[crs.getDimension()];
        for (int i = 0; i < coordinate.length; ++i) {
            coordinate[i] = chunk.getDouble(offset);
            offset += 8;
        }
        return Values.pointValue((CoordinateReferenceSystem)crs, (double[])coordinate);
    }

    private static PointArray readPointArray(ByteBuffer bb, int offset) {
        int len = bb.getInt(offset);
        offset += 4;
        PointValue[] array = new PointValue[len];
        for (int i = 0; i < len; ++i) {
            PointValue point;
            array[i] = point = AppendOnlyValuesContainer.readPoint(bb, offset);
            offset += 4 + point.getCoordinateReferenceSystem().getDimension() * 8;
        }
        return Values.pointArray((PointValue[])array);
    }

    private static String readRawString(ByteBuffer chunk, int offset) {
        int len = chunk.getInt(offset);
        if (len == 0) {
            return "";
        }
        offset += 4;
        char[] chars = new char[len];
        for (int i = 0; i < len; ++i) {
            chars[i] = chunk.getChar(offset);
            offset += 2;
        }
        return UnsafeUtil.newSharedArrayString((char[])chars);
    }

    private static ShortValue readShort(ByteBuffer chunk, int offset) {
        return Values.shortValue((short)chunk.getShort(offset));
    }

    private static ShortArray readShortArray(ByteBuffer bb, int offset) {
        int len = bb.getInt(offset);
        offset += 4;
        short[] array = new short[len];
        for (int i = 0; i < len; ++i) {
            array[i] = bb.getShort(offset);
            offset += 2;
        }
        return Values.shortArray((short[])array);
    }

    private static TextValue readString(ByteBuffer chunk, int offset) {
        return Values.stringValue((String)AppendOnlyValuesContainer.readRawString(chunk, offset));
    }

    private static ArrayValue readStringArray(ByteBuffer bb, int offset) {
        int len = bb.getInt(offset);
        offset += 4;
        String[] array = new String[len];
        for (int i = 0; i < len; ++i) {
            String str;
            array[i] = str = AppendOnlyValuesContainer.readRawString(bb, offset);
            offset += 4 + str.length() * 2;
        }
        return Values.stringArray((String[])array);
    }

    private static TimeValue readTime(ByteBuffer bb, int offset) {
        return TimeValue.time((OffsetTime)AppendOnlyValuesContainer.readRawTime(bb, offset));
    }

    private static ArrayValue readTimeArray(ByteBuffer bb, int offset) {
        int len = bb.getInt(offset);
        offset += 4;
        OffsetTime[] array = new OffsetTime[len];
        for (int i = 0; i < len; ++i) {
            array[i] = AppendOnlyValuesContainer.readRawTime(bb, offset);
            offset += 12;
        }
        return Values.timeArray((OffsetTime[])array);
    }

    private static OffsetTime readRawTime(ByteBuffer bb, int offset) {
        long nanosOfDayUTC = bb.getLong(offset);
        int offsetSeconds = bb.getInt(offset += 8);
        return OffsetTime.ofInstant(Instant.ofEpochSecond(0L, nanosOfDayUTC), ZoneOffset.ofTotalSeconds(offsetSeconds));
    }

    private static DateTimeValue readDateTime(ByteBuffer bb, int offset) {
        long epocSeconds = bb.getLong(offset);
        int nanos = bb.getInt(offset += 8);
        int z = bb.getInt(offset += 4);
        return DateTimeValue.datetime((long)epocSeconds, (long)nanos, (ZoneId)AppendOnlyValuesContainer.toZoneId(z));
    }

    private static ZoneId toZoneId(int z) {
        if ((z & 1) != 0) {
            String zoneId = TimeZones.map((short)((short)(z >> 1)));
            return ZoneId.of(zoneId);
        }
        return ZoneOffset.ofTotalSeconds(z >> 1);
    }

    private static ArrayValue readDateTimeArray(ByteBuffer bb, int offset) {
        int len = bb.getInt(offset);
        offset += 4;
        ZonedDateTime[] array = new ZonedDateTime[len];
        for (int i = 0; i < len; ++i) {
            long epocSeconds = bb.getLong(offset);
            int nanos = bb.getInt(offset += 8);
            int z = bb.getInt(offset += 4);
            offset += 4;
            array[i] = ZonedDateTime.ofInstant(Instant.ofEpochSecond(epocSeconds, nanos), AppendOnlyValuesContainer.toZoneId(z));
        }
        return Values.dateTimeArray((ZonedDateTime[])array);
    }

    private class Writer
    implements ValueWriter<RuntimeException>,
    Resource {
        private ByteBuffer buf;
        private Memory bufMemory;

        Writer() {
            this.allocateBuf(AppendOnlyValuesContainer.this.chunkSize);
        }

        public void close() {
            this.bufMemory.free();
            this.bufMemory = null;
            this.buf = null;
        }

        ByteBuffer write(Value value) {
            Preconditions.checkState((this.buf != null ? 1 : 0) != 0, (String)"Writer is closed");
            try {
                this.buf.clear();
                this.buf.put((byte)ValueType.forValue(value).ordinal());
                value.writeTo((ValueWriter)this);
                this.buf.flip();
                return this.buf;
            }
            catch (BufferOverflowException e) {
                int newSize = this.buf.capacity() * 2;
                this.bufMemory.free();
                this.allocateBuf(newSize);
                return this.write(value);
            }
        }

        private void allocateBuf(int size) {
            this.bufMemory = AppendOnlyValuesContainer.this.allocator.allocate(size);
            this.buf = this.bufMemory.asByteBuffer();
        }

        public void writeNull() {
        }

        public void writeBoolean(boolean value) {
            this.buf.put((byte)(value ? 1 : 0));
        }

        public void writeInteger(byte value) {
            this.buf.put(value);
        }

        public void writeInteger(short value) {
            this.buf.putShort(value);
        }

        public void writeInteger(int value) {
            this.buf.putInt(value);
        }

        public void writeInteger(long value) {
            this.buf.putLong(value);
        }

        public void writeFloatingPoint(float value) {
            this.buf.putFloat(value);
        }

        public void writeFloatingPoint(double value) {
            this.buf.putDouble(value);
        }

        public void writeString(String value) {
            int len = value.length();
            this.buf.putInt(value.length());
            for (int i = 0; i < len; ++i) {
                char c = value.charAt(i);
                this.buf.putChar(c);
            }
        }

        public void writeString(char value) {
            this.buf.putChar(value);
        }

        public void beginArray(int size, ValueWriter.ArrayType arrayType) {
            this.buf.putInt(size);
        }

        public void endArray() {
        }

        public void writeByteArray(byte[] value) {
            this.buf.putInt(value.length);
            this.buf.put(value);
        }

        public void writePoint(CoordinateReferenceSystem crs, double[] coordinate) {
            Preconditions.checkArgument((coordinate.length == crs.getDimension() ? 1 : 0) != 0, (String)"Dimension for %s is %d, got %d", (Object[])new Object[]{crs.getName(), crs.getDimension(), coordinate.length});
            this.buf.putInt(crs.getCode());
            for (int i = 0; i < crs.getDimension(); ++i) {
                this.buf.putDouble(coordinate[i]);
            }
        }

        public void writeDuration(long months, long days, long seconds, int nanos) {
            this.buf.putLong(months);
            this.buf.putLong(days);
            this.buf.putLong(seconds);
            this.buf.putInt(nanos);
        }

        public void writeDate(LocalDate localDate) {
            this.buf.putLong(localDate.toEpochDay());
        }

        public void writeLocalTime(LocalTime localTime) {
            this.buf.putLong(localTime.toNanoOfDay());
        }

        public void writeTime(OffsetTime offsetTime) {
            this.buf.putLong(TemporalUtil.getNanosOfDayUTC((OffsetTime)offsetTime));
            this.buf.putInt(offsetTime.getOffset().getTotalSeconds());
        }

        public void writeLocalDateTime(LocalDateTime localDateTime) {
            this.buf.putLong(localDateTime.toEpochSecond(ZoneOffset.UTC));
            this.buf.putInt(localDateTime.getNano());
        }

        public void writeDateTime(ZonedDateTime zonedDateTime) {
            this.buf.putLong(zonedDateTime.toEpochSecond());
            this.buf.putInt(zonedDateTime.getNano());
            ZoneId zone = zonedDateTime.getZone();
            if (zone instanceof ZoneOffset) {
                int offsetSeconds = ((ZoneOffset)zone).getTotalSeconds();
                this.buf.putInt(offsetSeconds << 1);
            } else {
                int zoneId = TimeZones.map((String)zone.getId()) << 1 | 1;
                this.buf.putInt(zoneId);
            }
        }
    }

    @FunctionalInterface
    static interface ValueReader<T extends Value> {
        public T read(ByteBuffer var1, int var2);
    }

    private static enum ValueType {
        NO_VALUE(NoValue.class, (unused, unused2) -> NoValue.NO_VALUE),
        BOOLEAN(BooleanValue.class, (x$0, x$1) -> AppendOnlyValuesContainer.access$3200(x$0, x$1)),
        BOOLEAN_ARRAY(BooleanArray.class, (x$0, x$1) -> AppendOnlyValuesContainer.access$3100(x$0, x$1)),
        BYTE(ByteValue.class, (x$0, x$1) -> AppendOnlyValuesContainer.access$3000(x$0, x$1)),
        BYTE_ARRAY(ByteArray.class, (x$0, x$1) -> AppendOnlyValuesContainer.access$2900(x$0, x$1)),
        SHORT(ShortValue.class, (x$0, x$1) -> AppendOnlyValuesContainer.access$2800(x$0, x$1)),
        SHORT_ARRAY(ShortArray.class, (x$0, x$1) -> AppendOnlyValuesContainer.access$2700(x$0, x$1)),
        INT(IntValue.class, (x$0, x$1) -> AppendOnlyValuesContainer.access$2600(x$0, x$1)),
        INT_ARRAY(IntArray.class, (x$0, x$1) -> AppendOnlyValuesContainer.access$2500(x$0, x$1)),
        LONG(LongValue.class, (x$0, x$1) -> AppendOnlyValuesContainer.access$2400(x$0, x$1)),
        LONG_ARRAY(LongArray.class, (x$0, x$1) -> AppendOnlyValuesContainer.access$2300(x$0, x$1)),
        FLOAT(FloatValue.class, (x$0, x$1) -> AppendOnlyValuesContainer.access$2200(x$0, x$1)),
        FLOAT_ARRAY(FloatArray.class, (x$0, x$1) -> AppendOnlyValuesContainer.access$2100(x$0, x$1)),
        DOUBLE(DoubleValue.class, (x$0, x$1) -> AppendOnlyValuesContainer.access$2000(x$0, x$1)),
        DOUBLE_ARRAY(DoubleArray.class, (x$0, x$1) -> AppendOnlyValuesContainer.access$1900(x$0, x$1)),
        STRING(StringValue.class, (x$0, x$1) -> AppendOnlyValuesContainer.access$1800(x$0, x$1)),
        STRING_ARRAY(StringArray.class, (x$0, x$1) -> AppendOnlyValuesContainer.access$1700(x$0, x$1)),
        CHAR(CharValue.class, (x$0, x$1) -> AppendOnlyValuesContainer.access$1600(x$0, x$1)),
        CHAR_ARRAY(CharArray.class, (x$0, x$1) -> AppendOnlyValuesContainer.access$1500(x$0, x$1)),
        POINT(PointValue.class, (x$0, x$1) -> AppendOnlyValuesContainer.access$1400(x$0, x$1)),
        POINT_ARRAY(PointArray.class, (x$0, x$1) -> AppendOnlyValuesContainer.access$1300(x$0, x$1)),
        DURATION(DurationValue.class, (x$0, x$1) -> AppendOnlyValuesContainer.access$1200(x$0, x$1)),
        DURATION_ARRAY(DurationArray.class, (x$0, x$1) -> AppendOnlyValuesContainer.access$1100(x$0, x$1)),
        DATE(DateValue.class, (x$0, x$1) -> AppendOnlyValuesContainer.access$1000(x$0, x$1)),
        DATE_ARRAY(DateArray.class, (x$0, x$1) -> AppendOnlyValuesContainer.access$900(x$0, x$1)),
        TIME(TimeValue.class, (x$0, x$1) -> AppendOnlyValuesContainer.access$800(x$0, x$1)),
        TIME_ARRAY(TimeArray.class, (x$0, x$1) -> AppendOnlyValuesContainer.access$700(x$0, x$1)),
        DATE_TIME(DateTimeValue.class, (x$0, x$1) -> AppendOnlyValuesContainer.access$600(x$0, x$1)),
        DATE_TIME_ARRAY(DateTimeArray.class, (x$0, x$1) -> AppendOnlyValuesContainer.access$500(x$0, x$1)),
        LOCAL_TIME(LocalTimeValue.class, (x$0, x$1) -> AppendOnlyValuesContainer.access$400(x$0, x$1)),
        LOCAL_TIME_ARRAY(LocalTimeArray.class, (x$0, x$1) -> AppendOnlyValuesContainer.access$300(x$0, x$1)),
        LOCAL_DATE_TIME(LocalDateTimeValue.class, (x$0, x$1) -> AppendOnlyValuesContainer.access$200(x$0, x$1)),
        LOCAL_DATE_TIME_ARRAY(LocalDateTimeArray.class, (x$0, x$1) -> AppendOnlyValuesContainer.access$100(x$0, x$1));

        private final Class<?> valueClass;
        private final ValueReader reader;

        private <T extends Value> ValueType(Class<? extends T> valueClass, ValueReader<T> reader) {
            this.valueClass = valueClass;
            this.reader = reader;
        }

        private static ValueType forValue(Value value) {
            for (ValueType valueType : ValueType.values()) {
                if (!valueType.valueClass.isAssignableFrom(value.getClass())) continue;
                return valueType;
            }
            throw new IllegalArgumentException("Unsupported value type: " + value.getClass());
        }

        private ValueReader getReader() {
            return this.reader;
        }
    }
}

