/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.neo4j.internal.kernel.api.NamedToken;
import org.neo4j.kernel.impl.core.NonUniqueTokenException;

public class TokenRegistry {
    private final Map<String, Integer> nameToId = new ConcurrentHashMap<String, Integer>();
    private final Map<Integer, NamedToken> idToToken = new ConcurrentHashMap<Integer, NamedToken>();
    private final String tokenType;

    public TokenRegistry(String tokenType) {
        this.tokenType = tokenType;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public void setInitialTokens(List<NamedToken> tokens) {
        this.nameToId.clear();
        this.idToToken.clear();
        this.putAll(tokens);
    }

    private void putAndEnsureUnique(Map<String, Integer> nameToId, NamedToken token) {
        Integer previous = nameToId.putIfAbsent(token.name(), token.id());
        if (previous != null && previous.intValue() != token.id()) {
            this.idToToken.remove(token.id(), token);
            throw new NonUniqueTokenException(this.tokenType, token.name(), token.id(), previous);
        }
    }

    public void putAll(List<NamedToken> tokens) throws NonUniqueTokenException {
        HashMap<String, Integer> newNameToId = new HashMap<String, Integer>();
        HashMap<Integer, NamedToken> newIdToToken = new HashMap<Integer, NamedToken>();
        for (NamedToken token : tokens) {
            newIdToToken.put(token.id(), token);
            this.putAndEnsureUnique(newNameToId, token);
        }
        this.idToToken.putAll(newIdToToken);
        this.nameToId.putAll(newNameToId);
    }

    public void put(NamedToken token) throws NonUniqueTokenException {
        this.idToToken.put(token.id(), token);
        this.putAndEnsureUnique(this.nameToId, token);
    }

    public Integer getId(String name) {
        return this.nameToId.get(name);
    }

    public NamedToken getToken(int id) {
        return this.idToToken.get(id);
    }

    public Iterable<NamedToken> allTokens() {
        return this.idToToken.values();
    }

    public int size() {
        return this.nameToId.size();
    }
}

