/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.kernel.impl.index.schema.AbstractArrayType;
import org.neo4j.kernel.impl.index.schema.DurationType;
import org.neo4j.kernel.impl.index.schema.GenericKeyState;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.ValueWriter;

class DurationArrayType
extends AbstractArrayType<DurationValue> {
    DurationArrayType(byte typeId) {
        super(ValueGroup.DURATION_ARRAY, typeId, (o1, o2, i) -> DurationType.compare(o1.long0Array[i], o1.long1Array[i], o1.long2Array[i], o1.long3Array[i], o2.long0Array[i], o2.long1Array[i], o2.long2Array[i], o2.long3Array[i]), (k, i) -> DurationType.asValue(k.long0Array[i], k.long1Array[i], k.long2Array[i], k.long3Array[i]), (c, k, i) -> DurationType.put(c, k.long0Array[i], k.long1Array[i], k.long2Array[i], k.long3Array[i]), DurationType::read, DurationValue[]::new, ValueWriter.ArrayType.DURATION);
    }

    @Override
    int valueSize(GenericKeyState state) {
        return this.arrayKeySize(state, 28);
    }

    @Override
    void copyValue(GenericKeyState to, GenericKeyState from, int length) {
        this.initializeArray(to, length, null);
        System.arraycopy(from.long0Array, 0, to.long0Array, 0, length);
        System.arraycopy(from.long1Array, 0, to.long1Array, 0, length);
        System.arraycopy(from.long2Array, 0, to.long2Array, 0, length);
        System.arraycopy(from.long3Array, 0, to.long3Array, 0, length);
    }

    @Override
    void initializeArray(GenericKeyState key, int length, ValueWriter.ArrayType arrayType) {
        key.long0Array = DurationArrayType.ensureBigEnough(key.long0Array, length);
        key.long1Array = DurationArrayType.ensureBigEnough(key.long1Array, length);
        key.long2Array = DurationArrayType.ensureBigEnough(key.long2Array, length);
        key.long3Array = DurationArrayType.ensureBigEnough(key.long3Array, length);
    }

    void write(GenericKeyState state, int offset, long months, long days, long totalAvgSeconds, int nanos) {
        state.long0Array[offset] = totalAvgSeconds;
        state.long1Array[offset] = nanos;
        state.long2Array[offset] = months;
        state.long3Array[offset] = days;
    }
}

