/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashMap;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurveConfiguration;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Header;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.kernel.api.IndexCapability;
import org.neo4j.internal.kernel.api.IndexLimitation;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexValueCapability;
import org.neo4j.internal.kernel.api.schema.IndexProviderDescriptor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.index.schema.CompositeGenericKey;
import org.neo4j.kernel.impl.index.schema.GenericLayout;
import org.neo4j.kernel.impl.index.schema.GenericNativeIndexAccessor;
import org.neo4j.kernel.impl.index.schema.GenericNativeIndexPopulator;
import org.neo4j.kernel.impl.index.schema.NativeIndexHeaderReader;
import org.neo4j.kernel.impl.index.schema.NativeIndexProvider;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.kernel.impl.index.schema.config.ConfiguredSpaceFillingCurveSettingsCache;
import org.neo4j.kernel.impl.index.schema.config.IndexSpecificSpaceFillingCurveSettingsCache;
import org.neo4j.kernel.impl.index.schema.config.SpaceFillingCurveSettings;
import org.neo4j.kernel.impl.index.schema.config.SpaceFillingCurveSettingsFactory;
import org.neo4j.kernel.impl.index.schema.config.SpaceFillingCurveSettingsReader;
import org.neo4j.storageengine.api.schema.StoreIndexDescriptor;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.ValueCategory;

public class GenericNativeIndexProvider
extends NativeIndexProvider<CompositeGenericKey, NativeIndexValue, GenericLayout> {
    static final GraphDatabaseSettings.SchemaIndex SCHEMA_INDEX = GraphDatabaseSettings.SchemaIndex.NATIVE_BTREE10;
    public static final String KEY = SCHEMA_INDEX.providerName();
    public static final IndexProviderDescriptor DESCRIPTOR = new IndexProviderDescriptor(KEY, SCHEMA_INDEX.providerVersion());
    public static final IndexCapability CAPABILITY = new GenericIndexCapability();
    private final ConfiguredSpaceFillingCurveSettingsCache configuredSettings;
    private final SpaceFillingCurveConfiguration configuration;
    private final boolean archiveFailedIndex;

    public GenericNativeIndexProvider(int priority, IndexDirectoryStructure.Factory directoryStructureFactory, PageCache pageCache, FileSystemAbstraction fs, IndexProvider.Monitor monitor, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, boolean readOnly, Config config) {
        super(DESCRIPTOR, priority, directoryStructureFactory, pageCache, fs, monitor, recoveryCleanupWorkCollector, readOnly);
        this.configuredSettings = new ConfiguredSpaceFillingCurveSettingsCache(config);
        this.configuration = SpaceFillingCurveSettingsFactory.getConfiguredSpaceFillingCurveConfiguration(config);
        this.archiveFailedIndex = config.get(GraphDatabaseSettings.archive_failed_index);
    }

    @Override
    GenericLayout layout(StoreIndexDescriptor descriptor, File storeFile) {
        try {
            int numberOfSlots = descriptor.properties().length;
            HashMap<CoordinateReferenceSystem, SpaceFillingCurveSettings> settings = new HashMap<CoordinateReferenceSystem, SpaceFillingCurveSettings>();
            if (storeFile != null) {
                GBPTree.readHeader((PageCache)this.pageCache, (File)storeFile, (Header.Reader)new NativeIndexHeaderReader(new SpaceFillingCurveSettingsReader(settings)));
            }
            return new GenericLayout(numberOfSlots, new IndexSpecificSpaceFillingCurveSettingsCache(this.configuredSettings, settings));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    protected IndexPopulator newIndexPopulator(File storeFile, GenericLayout layout, StoreIndexDescriptor descriptor) {
        return new GenericNativeIndexPopulator(this.pageCache, this.fs, storeFile, layout, this.monitor, descriptor, layout.getSpaceFillingCurveSettings(), this.directoryStructure(), this.configuration, this.archiveFailedIndex);
    }

    @Override
    protected IndexAccessor newIndexAccessor(File storeFile, GenericLayout layout, StoreIndexDescriptor descriptor) throws IOException {
        return new GenericNativeIndexAccessor(this.pageCache, this.fs, storeFile, layout, this.recoveryCleanupWorkCollector, this.monitor, descriptor, layout.getSpaceFillingCurveSettings(), this.configuration);
    }

    @Override
    public IndexCapability getCapability() {
        return CAPABILITY;
    }

    private static class GenericIndexCapability
    implements IndexCapability {
        private final IndexLimitation[] limitations = new IndexLimitation[]{IndexLimitation.SLOW_CONTAINS};

        private GenericIndexCapability() {
        }

        public IndexOrder[] orderCapability(ValueCategory ... valueCategories) {
            if (this.supportOrdering(valueCategories)) {
                return IndexCapability.ORDER_BOTH;
            }
            return IndexCapability.ORDER_NONE;
        }

        public IndexValueCapability valueCapability(ValueCategory ... valueCategories) {
            for (ValueCategory valueCategory : valueCategories) {
                if (valueCategory == ValueCategory.GEOMETRY || valueCategory == ValueCategory.GEOMETRY_ARRAY) {
                    return IndexValueCapability.NO;
                }
                if (valueCategory != ValueCategory.UNKNOWN) continue;
                return IndexValueCapability.PARTIAL;
            }
            return IndexValueCapability.YES;
        }

        private boolean supportOrdering(ValueCategory[] valueCategories) {
            for (ValueCategory valueCategory : valueCategories) {
                if (valueCategory != ValueCategory.GEOMETRY && valueCategory != ValueCategory.GEOMETRY_ARRAY && valueCategory != ValueCategory.UNKNOWN) continue;
                return false;
            }
            return true;
        }

        public IndexLimitation[] limitations() {
            return this.limitations;
        }
    }
}

