/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.Arrays;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.index.schema.AbstractArrayType;
import org.neo4j.kernel.impl.index.schema.GenericKeyState;
import org.neo4j.kernel.impl.index.schema.GeometryType;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.ValueWriter;
import org.neo4j.values.storable.Values;

class GeometryArrayType
extends AbstractArrayType<PointValue> {
    GeometryArrayType(byte typeId) {
        super(ValueGroup.GEOMETRY_ARRAY, typeId, (o1, o2, i) -> GeometryType.compare(o1.long0Array[i], o1.long1, o1.long2, o2.long0Array[i], o2.long1, o2.long2), null, null, null, null, null);
    }

    @Override
    int valueSize(GenericKeyState state) {
        return 3 + this.arrayKeySize(state, 8);
    }

    @Override
    void copyValue(GenericKeyState to, GenericKeyState from, int length) {
        this.initializeArray(to, length, null);
        System.arraycopy(from.long0Array, 0, to.long0Array, 0, length);
        to.long1 = from.long1;
        to.long2 = from.long2;
    }

    @Override
    void initializeArray(GenericKeyState key, int length, ValueWriter.ArrayType arrayType) {
        key.long0Array = GeometryArrayType.ensureBigEnough(key.long0Array, length);
    }

    @Override
    Value asValue(GenericKeyState state) {
        return Values.NO_VALUE;
    }

    @Override
    void putValue(PageCursor cursor, GenericKeyState state) {
        GeometryType.putCrs(cursor, state.long1, state.long2);
        GeometryArrayType.putArray(cursor, state, (c, k, i) -> GeometryType.put(c, state.long0Array[i]));
    }

    @Override
    boolean readValue(PageCursor cursor, int size, GenericKeyState into) {
        GeometryType.readCrs(cursor, into);
        return GeometryArrayType.readArray(cursor, ValueWriter.ArrayType.POINT, GeometryArrayType::readGeometryArrayItem, into);
    }

    @Override
    String toString(GenericKeyState state) {
        return String.format("Geometry[tableId:%d, code:%d, rawValues:%s]", state.long1, state.long2, Arrays.toString(Arrays.copyOf(state.long0Array, state.arrayLength)));
    }

    private static boolean readGeometryArrayItem(PageCursor cursor, GenericKeyState into) {
        into.long0Array[into.currentArrayOffset++] = cursor.getLong();
        return true;
    }

    void write(GenericKeyState state, int offset, long derivedSpaceFillingCurveValue) {
        state.long0Array[offset] = derivedSpaceFillingCurveValue;
    }
}

