/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.index.schema.GenericKeyState;
import org.neo4j.kernel.impl.index.schema.Type;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.Values;

class GeometryType
extends Type {
    private static final int MASK_CODE = 0x3FFFFF;
    private static final int SHIFT_TABLE = Integer.bitCount(0x3FFFFF);
    private static final int MASK_TABLE_READ = 0xC00000;
    private static final int MASK_TABLE_PUT = 0xC00000 >>> SHIFT_TABLE;

    GeometryType(byte typeId) {
        super(ValueGroup.GEOMETRY, typeId, (Value)PointValue.MIN_VALUE, (Value)PointValue.MAX_VALUE);
    }

    @Override
    int valueSize(GenericKeyState state) {
        return 11;
    }

    @Override
    void copyValue(GenericKeyState to, GenericKeyState from) {
        to.long0 = from.long0;
        to.long1 = from.long1;
        to.long2 = from.long2;
        to.spaceFillingCurve = from.spaceFillingCurve;
    }

    @Override
    Value asValue(GenericKeyState state) {
        return Values.NO_VALUE;
    }

    @Override
    int compareValue(GenericKeyState left, GenericKeyState right) {
        return GeometryType.compare(left.long0, left.long1, left.long2, right.long0, right.long1, right.long2);
    }

    @Override
    void putValue(PageCursor cursor, GenericKeyState state) {
        GeometryType.putCrs(cursor, state.long1, state.long2);
        GeometryType.put(cursor, state.long0);
    }

    @Override
    boolean readValue(PageCursor cursor, int size, GenericKeyState into) {
        return GeometryType.readCrs(cursor, into) && GeometryType.read(cursor, into);
    }

    @Override
    String toString(GenericKeyState state) {
        return String.format("Geometry[tableId:%d, code:%d, rawValue:%d]", state.long1, state.long2, state.long0);
    }

    static int compare(long this_long0, long this_long1, long this_long2, long that_long0, long that_long1, long that_long2) {
        int tableIdComparison = Integer.compare((int)this_long1, (int)that_long1);
        if (tableIdComparison != 0) {
            return tableIdComparison;
        }
        int codeComparison = Integer.compare((int)this_long2, (int)that_long2);
        if (codeComparison != 0) {
            return codeComparison;
        }
        return Long.compare(this_long0, that_long0);
    }

    static void putCrs(PageCursor cursor, long long1, long long2) {
        if ((long1 & (long)(~MASK_TABLE_PUT)) != 0L) {
            throw new IllegalArgumentException("Table id must be 0 < tableId <= " + MASK_TABLE_PUT + ", but was " + long1);
        }
        if ((long2 & 0xFFFFFFFFFFC00000L) != 0L) {
            throw new IllegalArgumentException("Code must be 0 < code <= 4194303, but was " + long1);
        }
        int tableAndCode = (int)(long1 << SHIFT_TABLE | long2);
        GeometryType.put3BInt(cursor, tableAndCode);
    }

    static void put(PageCursor cursor, long long0) {
        cursor.putLong(long0);
    }

    private static void put3BInt(PageCursor cursor, int value) {
        cursor.putShort((short)value);
        cursor.putByte((byte)(value >>> 16));
    }

    static boolean readCrs(PageCursor cursor, GenericKeyState into) {
        int tableAndCode = GeometryType.read3BInt(cursor);
        into.long1 = (tableAndCode & 0xC00000) >>> SHIFT_TABLE;
        into.long2 = tableAndCode & 0x3FFFFF;
        return true;
    }

    static boolean read(PageCursor cursor, GenericKeyState into) {
        into.long0 = cursor.getLong();
        return true;
    }

    private static int read3BInt(PageCursor cursor) {
        int low = cursor.getShort() & 0xFFFF;
        int high = cursor.getByte() & 0xFF;
        int i = high << 16 | low;
        return i;
    }

    void write(GenericKeyState state, long derivedSpaceFillingCurveValue) {
        state.long0 = derivedSpaceFillingCurveValue;
    }
}

