/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.time.ZonedDateTime;
import org.neo4j.kernel.impl.index.schema.AbstractArrayType;
import org.neo4j.kernel.impl.index.schema.GenericKeyState;
import org.neo4j.kernel.impl.index.schema.ZonedDateTimeType;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.ValueWriter;

class ZonedDateTimeArrayType
extends AbstractArrayType<ZonedDateTime> {
    ZonedDateTimeArrayType(byte typeId) {
        super(ValueGroup.ZONED_DATE_TIME_ARRAY, typeId, (o1, o2, i) -> ZonedDateTimeType.compare(o1.long0Array[i], o1.long1Array[i], o1.long2Array[i], o1.long3Array[i], o2.long0Array[i], o2.long1Array[i], o2.long2Array[i], o2.long3Array[i]), (k, i) -> ZonedDateTimeType.asValueRaw(k.long0Array[i], k.long1Array[i], k.long2Array[i], k.long3Array[i]), (c, k, i) -> ZonedDateTimeType.put(c, k.long0Array[i], k.long1Array[i], k.long2Array[i], k.long3Array[i]), ZonedDateTimeType::read, ZonedDateTime[]::new, ValueWriter.ArrayType.ZONED_DATE_TIME);
    }

    @Override
    int valueSize(GenericKeyState state) {
        return this.arrayKeySize(state, 16);
    }

    @Override
    void copyValue(GenericKeyState to, GenericKeyState from, int length) {
        this.initializeArray(to, length, null);
        System.arraycopy(from.long0Array, 0, to.long0Array, 0, length);
        System.arraycopy(from.long1Array, 0, to.long1Array, 0, length);
        System.arraycopy(from.long2Array, 0, to.long2Array, 0, length);
        System.arraycopy(from.long3Array, 0, to.long3Array, 0, length);
    }

    @Override
    void initializeArray(GenericKeyState key, int length, ValueWriter.ArrayType arrayType) {
        key.long0Array = ZonedDateTimeArrayType.ensureBigEnough(key.long0Array, length);
        key.long1Array = ZonedDateTimeArrayType.ensureBigEnough(key.long1Array, length);
        key.long2Array = ZonedDateTimeArrayType.ensureBigEnough(key.long2Array, length);
        key.long3Array = ZonedDateTimeArrayType.ensureBigEnough(key.long3Array, length);
    }

    void write(GenericKeyState state, int offset, long epochSecondUTC, int nano, short zoneId, int offsetSeconds) {
        state.long0Array[offset] = epochSecondUTC;
        state.long1Array[offset] = nano;
        state.long2Array[offset] = zoneId;
        state.long3Array[offset] = offsetSeconds;
    }
}

