/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.time.OffsetTime;
import org.neo4j.kernel.impl.index.schema.AbstractArrayType;
import org.neo4j.kernel.impl.index.schema.GenericKeyState;
import org.neo4j.kernel.impl.index.schema.ZonedTimeType;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.ValueWriter;

class ZonedTimeArrayType
extends AbstractArrayType<OffsetTime> {
    ZonedTimeArrayType(byte typeId) {
        super(ValueGroup.ZONED_TIME_ARRAY, typeId, (o1, o2, i) -> ZonedTimeType.compare(o1.long0Array[i], o1.long1Array[i], o2.long0Array[i], o2.long1Array[i]), (k, i) -> ZonedTimeType.asValueRaw(k.long0Array[i], k.long1Array[i]), (c, k, i) -> ZonedTimeType.put(c, k.long0Array[i], k.long1Array[i]), ZonedTimeType::read, OffsetTime[]::new, ValueWriter.ArrayType.ZONED_TIME);
    }

    @Override
    int valueSize(GenericKeyState state) {
        return this.arrayKeySize(state, 12);
    }

    @Override
    void copyValue(GenericKeyState to, GenericKeyState from, int length) {
        this.initializeArray(to, length, null);
        System.arraycopy(from.long0Array, 0, to.long0Array, 0, length);
        System.arraycopy(from.long1Array, 0, to.long1Array, 0, length);
    }

    @Override
    void initializeArray(GenericKeyState key, int length, ValueWriter.ArrayType arrayType) {
        key.long0Array = ZonedTimeArrayType.ensureBigEnough(key.long0Array, length);
        key.long1Array = ZonedTimeArrayType.ensureBigEnough(key.long1Array, length);
    }

    void write(GenericKeyState state, int offset, long nanosOfDayUTC, int offsetSeconds) {
        state.long0Array[offset] = nanosOfDayUTC;
        state.long1Array[offset] = offsetSeconds;
    }
}

