/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.time.OffsetTime;
import java.time.ZoneOffset;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.index.schema.GenericKeyState;
import org.neo4j.kernel.impl.index.schema.Type;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.storable.TimeZones;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.Values;

class ZonedTimeType
extends Type {
    ZonedTimeType(byte typeId) {
        super(ValueGroup.ZONED_TIME, typeId, (Value)TimeValue.MIN_VALUE, (Value)TimeValue.MAX_VALUE);
    }

    @Override
    int valueSize(GenericKeyState state) {
        return 12;
    }

    @Override
    void copyValue(GenericKeyState to, GenericKeyState from) {
        to.long0 = from.long0;
        to.long1 = from.long1;
    }

    @Override
    Value asValue(GenericKeyState state) {
        return ZonedTimeType.asValue(state.long0, state.long1);
    }

    @Override
    int compareValue(GenericKeyState left, GenericKeyState right) {
        return ZonedTimeType.compare(left.long0, left.long1, right.long0, right.long1);
    }

    @Override
    void putValue(PageCursor cursor, GenericKeyState state) {
        ZonedTimeType.put(cursor, state.long0, state.long1);
    }

    @Override
    boolean readValue(PageCursor cursor, int size, GenericKeyState into) {
        return ZonedTimeType.read(cursor, into);
    }

    static Value asValue(long long0, long long1) {
        OffsetTime time = ZonedTimeType.asValueRaw(long0, long1);
        return time != null ? TimeValue.time((OffsetTime)time) : Values.NO_VALUE;
    }

    static OffsetTime asValueRaw(long long0, long long1) {
        if (TimeZones.validZoneOffset((int)((int)long1))) {
            return TimeValue.timeRaw((long)long0, (ZoneOffset)ZoneOffset.ofTotalSeconds((int)long1));
        }
        return null;
    }

    static void put(PageCursor cursor, long long0, long long1) {
        cursor.putLong(long0);
        cursor.putInt((int)long1);
    }

    static boolean read(PageCursor cursor, GenericKeyState into) {
        into.writeTime(cursor.getLong(), cursor.getInt());
        return true;
    }

    static int compare(long this_long0, long this_long1, long that_long0, long that_long1) {
        int compare = Long.compare(this_long0, that_long0);
        if (compare == 0) {
            compare = Integer.compare((int)this_long1, (int)that_long1);
        }
        return compare;
    }

    void write(GenericKeyState state, long nanosOfDayUTC, int offsetSeconds) {
        state.long0 = nanosOfDayUTC;
        state.long1 = offsetSeconds;
    }
}

