/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.EnumMap;
import java.util.List;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.internal.kernel.api.IndexCapability;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.schema.IndexProviderDescriptor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.index.schema.NativeIndexes;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexAccessor;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexPopulator;
import org.neo4j.kernel.impl.index.schema.fusion.IndexSlot;
import org.neo4j.kernel.impl.index.schema.fusion.InstanceSelector;
import org.neo4j.kernel.impl.index.schema.fusion.SlotSelector;
import org.neo4j.kernel.impl.newapi.UnionIndexCapability;
import org.neo4j.kernel.impl.storemigration.StoreMigrationParticipant;
import org.neo4j.storageengine.api.schema.StoreIndexDescriptor;
import org.neo4j.values.storable.ValueCategory;

public class FusionIndexProvider
extends IndexProvider {
    private final boolean archiveFailedIndex;
    private final InstanceSelector<IndexProvider> providers;
    private final SlotSelector slotSelector;
    private final DropAction dropAction;

    public FusionIndexProvider(IndexProvider stringProvider, IndexProvider numberProvider, IndexProvider spatialProvider, IndexProvider temporalProvider, IndexProvider luceneProvider, SlotSelector slotSelector, IndexProviderDescriptor descriptor, int priority, IndexDirectoryStructure.Factory directoryStructure, FileSystemAbstraction fs, boolean archiveFailedIndex) {
        super(descriptor, priority, directoryStructure);
        this.archiveFailedIndex = archiveFailedIndex;
        this.slotSelector = slotSelector;
        this.providers = new InstanceSelector();
        this.dropAction = new FileSystemDropAction(fs, this.directoryStructure());
        this.fillProvidersSelector(stringProvider, numberProvider, spatialProvider, temporalProvider, luceneProvider);
        slotSelector.validateSatisfied(this.providers);
    }

    private void fillProvidersSelector(IndexProvider stringProvider, IndexProvider numberProvider, IndexProvider spatialProvider, IndexProvider temporalProvider, IndexProvider luceneProvider) {
        this.providers.put(IndexSlot.STRING, stringProvider);
        this.providers.put(IndexSlot.NUMBER, numberProvider);
        this.providers.put(IndexSlot.SPATIAL, spatialProvider);
        this.providers.put(IndexSlot.TEMPORAL, temporalProvider);
        this.providers.put(IndexSlot.LUCENE, luceneProvider);
    }

    @Override
    public IndexPopulator getPopulator(StoreIndexDescriptor descriptor, IndexSamplingConfig samplingConfig) {
        EnumMap populators = this.providers.map(provider -> provider.getPopulator(descriptor, samplingConfig));
        return new FusionIndexPopulator(this.slotSelector, new InstanceSelector<IndexPopulator>(populators), descriptor.getId(), this.dropAction, this.archiveFailedIndex);
    }

    @Override
    public IndexAccessor getOnlineAccessor(StoreIndexDescriptor descriptor, IndexSamplingConfig samplingConfig) throws IOException {
        EnumMap accessors = this.providers.map(provider -> provider.getOnlineAccessor(descriptor, samplingConfig));
        return new FusionIndexAccessor(this.slotSelector, new InstanceSelector<IndexAccessor>(accessors), descriptor, this.dropAction);
    }

    @Override
    public String getPopulationFailure(StoreIndexDescriptor descriptor) throws IllegalStateException {
        StringBuilder builder = new StringBuilder();
        this.providers.forAll(p -> this.writeFailure(p.getClass().getSimpleName(), builder, (IndexProvider)p, descriptor));
        String failure = builder.toString();
        if (!failure.isEmpty()) {
            return failure;
        }
        throw new IllegalStateException("None of the indexes were in a failed state");
    }

    private void writeFailure(String indexName, StringBuilder builder, IndexProvider provider, StoreIndexDescriptor descriptor) {
        try {
            String failure = provider.getPopulationFailure(descriptor);
            builder.append(indexName);
            builder.append(": ");
            builder.append(failure);
            builder.append(' ');
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Override
    public InternalIndexState getInitialState(StoreIndexDescriptor descriptor) {
        Iterable statesIterable = this.providers.transform(p -> p.getInitialState(descriptor));
        List states = Iterables.asList(statesIterable);
        if (states.contains(InternalIndexState.FAILED)) {
            return InternalIndexState.FAILED;
        }
        if (states.contains(InternalIndexState.POPULATING)) {
            return InternalIndexState.POPULATING;
        }
        return InternalIndexState.ONLINE;
    }

    @Override
    public IndexCapability getCapability() {
        Iterable capabilities = this.providers.transform(IndexProvider::getCapability);
        return new UnionIndexCapability(capabilities){

            @Override
            public IndexOrder[] orderCapability(ValueCategory ... valueCategories) {
                if (valueCategories.length == 1 && valueCategories[0] == ValueCategory.UNKNOWN) {
                    return ORDER_NONE;
                }
                return super.orderCapability(valueCategories);
            }
        };
    }

    @Override
    public StoreMigrationParticipant storeMigrationParticipant(FileSystemAbstraction fs, PageCache pageCache) {
        return StoreMigrationParticipant.NOT_PARTICIPATING;
    }

    private static class FileSystemDropAction
    implements DropAction {
        private final FileSystemAbstraction fs;
        private final IndexDirectoryStructure directoryStructure;

        FileSystemDropAction(FileSystemAbstraction fs, IndexDirectoryStructure directoryStructure) {
            this.fs = fs;
            this.directoryStructure = directoryStructure;
        }

        @Override
        public void drop(long indexId, boolean archiveExistentIndex) {
            try {
                NativeIndexes.deleteIndex(this.fs, this.directoryStructure, indexId, archiveExistentIndex);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    @FunctionalInterface
    static interface DropAction {
        public void drop(long var1, boolean var3);

        default public void drop(long indexId) {
            this.drop(indexId, false);
        }
    }
}

