/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.util.Objects;
import org.neo4j.helpers.collection.LruCache;
import org.neo4j.kernel.impl.transaction.log.LogPosition;

public class TransactionMetadataCache {
    private static final int DEFAULT_TRANSACTION_CACHE_SIZE = 100000;
    private final LruCache<Long, TransactionMetadata> txStartPositionCache;

    public TransactionMetadataCache() {
        this(100000);
    }

    public TransactionMetadataCache(int transactionCacheSize) {
        this.txStartPositionCache = new LruCache("Tx start position cache", transactionCacheSize);
    }

    public void clear() {
        this.txStartPositionCache.clear();
    }

    public TransactionMetadata getTransactionMetadata(long txId) {
        return (TransactionMetadata)this.txStartPositionCache.get((Object)txId);
    }

    public TransactionMetadata cacheTransactionMetadata(long txId, LogPosition position, int masterId, int authorId, long checksum, long timeWritten) {
        if (position.getByteOffset() == -1L) {
            throw new RuntimeException("StartEntry.position is " + position);
        }
        TransactionMetadata result = new TransactionMetadata(masterId, authorId, position, checksum, timeWritten);
        this.txStartPositionCache.put((Object)txId, (Object)result);
        return result;
    }

    public static class TransactionMetadata {
        private final int masterId;
        private final int authorId;
        private final LogPosition startPosition;
        private final long checksum;
        private final long timeWritten;

        public TransactionMetadata(int masterId, int authorId, LogPosition startPosition, long checksum, long timeWritten) {
            this.masterId = masterId;
            this.authorId = authorId;
            this.startPosition = startPosition;
            this.checksum = checksum;
            this.timeWritten = timeWritten;
        }

        public int getMasterId() {
            return this.masterId;
        }

        public int getAuthorId() {
            return this.authorId;
        }

        public LogPosition getStartPosition() {
            return this.startPosition;
        }

        public long getChecksum() {
            return this.checksum;
        }

        public long getTimeWritten() {
            return this.timeWritten;
        }

        public String toString() {
            return "TransactionMetadata{masterId=" + this.masterId + ", authorId=" + this.authorId + ", startPosition=" + this.startPosition + ", checksum=" + this.checksum + ", timeWritten=" + this.timeWritten + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TransactionMetadata that = (TransactionMetadata)o;
            return this.masterId == that.masterId && this.authorId == that.authorId && this.checksum == that.checksum && this.timeWritten == that.timeWritten && Objects.equals(this.startPosition, that.startPosition);
        }

        public int hashCode() {
            int result = this.masterId;
            result = 31 * result + this.authorId;
            result = 31 * result + this.startPosition.hashCode();
            result = 31 * result + (int)(this.checksum ^ this.checksum >>> 32);
            result = 31 * result + (int)(this.timeWritten ^ this.timeWritten >>> 32);
            return result;
        }
    }
}

