/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.eclipse.collections.api.iterator.MutableLongIterator;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.impl.factory.Maps;
import org.eclipse.collections.impl.list.mutable.primitive.LongArrayList;
import org.neo4j.cursor.RawCursor;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Hit;
import org.neo4j.internal.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.NodePropertyAccessor;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.kernel.impl.index.schema.SpatialIndexKey;
import org.neo4j.storageengine.api.schema.StoreIndexDescriptor;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;

class SpatialVerifyDeferredConstraint {
    SpatialVerifyDeferredConstraint() {
    }

    static void verify(NodePropertyAccessor nodePropertyAccessor, IndexLayout<SpatialIndexKey, NativeIndexValue> layout, GBPTree<SpatialIndexKey, NativeIndexValue> tree, StoreIndexDescriptor descriptor) throws IndexEntryConflictException {
        SpatialIndexKey from = (SpatialIndexKey)((Object)layout.newKey());
        SpatialIndexKey to = (SpatialIndexKey)((Object)layout.newKey());
        SpatialVerifyDeferredConstraint.initializeKeys(from, to);
        try (RawCursor seek = tree.seek((Object)from, (Object)to);){
            SpatialVerifyDeferredConstraint.scanAndVerifyDuplicates(nodePropertyAccessor, descriptor, (RawCursor<Hit<SpatialIndexKey, NativeIndexValue>, IOException>)seek);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static void scanAndVerifyDuplicates(NodePropertyAccessor nodePropertyAccessor, StoreIndexDescriptor descriptor, RawCursor<Hit<SpatialIndexKey, NativeIndexValue>, IOException> seek) throws IOException, IndexEntryConflictException {
        Hit hit;
        LongArrayList nodesWithCollidingPoints = new LongArrayList();
        long prevRawBits = Long.MIN_VALUE;
        if (seek.next()) {
            hit = (Hit)seek.get();
            prevRawBits = ((SpatialIndexKey)((Object)hit.key())).rawValueBits;
            nodesWithCollidingPoints.add(((SpatialIndexKey)((Object)hit.key())).getEntityId());
        }
        while (seek.next()) {
            hit = (Hit)seek.get();
            SpatialIndexKey key = (SpatialIndexKey)((Object)hit.key());
            long currentRawBits = key.rawValueBits;
            long currentNodeId = key.getEntityId();
            if (prevRawBits != currentRawBits) {
                if (nodesWithCollidingPoints.size() > 1) {
                    SpatialVerifyDeferredConstraint.verifyConstraintOn(nodesWithCollidingPoints, nodePropertyAccessor, descriptor);
                }
                nodesWithCollidingPoints.clear();
            }
            nodesWithCollidingPoints.add(currentNodeId);
            prevRawBits = currentRawBits;
        }
        if (nodesWithCollidingPoints.size() > 1) {
            SpatialVerifyDeferredConstraint.verifyConstraintOn(nodesWithCollidingPoints, nodePropertyAccessor, descriptor);
        }
    }

    private static void verifyConstraintOn(LongArrayList nodeIds, NodePropertyAccessor nodePropertyAccessor, StoreIndexDescriptor descriptor) throws IndexEntryConflictException {
        MutableMap points = Maps.mutable.empty();
        MutableLongIterator iter = nodeIds.longIterator();
        try {
            while (iter.hasNext()) {
                long id = iter.next();
                Value value = nodePropertyAccessor.getNodePropertyValue(id, descriptor.schema().getPropertyId());
                Long other = (Long)points.getIfAbsentPut((Object)value, (Object)id);
                if (other == id) continue;
                throw new IndexEntryConflictException((long)other, id, value);
            }
        }
        catch (EntityNotFoundException e) {
            throw new RuntimeException("Failed to validate uniqueness constraint", e);
        }
    }

    private static void initializeKeys(SpatialIndexKey from, SpatialIndexKey to) {
        from.initialize(Long.MIN_VALUE);
        to.initialize(Long.MAX_VALUE);
        from.initValueAsLowest(ValueGroup.GEOMETRY);
        to.initValueAsHighest(ValueGroup.GEOMETRY);
    }
}

