/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.File;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.factory.OperationalMode;
import org.neo4j.kernel.impl.index.schema.AbstractIndexProviderFactory;
import org.neo4j.kernel.impl.index.schema.GenericNativeIndexProvider;

public class GenericNativeIndexProviderFactory
extends AbstractIndexProviderFactory<Dependencies> {
    public GenericNativeIndexProviderFactory() {
        super(GenericNativeIndexProvider.KEY);
    }

    @Override
    protected Class loggingClass() {
        return GenericNativeIndexProvider.class;
    }

    @Override
    protected String descriptorString() {
        return GenericNativeIndexProvider.DESCRIPTOR.toString();
    }

    @Override
    protected GenericNativeIndexProvider internalCreate(PageCache pageCache, File storeDir, FileSystemAbstraction fs, IndexProvider.Monitor monitor, Config config, OperationalMode operationalMode, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector) {
        return GenericNativeIndexProviderFactory.create(pageCache, storeDir, fs, monitor, config, operationalMode, recoveryCleanupWorkCollector);
    }

    public static GenericNativeIndexProvider create(PageCache pageCache, File storeDir, FileSystemAbstraction fs, IndexProvider.Monitor monitor, Config config, OperationalMode mode, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector) {
        IndexDirectoryStructure.Factory directoryStructure = IndexDirectoryStructure.directoriesByProvider(storeDir);
        boolean readOnly = config.get(GraphDatabaseSettings.read_only) != false && OperationalMode.single == mode;
        return new GenericNativeIndexProvider(directoryStructure, pageCache, fs, monitor, recoveryCleanupWorkCollector, readOnly, config);
    }

    public static interface Dependencies
    extends AbstractIndexProviderFactory.Dependencies {
    }
}

