/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.mutable.MutableInt;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.ExplicitIndexRead;
import org.neo4j.internal.kernel.api.ExplicitIndexWrite;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.IndexReference;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.Locks;
import org.neo4j.internal.kernel.api.Procedures;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.SchemaWrite;
import org.neo4j.internal.kernel.api.Token;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.internal.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.exceptions.explicitindex.AutoIndexingKernelException;
import org.neo4j.internal.kernel.api.exceptions.explicitindex.ExplicitIndexNotFoundKernelException;
import org.neo4j.internal.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.internal.kernel.api.exceptions.schema.CreateConstraintFailureException;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotApplicableKernelException;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.internal.kernel.api.schema.IndexProviderDescriptor;
import org.neo4j.internal.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.RelationTypeSchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.kernel.api.SilentTokenNameLookup;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.exceptions.schema.AlreadyConstrainedException;
import org.neo4j.kernel.api.exceptions.schema.AlreadyIndexedException;
import org.neo4j.kernel.api.exceptions.schema.DropConstraintFailureException;
import org.neo4j.kernel.api.exceptions.schema.DropIndexFailureException;
import org.neo4j.kernel.api.exceptions.schema.IndexBelongsToConstraintException;
import org.neo4j.kernel.api.exceptions.schema.IndexBrokenKernelException;
import org.neo4j.kernel.api.exceptions.schema.NoSuchConstraintException;
import org.neo4j.kernel.api.exceptions.schema.NoSuchIndexException;
import org.neo4j.kernel.api.exceptions.schema.RepeatedLabelInSchemaException;
import org.neo4j.kernel.api.exceptions.schema.RepeatedPropertyInSchemaException;
import org.neo4j.kernel.api.exceptions.schema.RepeatedRelationshipTypeInSchemaException;
import org.neo4j.kernel.api.exceptions.schema.RepeatedSchemaComponentException;
import org.neo4j.kernel.api.exceptions.schema.UnableToValidateConstraintException;
import org.neo4j.kernel.api.exceptions.schema.UniquePropertyValueValidationException;
import org.neo4j.kernel.api.explicitindex.AutoIndexing;
import org.neo4j.kernel.api.schema.constraints.ConstraintDescriptor;
import org.neo4j.kernel.api.schema.constraints.ConstraintDescriptorFactory;
import org.neo4j.kernel.api.schema.constraints.IndexBackedConstraintDescriptor;
import org.neo4j.kernel.api.schema.constraints.NodeKeyConstraintDescriptor;
import org.neo4j.kernel.api.schema.constraints.UniquenessConstraintDescriptor;
import org.neo4j.kernel.api.txstate.ExplicitIndexTransactionState;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.state.ConstraintIndexCreator;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.index.IndexEntityType;
import org.neo4j.kernel.impl.locking.ResourceTypes;
import org.neo4j.kernel.impl.newapi.AllStoreHolder;
import org.neo4j.kernel.impl.newapi.DefaultCursors;
import org.neo4j.kernel.impl.newapi.DefaultNodeCursor;
import org.neo4j.kernel.impl.newapi.DefaultNodeLabelIndexCursor;
import org.neo4j.kernel.impl.newapi.DefaultNodeValueIndexCursor;
import org.neo4j.kernel.impl.newapi.DefaultPropertyCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipScanCursor;
import org.neo4j.kernel.impl.newapi.IndexReaders;
import org.neo4j.kernel.impl.newapi.IndexTxStateUpdater;
import org.neo4j.kernel.impl.newapi.KernelToken;
import org.neo4j.kernel.impl.newapi.NodeSchemaMatcher;
import org.neo4j.kernel.impl.newapi.TwoPhaseNodeForRelationshipLocking;
import org.neo4j.storageengine.api.EntityType;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.lock.ResourceType;
import org.neo4j.storageengine.api.schema.IndexDescriptor;
import org.neo4j.storageengine.api.schema.IndexDescriptorFactory;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class Operations
implements Write,
ExplicitIndexWrite,
SchemaWrite {
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private final KernelTransactionImplementation ktx;
    private final AllStoreHolder allStoreHolder;
    private final KernelToken token;
    private final StorageReader statement;
    private final AutoIndexing autoIndexing;
    private final IndexTxStateUpdater updater;
    private final DefaultCursors cursors;
    private final ConstraintIndexCreator constraintIndexCreator;
    private final ConstraintSemantics constraintSemantics;
    private final IndexingService indexingService;
    private final Config config;
    private DefaultNodeCursor nodeCursor;
    private DefaultPropertyCursor propertyCursor;
    private DefaultRelationshipScanCursor relationshipCursor;

    public Operations(AllStoreHolder allStoreHolder, IndexTxStateUpdater updater, StorageReader statement, KernelTransactionImplementation ktx, KernelToken token, DefaultCursors cursors, AutoIndexing autoIndexing, ConstraintIndexCreator constraintIndexCreator, ConstraintSemantics constraintSemantics, IndexingService indexingService, Config config) {
        this.token = token;
        this.autoIndexing = autoIndexing;
        this.allStoreHolder = allStoreHolder;
        this.ktx = ktx;
        this.statement = statement;
        this.updater = updater;
        this.cursors = cursors;
        this.constraintIndexCreator = constraintIndexCreator;
        this.constraintSemantics = constraintSemantics;
        this.indexingService = indexingService;
        this.config = config;
    }

    public void initialize() {
        this.nodeCursor = this.cursors.allocateNodeCursor();
        this.propertyCursor = this.cursors.allocatePropertyCursor();
        this.relationshipCursor = this.cursors.allocateRelationshipScanCursor();
    }

    public long nodeCreate() {
        this.ktx.assertOpen();
        long nodeId = this.statement.reserveNode();
        this.ktx.txState().nodeDoCreate(nodeId);
        return nodeId;
    }

    public long nodeCreateWithLabels(int[] labels) throws ConstraintValidationException {
        if (labels == null || labels.length == 0) {
            return this.nodeCreate();
        }
        this.ktx.assertOpen();
        long[] lockingIds = SchemaDescriptor.schemaTokenLockingIds((int[])labels);
        Arrays.sort(lockingIds);
        this.ktx.statementLocks().optimistic().acquireShared(this.ktx.lockTracer(), ResourceTypes.LABEL, lockingIds);
        long nodeId = this.statement.reserveNode();
        this.ktx.txState().nodeDoCreate(nodeId);
        this.nodeCursor.single(nodeId, this.allStoreHolder);
        this.nodeCursor.next();
        int prevLabel = -1;
        for (long lockingId : lockingIds) {
            int label = (int)lockingId;
            if (label == prevLabel) continue;
            this.checkConstraintsAndAddLabelToNode(nodeId, label);
            prevLabel = label;
        }
        return nodeId;
    }

    public boolean nodeDelete(long node) throws AutoIndexingKernelException {
        this.ktx.assertOpen();
        return this.nodeDelete(node, true);
    }

    public int nodeDetachDelete(long nodeId) throws KernelException {
        MutableInt count = new MutableInt();
        TwoPhaseNodeForRelationshipLocking locking = new TwoPhaseNodeForRelationshipLocking((ThrowingConsumer<Long, KernelException>)((ThrowingConsumer)relId -> {
            this.ktx.assertOpen();
            if (this.relationshipDelete((long)relId, false)) {
                count.increment();
            }
        }), this.ktx.statementLocks().optimistic(), this.ktx.lockTracer());
        locking.lockAllNodesAndConsumeRelationships(nodeId, this.ktx, this.ktx.ambientNodeCursor());
        this.ktx.assertOpen();
        this.nodeDelete(nodeId, false);
        return count.intValue();
    }

    public long relationshipCreate(long sourceNode, int relationshipType, long targetNode) throws EntityNotFoundException {
        this.ktx.assertOpen();
        this.sharedSchemaLock(ResourceTypes.RELATIONSHIP_TYPE, relationshipType);
        this.lockRelationshipNodes(sourceNode, targetNode);
        this.assertNodeExists(sourceNode);
        this.assertNodeExists(targetNode);
        long id = this.statement.reserveRelationship();
        this.ktx.txState().relationshipDoCreate(id, relationshipType, sourceNode, targetNode);
        return id;
    }

    public boolean relationshipDelete(long relationship) throws AutoIndexingKernelException {
        this.ktx.assertOpen();
        return this.relationshipDelete(relationship, true);
    }

    public boolean nodeAddLabel(long node, int nodeLabel) throws EntityNotFoundException, ConstraintValidationException {
        this.sharedSchemaLock(ResourceTypes.LABEL, nodeLabel);
        this.acquireExclusiveNodeLock(node);
        this.singleNode(node);
        if (this.nodeCursor.hasLabel(nodeLabel)) {
            return false;
        }
        this.checkConstraintsAndAddLabelToNode(node, nodeLabel);
        return true;
    }

    private void checkConstraintsAndAddLabelToNode(long node, int nodeLabel) throws UniquePropertyValueValidationException, UnableToValidateConstraintException {
        int[] existingPropertyKeyIds = this.loadSortedPropertyKeyList();
        if (existingPropertyKeyIds.length > 0) {
            for (IndexBackedConstraintDescriptor uniquenessConstraint : this.indexingService.getRelatedUniquenessConstraints(new long[]{nodeLabel}, existingPropertyKeyIds, EntityType.NODE)) {
                IndexQuery.ExactPredicate[] propertyValues = this.getAllPropertyValues((SchemaDescriptor)uniquenessConstraint.schema(), -1, Values.NO_VALUE);
                if (propertyValues == null) continue;
                this.validateNoExistingNodeWithExactValues(uniquenessConstraint, propertyValues, node);
            }
        }
        this.ktx.txState().nodeDoAddLabel(nodeLabel, node);
        this.updater.onLabelChange(nodeLabel, existingPropertyKeyIds, this.nodeCursor, this.propertyCursor, IndexTxStateUpdater.LabelChangeType.ADDED_LABEL);
    }

    private int[] loadSortedPropertyKeyList() {
        this.nodeCursor.properties(this.propertyCursor);
        if (!this.propertyCursor.next()) {
            return EMPTY_INT_ARRAY;
        }
        int[] propertyKeyIds = new int[4];
        int cursor = 0;
        do {
            if (cursor == propertyKeyIds.length) {
                propertyKeyIds = Arrays.copyOf(propertyKeyIds, cursor * 2);
            }
            propertyKeyIds[cursor++] = this.propertyCursor.propertyKey();
        } while (this.propertyCursor.next());
        if (cursor != propertyKeyIds.length) {
            propertyKeyIds = Arrays.copyOf(propertyKeyIds, cursor);
        }
        Arrays.sort(propertyKeyIds);
        return propertyKeyIds;
    }

    private boolean nodeDelete(long node, boolean lock) throws AutoIndexingKernelException {
        this.ktx.assertOpen();
        if (this.ktx.hasTxStateWithChanges()) {
            if (this.ktx.txState().nodeIsAddedInThisTx(node)) {
                this.autoIndexing.nodes().entityRemoved(this, node);
                this.ktx.txState().nodeDoDelete(node);
                return true;
            }
            if (this.ktx.txState().nodeIsDeletedInThisTx(node)) {
                return false;
            }
        }
        if (lock) {
            this.ktx.statementLocks().optimistic().acquireExclusive(this.ktx.lockTracer(), ResourceTypes.NODE, node);
        }
        this.allStoreHolder.singleNode(node, this.nodeCursor);
        if (this.nodeCursor.next()) {
            this.acquireSharedNodeLabelLocks();
            this.autoIndexing.nodes().entityRemoved(this, node);
            this.ktx.txState().nodeDoDelete(node);
            return true;
        }
        return false;
    }

    private long[] acquireSharedNodeLabelLocks() {
        long[] labels = this.nodeCursor.labels().all();
        this.ktx.statementLocks().optimistic().acquireShared(this.ktx.lockTracer(), ResourceTypes.LABEL, labels);
        return labels;
    }

    private boolean relationshipDelete(long relationship, boolean lock) throws AutoIndexingKernelException {
        this.allStoreHolder.singleRelationship(relationship, this.relationshipCursor);
        if (this.relationshipCursor.next()) {
            if (lock) {
                this.lockRelationshipNodes(this.relationshipCursor.sourceNodeReference(), this.relationshipCursor.targetNodeReference());
                this.acquireExclusiveRelationshipLock(relationship);
            }
            if (!this.allStoreHolder.relationshipExists(relationship)) {
                return false;
            }
            this.ktx.assertOpen();
            this.autoIndexing.relationships().entityRemoved(this, relationship);
            TransactionState txState = this.ktx.txState();
            if (txState.relationshipIsAddedInThisTx(relationship)) {
                txState.relationshipDoDeleteAddedInThisTx(relationship);
            } else {
                txState.relationshipDoDelete(relationship, this.relationshipCursor.type(), this.relationshipCursor.sourceNodeReference(), this.relationshipCursor.targetNodeReference());
            }
            return true;
        }
        return false;
    }

    private void singleNode(long node) throws EntityNotFoundException {
        this.allStoreHolder.singleNode(node, this.nodeCursor);
        if (!this.nodeCursor.next()) {
            throw new EntityNotFoundException(EntityType.NODE, node);
        }
    }

    private void singleRelationship(long relationship) throws EntityNotFoundException {
        this.allStoreHolder.singleRelationship(relationship, this.relationshipCursor);
        if (!this.relationshipCursor.next()) {
            throw new EntityNotFoundException(EntityType.RELATIONSHIP, relationship);
        }
    }

    private IndexQuery.ExactPredicate[] getAllPropertyValues(SchemaDescriptor schema, int changedPropertyKeyId, Value changedValue) {
        int k;
        int[] schemaPropertyIds = schema.getPropertyIds();
        IndexQuery.ExactPredicate[] values = new IndexQuery.ExactPredicate[schemaPropertyIds.length];
        int nMatched = 0;
        this.nodeCursor.properties(this.propertyCursor);
        while (this.propertyCursor.next()) {
            int nodePropertyId = this.propertyCursor.propertyKey();
            int k2 = ArrayUtils.indexOf((int[])schemaPropertyIds, (int)nodePropertyId);
            if (k2 < 0) continue;
            if (nodePropertyId != -1) {
                values[k2] = IndexQuery.exact((int)nodePropertyId, (Object)this.propertyCursor.propertyValue());
            }
            ++nMatched;
        }
        if (changedPropertyKeyId != -1 && (k = ArrayUtils.indexOf((int[])schemaPropertyIds, (int)changedPropertyKeyId)) >= 0) {
            values[k] = IndexQuery.exact((int)changedPropertyKeyId, (Object)changedValue);
            ++nMatched;
        }
        if (nMatched < values.length) {
            return null;
        }
        return values;
    }

    private void validateNoExistingNodeWithExactValues(IndexBackedConstraintDescriptor constraint, IndexQuery.ExactPredicate[] propertyValues, long modifiedNode) throws UniquePropertyValueValidationException, UnableToValidateConstraintException {
        IndexDescriptor schemaIndexDescriptor = constraint.ownedIndexDescriptor();
        IndexReference indexReference = this.allStoreHolder.indexGetCapability(schemaIndexDescriptor);
        try (DefaultNodeValueIndexCursor valueCursor = this.cursors.allocateNodeValueIndexCursor();
             IndexReaders indexReaders = new IndexReaders(indexReference, this.allStoreHolder);){
            this.assertIndexOnline(schemaIndexDescriptor);
            int labelId = schemaIndexDescriptor.schema().keyId();
            this.ktx.statementLocks().optimistic().acquireExclusive(this.ktx.lockTracer(), ResourceTypes.INDEX_ENTRY, ResourceTypes.indexEntryResourceId(labelId, propertyValues));
            this.allStoreHolder.nodeIndexSeekWithFreshIndexReader(valueCursor, indexReaders.createReader(), propertyValues);
            if (valueCursor.next() && valueCursor.nodeReference() != modifiedNode) {
                throw new UniquePropertyValueValidationException(constraint, ConstraintValidationException.Phase.VALIDATION, new IndexEntryConflictException(valueCursor.nodeReference(), -1L, IndexQuery.asValueTuple((IndexQuery.ExactPredicate[])propertyValues)));
            }
        }
        catch (IndexNotApplicableKernelException | IndexNotFoundKernelException | IndexBrokenKernelException e) {
            throw new UnableToValidateConstraintException(constraint, (Throwable)e);
        }
    }

    private void assertIndexOnline(IndexDescriptor descriptor) throws IndexNotFoundKernelException, IndexBrokenKernelException {
        if (this.allStoreHolder.indexGetState(descriptor) != InternalIndexState.ONLINE) {
            throw new IndexBrokenKernelException(this.allStoreHolder.indexGetFailure(descriptor));
        }
    }

    public boolean nodeRemoveLabel(long node, int labelId) throws EntityNotFoundException {
        this.acquireExclusiveNodeLock(node);
        this.ktx.assertOpen();
        this.singleNode(node);
        if (!this.nodeCursor.hasLabel(labelId)) {
            return false;
        }
        this.sharedSchemaLock(ResourceTypes.LABEL, labelId);
        this.ktx.txState().nodeDoRemoveLabel(labelId, node);
        if (this.indexingService.hasRelatedSchema(labelId, EntityType.NODE)) {
            this.updater.onLabelChange(labelId, this.loadSortedPropertyKeyList(), this.nodeCursor, this.propertyCursor, IndexTxStateUpdater.LabelChangeType.REMOVED_LABEL);
        }
        return true;
    }

    public Value nodeSetProperty(long node, int propertyKey, Value value) throws EntityNotFoundException, ConstraintValidationException, AutoIndexingKernelException {
        this.acquireExclusiveNodeLock(node);
        this.ktx.assertOpen();
        this.singleNode(node);
        long[] labels = this.acquireSharedNodeLabelLocks();
        Value existingValue = this.readNodeProperty(propertyKey);
        int[] existingPropertyKeyIds = null;
        boolean hasRelatedSchema = this.indexingService.hasRelatedSchema(labels, propertyKey, EntityType.NODE);
        if (hasRelatedSchema) {
            existingPropertyKeyIds = this.loadSortedPropertyKeyList();
        }
        if (hasRelatedSchema && !existingValue.equals(value)) {
            Collection<IndexBackedConstraintDescriptor> uniquenessConstraints = this.indexingService.getRelatedUniquenessConstraints(labels, propertyKey, EntityType.NODE);
            NodeSchemaMatcher.onMatchingSchema(uniquenessConstraints.iterator(), propertyKey, existingPropertyKeyIds, uniquenessConstraint -> this.validateNoExistingNodeWithExactValues((IndexBackedConstraintDescriptor)uniquenessConstraint, this.getAllPropertyValues((SchemaDescriptor)uniquenessConstraint.schema(), propertyKey, value), node));
        }
        if (existingValue == Values.NO_VALUE) {
            this.autoIndexing.nodes().propertyAdded(this, node, propertyKey, value);
            this.ktx.txState().nodeDoAddProperty(node, propertyKey, value);
            if (hasRelatedSchema) {
                this.updater.onPropertyAdd(this.nodeCursor, this.propertyCursor, labels, propertyKey, existingPropertyKeyIds, value);
            }
            return Values.NO_VALUE;
        }
        this.autoIndexing.nodes().propertyChanged(this, node, propertyKey, existingValue, value);
        if (Operations.propertyHasChanged(value, existingValue)) {
            this.ktx.txState().nodeDoChangeProperty(node, propertyKey, value);
            if (hasRelatedSchema) {
                this.updater.onPropertyChange(this.nodeCursor, this.propertyCursor, labels, propertyKey, existingPropertyKeyIds, existingValue, value);
            }
        }
        return existingValue;
    }

    public Value nodeRemoveProperty(long node, int propertyKey) throws EntityNotFoundException, AutoIndexingKernelException {
        this.acquireExclusiveNodeLock(node);
        this.ktx.assertOpen();
        this.singleNode(node);
        Value existingValue = this.readNodeProperty(propertyKey);
        if (existingValue != Values.NO_VALUE) {
            long[] labels = this.acquireSharedNodeLabelLocks();
            this.autoIndexing.nodes().propertyRemoved(this, node, propertyKey);
            this.ktx.txState().nodeDoRemoveProperty(node, propertyKey);
            if (this.indexingService.hasRelatedSchema(labels, propertyKey, EntityType.NODE)) {
                this.updater.onPropertyRemove(this.nodeCursor, this.propertyCursor, labels, propertyKey, this.loadSortedPropertyKeyList(), existingValue);
            }
        }
        return existingValue;
    }

    public Value relationshipSetProperty(long relationship, int propertyKey, Value value) throws EntityNotFoundException, AutoIndexingKernelException {
        this.acquireExclusiveRelationshipLock(relationship);
        this.ktx.assertOpen();
        this.singleRelationship(relationship);
        Value existingValue = this.readRelationshipProperty(propertyKey);
        if (existingValue == Values.NO_VALUE) {
            this.autoIndexing.relationships().propertyAdded(this, relationship, propertyKey, value);
            this.ktx.txState().relationshipDoReplaceProperty(relationship, propertyKey, Values.NO_VALUE, value);
            return Values.NO_VALUE;
        }
        this.autoIndexing.relationships().propertyChanged(this, relationship, propertyKey, existingValue, value);
        if (Operations.propertyHasChanged(existingValue, value)) {
            this.ktx.txState().relationshipDoReplaceProperty(relationship, propertyKey, existingValue, value);
        }
        return existingValue;
    }

    public Value relationshipRemoveProperty(long relationship, int propertyKey) throws EntityNotFoundException, AutoIndexingKernelException {
        this.acquireExclusiveRelationshipLock(relationship);
        this.ktx.assertOpen();
        this.singleRelationship(relationship);
        Value existingValue = this.readRelationshipProperty(propertyKey);
        if (existingValue != Values.NO_VALUE) {
            this.autoIndexing.relationships().propertyRemoved(this, relationship, propertyKey);
            this.ktx.txState().relationshipDoRemoveProperty(relationship, propertyKey);
        }
        return existingValue;
    }

    public Value graphSetProperty(int propertyKey, Value value) {
        this.ktx.statementLocks().optimistic().acquireExclusive(this.ktx.lockTracer(), ResourceTypes.GRAPH_PROPS, ResourceTypes.graphPropertyResource());
        this.ktx.assertOpen();
        Value existingValue = this.readGraphProperty(propertyKey);
        if (!existingValue.equals(value)) {
            this.ktx.txState().graphDoReplaceProperty(propertyKey, existingValue, value);
        }
        return existingValue;
    }

    public Value graphRemoveProperty(int propertyKey) {
        this.ktx.statementLocks().optimistic().acquireExclusive(this.ktx.lockTracer(), ResourceTypes.GRAPH_PROPS, ResourceTypes.graphPropertyResource());
        this.ktx.assertOpen();
        Value existingValue = this.readGraphProperty(propertyKey);
        if (existingValue != Values.NO_VALUE) {
            this.ktx.txState().graphDoRemoveProperty(propertyKey);
        }
        return existingValue;
    }

    public void nodeAddToExplicitIndex(String indexName, long node, String key, Object value) throws ExplicitIndexNotFoundKernelException {
        this.ktx.assertOpen();
        this.allStoreHolder.explicitIndexTxState().nodeChanges(indexName).addNode(node, key, value);
    }

    public void nodeRemoveFromExplicitIndex(String indexName, long node) throws ExplicitIndexNotFoundKernelException {
        this.ktx.assertOpen();
        this.allStoreHolder.explicitIndexTxState().nodeChanges(indexName).remove(node);
    }

    public void nodeRemoveFromExplicitIndex(String indexName, long node, String key, Object value) throws ExplicitIndexNotFoundKernelException {
        this.ktx.assertOpen();
        this.allStoreHolder.explicitIndexTxState().nodeChanges(indexName).remove(node, key, value);
    }

    public void nodeRemoveFromExplicitIndex(String indexName, long node, String key) throws ExplicitIndexNotFoundKernelException {
        this.ktx.assertOpen();
        this.allStoreHolder.explicitIndexTxState().nodeChanges(indexName).remove(node, key);
    }

    public void nodeExplicitIndexCreate(String indexName, Map<String, String> customConfig) {
        this.ktx.assertOpen();
        this.allStoreHolder.explicitIndexTxState().createIndex(IndexEntityType.Node, indexName, customConfig);
    }

    public void nodeExplicitIndexCreateLazily(String indexName, Map<String, String> customConfig) {
        this.ktx.assertOpen();
        this.allStoreHolder.getOrCreateNodeIndexConfig(indexName, customConfig);
    }

    public void nodeExplicitIndexDrop(String indexName) throws ExplicitIndexNotFoundKernelException {
        this.ktx.assertOpen();
        ExplicitIndexTransactionState txState = this.allStoreHolder.explicitIndexTxState();
        txState.nodeChanges(indexName).drop();
        txState.deleteIndex(IndexEntityType.Node, indexName);
    }

    public String nodeExplicitIndexSetConfiguration(String indexName, String key, String value) throws ExplicitIndexNotFoundKernelException {
        this.ktx.assertOpen();
        return this.allStoreHolder.explicitIndexStore().setNodeIndexConfiguration(indexName, key, value);
    }

    public String nodeExplicitIndexRemoveConfiguration(String indexName, String key) throws ExplicitIndexNotFoundKernelException {
        this.ktx.assertOpen();
        return this.allStoreHolder.explicitIndexStore().removeNodeIndexConfiguration(indexName, key);
    }

    public void relationshipAddToExplicitIndex(String indexName, long relationship, String key, Object value) throws ExplicitIndexNotFoundKernelException, EntityNotFoundException {
        this.ktx.assertOpen();
        this.allStoreHolder.singleRelationship(relationship, this.relationshipCursor);
        if (!this.relationshipCursor.next()) {
            throw new EntityNotFoundException(EntityType.RELATIONSHIP, relationship);
        }
        this.allStoreHolder.explicitIndexTxState().relationshipChanges(indexName).addRelationship(relationship, key, value, this.relationshipCursor.sourceNodeReference(), this.relationshipCursor.targetNodeReference());
    }

    public void relationshipRemoveFromExplicitIndex(String indexName, long relationship, String key, Object value) throws ExplicitIndexNotFoundKernelException {
        this.ktx.assertOpen();
        this.allStoreHolder.explicitIndexTxState().relationshipChanges(indexName).remove(relationship, key, value);
    }

    public void relationshipRemoveFromExplicitIndex(String indexName, long relationship, String key) throws ExplicitIndexNotFoundKernelException {
        this.ktx.assertOpen();
        this.allStoreHolder.explicitIndexTxState().relationshipChanges(indexName).remove(relationship, key);
    }

    public void relationshipRemoveFromExplicitIndex(String indexName, long relationship) throws ExplicitIndexNotFoundKernelException {
        this.ktx.assertOpen();
        this.allStoreHolder.explicitIndexTxState().relationshipChanges(indexName).remove(relationship);
    }

    public void relationshipExplicitIndexCreate(String indexName, Map<String, String> customConfig) {
        this.ktx.assertOpen();
        this.allStoreHolder.explicitIndexTxState().createIndex(IndexEntityType.Relationship, indexName, customConfig);
    }

    public void relationshipExplicitIndexCreateLazily(String indexName, Map<String, String> customConfig) {
        this.ktx.assertOpen();
        this.allStoreHolder.getOrCreateRelationshipIndexConfig(indexName, customConfig);
    }

    public void relationshipExplicitIndexDrop(String indexName) throws ExplicitIndexNotFoundKernelException {
        this.ktx.assertOpen();
        ExplicitIndexTransactionState txState = this.allStoreHolder.explicitIndexTxState();
        txState.relationshipChanges(indexName).drop();
        txState.deleteIndex(IndexEntityType.Relationship, indexName);
    }

    private Value readNodeProperty(int propertyKey) {
        this.nodeCursor.properties(this.propertyCursor);
        Value existingValue = Values.NO_VALUE;
        while (this.propertyCursor.next()) {
            if (this.propertyCursor.propertyKey() != propertyKey) continue;
            existingValue = this.propertyCursor.propertyValue();
            break;
        }
        return existingValue;
    }

    private Value readRelationshipProperty(int propertyKey) {
        this.relationshipCursor.properties(this.propertyCursor);
        Value existingValue = Values.NO_VALUE;
        while (this.propertyCursor.next()) {
            if (this.propertyCursor.propertyKey() != propertyKey) continue;
            existingValue = this.propertyCursor.propertyValue();
            break;
        }
        return existingValue;
    }

    private Value readGraphProperty(int propertyKey) {
        this.allStoreHolder.graphProperties(this.propertyCursor);
        Value existingValue = Values.NO_VALUE;
        while (this.propertyCursor.next()) {
            if (this.propertyCursor.propertyKey() != propertyKey) continue;
            existingValue = this.propertyCursor.propertyValue();
            break;
        }
        return existingValue;
    }

    public CursorFactory cursors() {
        return this.cursors;
    }

    public Procedures procedures() {
        return this.allStoreHolder;
    }

    public void release() {
        if (this.nodeCursor != null) {
            this.nodeCursor.close();
            this.nodeCursor = null;
        }
        if (this.propertyCursor != null) {
            this.propertyCursor.close();
            this.propertyCursor = null;
        }
        if (this.relationshipCursor != null) {
            this.relationshipCursor.close();
            this.relationshipCursor = null;
        }
        this.cursors.assertClosed();
        this.cursors.release();
    }

    public Token token() {
        return this.token;
    }

    public ExplicitIndexRead indexRead() {
        return this.allStoreHolder;
    }

    public SchemaRead schemaRead() {
        return this.allStoreHolder;
    }

    public Read dataRead() {
        return this.allStoreHolder;
    }

    public DefaultNodeCursor nodeCursor() {
        return this.nodeCursor;
    }

    public DefaultRelationshipScanCursor relationshipCursor() {
        return this.relationshipCursor;
    }

    public DefaultPropertyCursor propertyCursor() {
        return this.propertyCursor;
    }

    public IndexReference indexCreate(SchemaDescriptor descriptor) throws SchemaKernelException {
        return this.indexCreate(descriptor, this.config.get(GraphDatabaseSettings.default_schema_provider), Optional.empty());
    }

    public IndexReference indexCreate(SchemaDescriptor descriptor, Optional<String> indexName) throws SchemaKernelException {
        return this.indexCreate(descriptor, this.config.get(GraphDatabaseSettings.default_schema_provider), indexName);
    }

    public IndexReference indexCreate(SchemaDescriptor descriptor, String provider, Optional<String> name) throws SchemaKernelException {
        this.exclusiveSchemaLock(descriptor);
        this.ktx.assertOpen();
        Operations.assertValidDescriptor(descriptor, SchemaKernelException.OperationContext.INDEX_CREATION);
        this.assertIndexDoesNotExist(SchemaKernelException.OperationContext.INDEX_CREATION, descriptor, name);
        IndexProviderDescriptor providerDescriptor = this.indexingService.indexProviderByName(provider);
        IndexDescriptor index = IndexDescriptorFactory.forSchema((SchemaDescriptor)descriptor, name, (IndexProviderDescriptor)providerDescriptor);
        index = this.indexingService.getBlessedDescriptorFromProvider(index);
        this.ktx.txState().indexDoAdd(index);
        return index;
    }

    public IndexDescriptor indexUniqueCreate(SchemaDescriptor schema, String provider) throws SchemaKernelException {
        IndexProviderDescriptor providerDescriptor = this.indexingService.indexProviderByName(provider);
        IndexDescriptor index = IndexDescriptorFactory.uniqueForSchema((SchemaDescriptor)schema, Optional.empty(), (IndexProviderDescriptor)providerDescriptor);
        index = this.indexingService.getBlessedDescriptorFromProvider(index);
        this.ktx.txState().indexDoAdd(index);
        return index;
    }

    public void indexDrop(IndexReference indexReference) throws SchemaKernelException {
        Operations.assertValidIndex(indexReference);
        IndexDescriptor index = (IndexDescriptor)indexReference;
        SchemaDescriptor schema = index.schema();
        this.exclusiveSchemaLock(schema);
        this.ktx.assertOpen();
        try {
            IndexDescriptor existingIndex = this.allStoreHolder.indexGetForSchema(schema);
            if (existingIndex == null) {
                throw new NoSuchIndexException(schema);
            }
            if (existingIndex.type() == IndexDescriptor.Type.UNIQUE && this.allStoreHolder.indexGetOwningUniquenessConstraintId(existingIndex) != null) {
                throw new IndexBelongsToConstraintException(schema);
            }
        }
        catch (IndexBelongsToConstraintException | NoSuchIndexException e) {
            throw new DropIndexFailureException(schema, e);
        }
        this.ktx.txState().indexDoDrop(index);
    }

    public org.neo4j.internal.kernel.api.schema.constraints.ConstraintDescriptor uniquePropertyConstraintCreate(SchemaDescriptor descriptor) throws SchemaKernelException {
        return this.uniquePropertyConstraintCreate(descriptor, this.config.get(GraphDatabaseSettings.default_schema_provider));
    }

    public org.neo4j.internal.kernel.api.schema.constraints.ConstraintDescriptor uniquePropertyConstraintCreate(SchemaDescriptor descriptor, String provider) throws SchemaKernelException {
        UniquenessConstraintDescriptor constraint;
        this.exclusiveSchemaLock(descriptor);
        this.ktx.assertOpen();
        try {
            Operations.assertValidDescriptor(descriptor, SchemaKernelException.OperationContext.CONSTRAINT_CREATION);
            constraint = ConstraintDescriptorFactory.uniqueForSchema(descriptor);
            this.assertConstraintDoesNotExist(constraint);
            this.assertIndexDoesNotExist(SchemaKernelException.OperationContext.CONSTRAINT_CREATION, descriptor, Optional.empty());
        }
        catch (SchemaKernelException e) {
            this.exclusiveSchemaUnlock(descriptor);
            throw e;
        }
        this.indexBackedConstraintCreate(constraint, provider);
        return constraint;
    }

    public org.neo4j.internal.kernel.api.schema.constraints.ConstraintDescriptor nodeKeyConstraintCreate(LabelSchemaDescriptor descriptor) throws SchemaKernelException {
        return this.nodeKeyConstraintCreate(descriptor, this.config.get(GraphDatabaseSettings.default_schema_provider));
    }

    public org.neo4j.internal.kernel.api.schema.constraints.ConstraintDescriptor nodeKeyConstraintCreate(LabelSchemaDescriptor descriptor, String provider) throws SchemaKernelException {
        NodeKeyConstraintDescriptor constraint;
        this.exclusiveSchemaLock((SchemaDescriptor)descriptor);
        this.ktx.assertOpen();
        try {
            Operations.assertValidDescriptor((SchemaDescriptor)descriptor, SchemaKernelException.OperationContext.CONSTRAINT_CREATION);
            constraint = ConstraintDescriptorFactory.nodeKeyForSchema((SchemaDescriptor)descriptor);
            this.assertConstraintDoesNotExist(constraint);
            this.assertIndexDoesNotExist(SchemaKernelException.OperationContext.CONSTRAINT_CREATION, (SchemaDescriptor)descriptor, Optional.empty());
        }
        catch (SchemaKernelException e) {
            this.exclusiveSchemaUnlock((SchemaDescriptor)descriptor);
            throw e;
        }
        try (DefaultNodeLabelIndexCursor nodes = this.cursors.allocateNodeLabelIndexCursor();){
            this.allStoreHolder.nodeLabelScan(descriptor.getLabelId(), nodes);
            this.constraintSemantics.validateNodeKeyConstraint(nodes, this.nodeCursor, this.propertyCursor, descriptor);
        }
        this.indexBackedConstraintCreate(constraint, provider);
        return constraint;
    }

    public org.neo4j.internal.kernel.api.schema.constraints.ConstraintDescriptor nodePropertyExistenceConstraintCreate(LabelSchemaDescriptor descriptor) throws SchemaKernelException {
        org.neo4j.internal.kernel.api.schema.constraints.ConstraintDescriptor constraint = this.lockAndValidatePropertyExistenceConstraint((SchemaDescriptor)descriptor);
        try (DefaultNodeLabelIndexCursor nodes = this.cursors.allocateNodeLabelIndexCursor();){
            this.allStoreHolder.nodeLabelScan(descriptor.getLabelId(), nodes);
            this.constraintSemantics.validateNodePropertyExistenceConstraint(nodes, this.nodeCursor, this.propertyCursor, descriptor);
        }
        this.ktx.txState().constraintDoAdd(constraint);
        return constraint;
    }

    public org.neo4j.internal.kernel.api.schema.constraints.ConstraintDescriptor relationshipPropertyExistenceConstraintCreate(RelationTypeSchemaDescriptor descriptor) throws SchemaKernelException {
        org.neo4j.internal.kernel.api.schema.constraints.ConstraintDescriptor constraint = this.lockAndValidatePropertyExistenceConstraint((SchemaDescriptor)descriptor);
        this.allStoreHolder.relationshipTypeScan(descriptor.getRelTypeId(), this.relationshipCursor);
        this.constraintSemantics.validateRelationshipPropertyExistenceConstraint(this.relationshipCursor, this.propertyCursor, descriptor);
        this.ktx.txState().constraintDoAdd(constraint);
        return constraint;
    }

    private org.neo4j.internal.kernel.api.schema.constraints.ConstraintDescriptor lockAndValidatePropertyExistenceConstraint(SchemaDescriptor descriptor) throws SchemaKernelException {
        this.exclusiveSchemaLock(descriptor);
        this.ktx.assertOpen();
        try {
            Operations.assertValidDescriptor(descriptor, SchemaKernelException.OperationContext.CONSTRAINT_CREATION);
            ConstraintDescriptor constraint = ConstraintDescriptorFactory.existsForSchema(descriptor);
            this.assertConstraintDoesNotExist(constraint);
            return constraint;
        }
        catch (SchemaKernelException e) {
            this.exclusiveSchemaUnlock(descriptor);
            throw e;
        }
    }

    public String relationshipExplicitIndexSetConfiguration(String indexName, String key, String value) throws ExplicitIndexNotFoundKernelException {
        this.ktx.assertOpen();
        return this.allStoreHolder.explicitIndexStore().setRelationshipIndexConfiguration(indexName, key, value);
    }

    public String relationshipExplicitIndexRemoveConfiguration(String indexName, String key) throws ExplicitIndexNotFoundKernelException {
        this.ktx.assertOpen();
        return this.allStoreHolder.explicitIndexStore().removeRelationshipIndexConfiguration(indexName, key);
    }

    public void constraintDrop(org.neo4j.internal.kernel.api.schema.constraints.ConstraintDescriptor descriptor) throws SchemaKernelException {
        SchemaDescriptor schema = descriptor.schema();
        this.exclusiveOptimisticLock(schema.keyType(), schema.keyId());
        this.ktx.assertOpen();
        try {
            this.assertConstraintExists(descriptor);
        }
        catch (NoSuchConstraintException e) {
            throw new DropConstraintFailureException(descriptor, (Throwable)((Object)e));
        }
        this.ktx.txState().constraintDoDrop(descriptor);
    }

    private void assertIndexDoesNotExist(SchemaKernelException.OperationContext context, SchemaDescriptor descriptor, Optional<String> name) throws AlreadyIndexedException, AlreadyConstrainedException {
        IndexReference indexReference;
        IndexDescriptor existingIndex = this.allStoreHolder.indexGetForSchema(descriptor);
        if (existingIndex == null && name.isPresent() && (indexReference = this.allStoreHolder.indexGetForName(name.get())) != IndexReference.NO_INDEX) {
            existingIndex = (IndexDescriptor)indexReference;
        }
        if (existingIndex != null) {
            if (existingIndex.type() == IndexDescriptor.Type.UNIQUE) {
                if (context != SchemaKernelException.OperationContext.CONSTRAINT_CREATION || this.constraintIndexHasOwner(existingIndex)) {
                    throw new AlreadyConstrainedException(ConstraintDescriptorFactory.uniqueForSchema(descriptor), context, new SilentTokenNameLookup((TokenRead)this.token));
                }
            } else {
                throw new AlreadyIndexedException(descriptor, context);
            }
        }
    }

    private void exclusiveOptimisticLock(ResourceType resource, long resourceId) {
        this.ktx.statementLocks().optimistic().acquireExclusive(this.ktx.lockTracer(), resource, resourceId);
    }

    private void acquireExclusiveNodeLock(long node) {
        if (!this.ktx.hasTxStateWithChanges() || !this.ktx.txState().nodeIsAddedInThisTx(node)) {
            this.ktx.statementLocks().optimistic().acquireExclusive(this.ktx.lockTracer(), ResourceTypes.NODE, node);
        }
    }

    private void acquireExclusiveRelationshipLock(long relationshipId) {
        if (!this.ktx.hasTxStateWithChanges() || !this.ktx.txState().relationshipIsAddedInThisTx(relationshipId)) {
            this.ktx.statementLocks().optimistic().acquireExclusive(this.ktx.lockTracer(), ResourceTypes.RELATIONSHIP, relationshipId);
        }
    }

    private void sharedSchemaLock(ResourceType type, int tokenId) {
        this.ktx.statementLocks().optimistic().acquireShared(this.ktx.lockTracer(), type, tokenId);
    }

    private void exclusiveSchemaLock(SchemaDescriptor schema) {
        long[] lockingIds = SchemaDescriptor.schemaTokenLockingIds((SchemaDescriptor)schema);
        this.ktx.statementLocks().optimistic().acquireExclusive(this.ktx.lockTracer(), schema.keyType(), lockingIds);
    }

    private void exclusiveSchemaUnlock(SchemaDescriptor schema) {
        long[] lockingIds = SchemaDescriptor.schemaTokenLockingIds((SchemaDescriptor)schema);
        this.ktx.statementLocks().optimistic().releaseExclusive(schema.keyType(), lockingIds);
    }

    private void lockRelationshipNodes(long startNodeId, long endNodeId) {
        this.acquireExclusiveNodeLock(Math.min(startNodeId, endNodeId));
        if (startNodeId != endNodeId) {
            this.acquireExclusiveNodeLock(Math.max(startNodeId, endNodeId));
        }
    }

    private static boolean propertyHasChanged(Value lhs, Value rhs) {
        return lhs.getClass() != rhs.getClass() || !lhs.equals(rhs);
    }

    private void assertNodeExists(long sourceNode) throws EntityNotFoundException {
        if (!this.allStoreHolder.nodeExists(sourceNode)) {
            throw new EntityNotFoundException(EntityType.NODE, sourceNode);
        }
    }

    private boolean constraintIndexHasOwner(IndexDescriptor descriptor) {
        return this.allStoreHolder.indexGetOwningUniquenessConstraintId(descriptor) != null;
    }

    private void assertConstraintDoesNotExist(org.neo4j.internal.kernel.api.schema.constraints.ConstraintDescriptor constraint) throws AlreadyConstrainedException {
        if (this.allStoreHolder.constraintExists(constraint)) {
            throw new AlreadyConstrainedException(constraint, SchemaKernelException.OperationContext.CONSTRAINT_CREATION, new SilentTokenNameLookup((TokenRead)this.token));
        }
    }

    public Locks locks() {
        return this.allStoreHolder;
    }

    private void assertConstraintExists(org.neo4j.internal.kernel.api.schema.constraints.ConstraintDescriptor constraint) throws NoSuchConstraintException {
        if (!this.allStoreHolder.constraintExists(constraint)) {
            throw new NoSuchConstraintException(constraint);
        }
    }

    private static void assertValidDescriptor(SchemaDescriptor descriptor, SchemaKernelException.OperationContext context) throws RepeatedSchemaComponentException {
        long numUniqueProp = Arrays.stream(descriptor.getPropertyIds()).distinct().count();
        long numUniqueEntityTokens = Arrays.stream(descriptor.getEntityTokenIds()).distinct().count();
        if (numUniqueProp != (long)descriptor.getPropertyIds().length) {
            throw new RepeatedPropertyInSchemaException(descriptor, context);
        }
        if (numUniqueEntityTokens != (long)descriptor.getEntityTokenIds().length) {
            if (descriptor.entityType() == EntityType.NODE) {
                throw new RepeatedLabelInSchemaException(descriptor, context);
            }
            throw new RepeatedRelationshipTypeInSchemaException(descriptor, context);
        }
    }

    private void indexBackedConstraintCreate(IndexBackedConstraintDescriptor constraint, String provider) throws CreateConstraintFailureException {
        LabelSchemaDescriptor descriptor = constraint.schema();
        try {
            if (this.ktx.hasTxStateWithChanges() && this.ktx.txState().indexDoUnRemove(constraint.ownedIndexDescriptor())) {
                if (!this.ktx.txState().constraintDoUnRemove(constraint)) {
                    this.ktx.txState().constraintDoAdd(constraint, this.ktx.txState().indexCreatedForConstraint(constraint));
                }
            } else {
                Iterator<org.neo4j.internal.kernel.api.schema.constraints.ConstraintDescriptor> it = this.allStoreHolder.constraintsGetForSchema((SchemaDescriptor)descriptor);
                while (it.hasNext()) {
                    if (!it.next().equals(constraint)) continue;
                    return;
                }
                long indexId = this.constraintIndexCreator.createUniquenessConstraintIndex(this.ktx, (SchemaDescriptor)descriptor, provider);
                if (!this.allStoreHolder.constraintExists(constraint)) {
                    this.ktx.txState().constraintDoAdd(constraint, indexId);
                }
            }
        }
        catch (TransactionFailureException | AlreadyConstrainedException | UniquePropertyValueValidationException e) {
            throw new CreateConstraintFailureException((org.neo4j.internal.kernel.api.schema.constraints.ConstraintDescriptor)constraint, (Throwable)e);
        }
    }

    private static void assertValidIndex(IndexReference index) throws NoSuchIndexException {
        if (index == IndexReference.NO_INDEX) {
            throw new NoSuchIndexException(index.schema());
        }
    }
}

