/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.unsafe.impl.batchimport.cache.LongArray;
import org.neo4j.unsafe.impl.batchimport.cache.PageCacheNumberArray;

public class PageCacheLongArray
extends PageCacheNumberArray<LongArray>
implements LongArray {
    PageCacheLongArray(PagedFile pagedFile, long length, long defaultValue, long base) throws IOException {
        super(pagedFile, 8, length, defaultValue, base);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long get(long index) {
        long pageId = this.pageId(index);
        int offset = this.offset(index);
        try (PageCursor cursor = this.pagedFile.io(pageId, 1);){
            long result;
            cursor.next();
            do {
                result = cursor.getLong(offset);
            } while (cursor.shouldRetry());
            this.checkBounds(cursor);
            long l = result;
            return l;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void set(long index, long value) {
        long pageId = this.pageId(index);
        int offset = this.offset(index);
        try (PageCursor cursor = this.pagedFile.io(pageId, 6);){
            cursor.next();
            cursor.putLong(offset, value);
            this.checkBounds(cursor);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

