/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.diagnostics.providers;

import java.util.Collection;
import org.neo4j.collection.Dependencies;
import org.neo4j.configuration.Config;
import org.neo4j.dbms.database.DatabaseContext;
import org.neo4j.dbms.database.DatabaseManager;
import org.neo4j.internal.diagnostics.DiagnosticsManager;
import org.neo4j.internal.diagnostics.DiagnosticsProvider;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.database.Database;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.diagnostics.providers.ConfigDiagnostics;
import org.neo4j.kernel.diagnostics.providers.StoreFilesDiagnostics;
import org.neo4j.kernel.diagnostics.providers.SystemDiagnostics;
import org.neo4j.kernel.diagnostics.providers.TransactionRangeDiagnostics;
import org.neo4j.kernel.diagnostics.providers.VersionDiagnostics;
import org.neo4j.kernel.impl.factory.DatabaseInfo;
import org.neo4j.logging.Log;
import org.neo4j.logging.internal.LogService;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.util.FeatureToggles;

public class DbmsDiagnosticsManager {
    private static final int CONCISE_DATABASE_DUMP_THRESHOLD = FeatureToggles.getInteger(DbmsDiagnosticsManager.class, (String)"conciseDumpThreshold", (int)10);
    private final Dependencies dependencies;
    private final DiagnosticsManager diagnosticsManager;
    private final Log log;

    public DbmsDiagnosticsManager(Dependencies dependencies, LogService logService) {
        this.log = logService.getInternalLog(DiagnosticsManager.class);
        this.dependencies = dependencies;
        this.diagnosticsManager = new DiagnosticsManager(this.log);
    }

    public void dumpSystemDiagnostics() {
        this.dumpSystemDiagnostics(this.log);
    }

    public void dumpDatabaseDiagnostics(Database database) {
        this.dumpDatabaseDiagnostics(database, this.log, false);
    }

    public void dumpAll() {
        this.dumpAll(this.log);
    }

    public void dumpAll(Log log) {
        this.dumpSystemDiagnostics(log);
        this.dumpAllDatabases(log);
    }

    public void dump(NamedDatabaseId namedDatabaseId) {
        this.dump(namedDatabaseId, this.log);
    }

    public void dump(NamedDatabaseId namedDatabaseId, Log log) {
        this.getDatabaseManager().getDatabaseContext(namedDatabaseId).map(DatabaseContext::database).ifPresent(database -> this.dumpDatabaseDiagnostics((Database)((Object)database), log, true));
    }

    private void dumpAllDatabases(Log log) {
        Collection<?> values = this.getDatabaseManager().registeredDatabases().values();
        if (values.size() > CONCISE_DATABASE_DUMP_THRESHOLD) {
            values.forEach(context -> this.dumpConciseDiagnostics(context.database(), log));
        } else {
            values.forEach(dbCtx -> this.dumpDatabaseDiagnostics(dbCtx.database(), log, true));
        }
    }

    private void dumpConciseDiagnostics(Database database, Log log) {
        this.dumpDatabaseSectionName(database, log);
        DbmsDiagnosticsManager.logDatabaseStatus(database, log);
    }

    private void dumpSystemDiagnostics(Log log) {
        this.diagnosticsManager.section(log, "System diagnostics");
        this.diagnosticsManager.dump(SystemDiagnostics.class, log);
        this.diagnosticsManager.dump((DiagnosticsProvider)new ConfigDiagnostics((Config)this.dependencies.resolveDependency(Config.class)), log);
        this.dependencies.resolveTypeDependencies(DiagnosticsProvider.class).forEach(provider -> this.diagnosticsManager.dump(provider, log));
    }

    private void dumpDatabaseDiagnostics(Database database, Log log, boolean checkStatus) {
        this.dumpDatabaseSectionName(database, log);
        if (checkStatus) {
            DbmsDiagnosticsManager.logDatabaseStatus(database, log);
            if (!database.isStarted()) {
                return;
            }
        }
        Dependencies databaseResolver = database.getDependencyResolver();
        DatabaseInfo databaseInfo = (DatabaseInfo)((Object)databaseResolver.resolveDependency(DatabaseInfo.class));
        FileSystemAbstraction fs = (FileSystemAbstraction)databaseResolver.resolveDependency(FileSystemAbstraction.class);
        StorageEngineFactory storageEngineFactory = (StorageEngineFactory)databaseResolver.resolveDependency(StorageEngineFactory.class);
        StorageEngine storageEngine = (StorageEngine)databaseResolver.resolveDependency(StorageEngine.class);
        this.diagnosticsManager.dump((DiagnosticsProvider)new VersionDiagnostics(databaseInfo, database.getStoreId()), log);
        this.diagnosticsManager.dump((DiagnosticsProvider)new StoreFilesDiagnostics(storageEngineFactory, fs, database.getDatabaseLayout()), log);
        this.diagnosticsManager.dump((DiagnosticsProvider)new TransactionRangeDiagnostics(database), log);
        storageEngine.dumpDiagnostics(this.diagnosticsManager, log);
    }

    private static void logDatabaseStatus(Database database, Log log) {
        log.info("Database is %s.", new Object[]{database.isStarted() ? "started" : "stopped"});
    }

    private void dumpDatabaseSectionName(Database database, Log log) {
        this.diagnosticsManager.section(log, "Database: " + database.getNamedDatabaseId().name());
    }

    private DatabaseManager<?> getDatabaseManager() {
        return (DatabaseManager)this.dependencies.resolveDependency(DatabaseManager.class);
    }
}

