/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.neo4j.exceptions.KernelException;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.helpers.RelationshipSelectionCursor;
import org.neo4j.internal.kernel.api.helpers.RelationshipSelections;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.lock.LockTracer;
import org.neo4j.lock.ResourceType;
import org.neo4j.lock.ResourceTypes;

class TwoPhaseNodeForRelationshipLocking {
    private final ThrowingConsumer<Long, KernelException> relIdAction;
    private long firstRelId;
    private long[] sortedNodeIds;
    private static final long[] EMPTY = new long[0];
    private final Locks.Client locks;
    private final LockTracer lockTracer;

    TwoPhaseNodeForRelationshipLocking(ThrowingConsumer<Long, KernelException> relIdAction, Locks.Client locks, LockTracer lockTracer) {
        this.relIdAction = relIdAction;
        this.locks = locks;
        this.lockTracer = lockTracer;
    }

    void lockAllNodesAndConsumeRelationships(long nodeId, KernelTransaction transaction, NodeCursor nodes) throws KernelException {
        boolean retry;
        do {
            retry = false;
            this.firstRelId = -1L;
            this.collectAndSortNodeIds(nodeId, transaction, nodes);
            this.lockAllNodes(this.sortedNodeIds);
            Read read = transaction.dataRead();
            read.singleNode(nodeId, nodes);
            if (!nodes.next()) continue;
            try (RelationshipSelectionCursor rels = RelationshipSelections.allCursor((CursorFactory)transaction.cursors(), (NodeCursor)nodes, null);){
                boolean first = true;
                while (rels.next() && !retry) {
                    retry = this.performAction(rels.relationshipReference(), first);
                    first = false;
                }
            }
        } while (retry);
    }

    private void collectAndSortNodeIds(long nodeId, KernelTransaction transaction, NodeCursor nodes) {
        LongHashSet nodeIdSet = new LongHashSet();
        nodeIdSet.add(nodeId);
        Read read = transaction.dataRead();
        read.singleNode(nodeId, nodes);
        if (!nodes.next()) {
            this.sortedNodeIds = EMPTY;
            return;
        }
        try (RelationshipSelectionCursor rels = RelationshipSelections.allCursor((CursorFactory)transaction.cursors(), (NodeCursor)nodes, null);){
            while (rels.next()) {
                if (this.firstRelId == -1L) {
                    this.firstRelId = rels.relationshipReference();
                }
                nodeIdSet.add(rels.sourceNodeReference());
                nodeIdSet.add(rels.targetNodeReference());
            }
        }
        this.sortedNodeIds = nodeIdSet.toSortedArray();
    }

    private void lockAllNodes(long[] nodeIds) {
        this.locks.acquireExclusive(this.lockTracer, (ResourceType)ResourceTypes.NODE, nodeIds);
    }

    private void unlockAllNodes(long[] nodeIds) {
        this.locks.releaseExclusive((ResourceType)ResourceTypes.NODE, nodeIds);
    }

    private boolean performAction(long rel, boolean first) throws KernelException {
        if (first && rel != this.firstRelId) {
            this.unlockAllNodes(this.sortedNodeIds);
            this.sortedNodeIds = null;
            return true;
        }
        this.relIdAction.accept((Object)rel);
        return false;
    }
}

