/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.IntPredicate;
import java.util.stream.IntStream;
import org.eclipse.collections.impl.utility.ArrayIterate;
import org.neo4j.common.EntityType;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.internal.helpers.collection.Pair;
import org.neo4j.internal.helpers.collection.Visitor;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.PopulationProgress;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.internal.schema.SchemaState;
import org.neo4j.kernel.api.exceptions.index.FlipFailedKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.exceptions.index.IndexPopulationFailedKernelException;
import org.neo4j.kernel.api.index.IndexDropper;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexSample;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.api.index.BatchingMultipleIndexPopulator;
import org.neo4j.kernel.impl.api.index.FailedIndexProxy;
import org.neo4j.kernel.impl.api.index.FailedIndexProxyFactory;
import org.neo4j.kernel.impl.api.index.FlippableIndexProxy;
import org.neo4j.kernel.impl.api.index.IndexPopulationFailure;
import org.neo4j.kernel.impl.api.index.IndexPopulationJob;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.LoggingPhaseTracker;
import org.neo4j.kernel.impl.api.index.PhaseTracker;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.storageengine.api.EntityUpdates;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.NodePropertyAccessor;
import org.neo4j.util.FeatureToggles;

public class MultipleIndexPopulator
implements IndexPopulator {
    public static final String QUEUE_THRESHOLD_NAME = "queue_threshold";
    public static final String BATCH_SIZE_NAME = "batch_size";
    final int QUEUE_THRESHOLD = FeatureToggles.getInteger(this.getClass(), (String)"queue_threshold", (int)20000);
    final int BATCH_SIZE_SCAN = FeatureToggles.getInteger(BatchingMultipleIndexPopulator.class, (String)"batch_size", (int)10000);
    final boolean PRINT_DEBUG = FeatureToggles.flag(MultipleIndexPopulator.class, (String)"print_debug", (boolean)false);
    final Queue<IndexEntryUpdate<?>> concurrentUpdateQueue = new LinkedBlockingQueue();
    final List<IndexPopulation> populations = new CopyOnWriteArrayList<IndexPopulation>();
    private final IndexStoreView storeView;
    private final NodePropertyAccessor propertyAccessor;
    private final LogProvider logProvider;
    protected final Log log;
    private final EntityType type;
    private final SchemaState schemaState;
    private final IndexStatisticsStore indexStatisticsStore;
    private final PhaseTracker phaseTracker;
    private StoreScan<IndexPopulationFailedKernelException> storeScan;

    public MultipleIndexPopulator(IndexStoreView storeView, LogProvider logProvider, EntityType type, SchemaState schemaState, IndexStatisticsStore indexStatisticsStore) {
        this.storeView = storeView;
        this.propertyAccessor = storeView.newPropertyAccessor();
        this.logProvider = logProvider;
        this.log = logProvider.getLog(IndexPopulationJob.class);
        this.type = type;
        this.schemaState = schemaState;
        this.indexStatisticsStore = indexStatisticsStore;
        this.phaseTracker = new LoggingPhaseTracker(logProvider.getLog(IndexPopulationJob.class));
    }

    IndexPopulation addPopulator(IndexPopulator populator, IndexDescriptor indexDescriptor, FlippableIndexProxy flipper, FailedIndexProxyFactory failedIndexProxyFactory, String indexUserDescription) {
        IndexPopulation population = this.createPopulation(populator, indexDescriptor, flipper, failedIndexProxyFactory, indexUserDescription);
        this.populations.add(population);
        return population;
    }

    private IndexPopulation createPopulation(IndexPopulator populator, IndexDescriptor indexDescriptor, FlippableIndexProxy flipper, FailedIndexProxyFactory failedIndexProxyFactory, String indexUserDescription) {
        return new IndexPopulation(populator, indexDescriptor, flipper, failedIndexProxyFactory, indexUserDescription);
    }

    boolean hasPopulators() {
        return !this.populations.isEmpty();
    }

    public void create() {
        this.forEachPopulation((ThrowingConsumer<IndexPopulation, Exception>)((ThrowingConsumer)population -> {
            this.log.info("Index population started: [%s]", new Object[]{population.indexUserDescription});
            population.create();
        }));
    }

    public void drop() {
        throw new UnsupportedOperationException("Can't drop indexes from this populator implementation");
    }

    public void add(Collection<? extends IndexEntryUpdate<?>> updates) {
        throw new UnsupportedOperationException("Can't populate directly using this populator implementation. ");
    }

    StoreScan<IndexPopulationFailedKernelException> indexAllEntities() {
        int[] entityTokenIds = this.entityTokenIds();
        int[] propertyKeyIds = this.propertyKeyIds();
        IntPredicate propertyKeyIdFilter = propertyKeyId -> ArrayIterate.contains((int[])propertyKeyIds, (int)propertyKeyId);
        this.storeScan = this.type == EntityType.RELATIONSHIP ? this.storeView.visitRelationships(entityTokenIds, propertyKeyIdFilter, new EntityPopulationVisitor()) : this.storeView.visitNodes(entityTokenIds, propertyKeyIdFilter, new EntityPopulationVisitor(), null, false);
        this.storeScan.setPhaseTracker(this.phaseTracker);
        return new DelegatingStoreScan<IndexPopulationFailedKernelException>(this.storeScan){

            @Override
            public void run() throws IndexPopulationFailedKernelException {
                super.run();
                MultipleIndexPopulator.this.flushAll();
            }
        };
    }

    void queueConcurrentUpdate(IndexEntryUpdate<?> update) {
        this.concurrentUpdateQueue.add(update);
    }

    public void fail(Throwable failure) {
        for (IndexPopulation population : this.populations) {
            this.fail(population, failure);
        }
    }

    protected void fail(IndexPopulation population, Throwable failure) {
        Throwable cause;
        if (!this.removeFromOngoingPopulations(population)) {
            return;
        }
        if (failure instanceof IndexPopulationFailedKernelException && (cause = failure.getCause()) instanceof IndexEntryConflictException) {
            failure = cause;
        }
        this.log.error(String.format("Failed to populate index: [%s]", population.indexUserDescription), failure);
        IndexPopulationFailure indexPopulationFailure = IndexPopulationFailure.failure(failure);
        population.flipToFailed(indexPopulationFailure);
        try {
            population.populator.markAsFailed(indexPopulationFailure.asString());
            population.populator.close(false);
        }
        catch (Throwable e) {
            this.log.error(String.format("Unable to close failed populator for index: [%s]", population.indexUserDescription), e);
        }
    }

    public void verifyDeferredConstraints(NodePropertyAccessor accessor) {
        throw new UnsupportedOperationException("Should not be called directly");
    }

    public MultipleIndexUpdater newPopulatingUpdater(NodePropertyAccessor accessor) {
        HashMap<SchemaDescriptor, Pair<IndexPopulation, IndexUpdater>> updaters = new HashMap<SchemaDescriptor, Pair<IndexPopulation, IndexUpdater>>();
        this.forEachPopulation((ThrowingConsumer<IndexPopulation, Exception>)((ThrowingConsumer)population -> {
            IndexUpdater updater = population.populator.newPopulatingUpdater(accessor);
            updaters.put(population.schema(), Pair.of((Object)population, (Object)updater));
        }));
        return new MultipleIndexUpdater(this, updaters, this.logProvider);
    }

    public void close(boolean populationCompletedSuccessfully) {
        this.phaseTracker.stop();
        this.propertyAccessor.close();
    }

    public void markAsFailed(String failure) {
        throw new UnsupportedOperationException("Multiple index populator can't be marked as failed.");
    }

    public void includeSample(IndexEntryUpdate<?> update) {
        throw new UnsupportedOperationException("Multiple index populator can't perform index sampling.");
    }

    public IndexSample sampleResult() {
        throw new UnsupportedOperationException("Multiple index populator can't perform index sampling.");
    }

    public void scanCompleted(PhaseTracker phaseTracker) {
        throw new UnsupportedOperationException("Not supposed to be called");
    }

    void resetIndexCounts() {
        this.forEachPopulation((ThrowingConsumer<IndexPopulation, Exception>)((ThrowingConsumer)this::resetIndexCountsForPopulation));
    }

    private void resetIndexCountsForPopulation(IndexPopulation indexPopulation) {
        this.indexStatisticsStore.replaceStats(indexPopulation.indexId, 0L, 0L, 0L);
    }

    void flipAfterPopulation(boolean verifyBeforeFlipping) {
        for (IndexPopulation population : this.populations) {
            try {
                population.scanCompleted();
                population.flip(verifyBeforeFlipping);
            }
            catch (Throwable t) {
                this.fail(population, t);
            }
        }
    }

    private int[] propertyKeyIds() {
        return this.populations.stream().flatMapToInt(this::propertyKeyIds).distinct().toArray();
    }

    private IntStream propertyKeyIds(IndexPopulation population) {
        return IntStream.of(population.schema().getPropertyIds());
    }

    private int[] entityTokenIds() {
        return this.populations.stream().flatMapToInt(population -> Arrays.stream(population.schema().getEntityTokenIds())).toArray();
    }

    public void cancel() {
        this.forEachPopulation((ThrowingConsumer<IndexPopulation, Exception>)((ThrowingConsumer)this::cancelIndexPopulation));
    }

    void cancelIndexPopulation(IndexPopulation indexPopulation) {
        indexPopulation.cancel();
    }

    void dropIndexPopulation(IndexPopulation indexPopulation) {
        indexPopulation.cancelAndDrop();
    }

    private boolean removeFromOngoingPopulations(IndexPopulation indexPopulation) {
        return this.populations.remove(indexPopulation);
    }

    boolean applyConcurrentUpdateQueueBatched(long currentlyIndexedNodeId) {
        return this.applyConcurrentUpdateQueue(this.QUEUE_THRESHOLD, currentlyIndexedNodeId);
    }

    void flushAll() {
        this.populations.forEach(this::flush);
    }

    protected final void flush(IndexPopulation population) {
        this.phaseTracker.enterPhase(PhaseTracker.Phase.WRITE);
        this.doFlush(population);
    }

    void doFlush(IndexPopulation population) {
        try {
            population.populator.add(population.takeCurrentBatchFromScan());
        }
        catch (Throwable failure) {
            this.fail(population, failure);
        }
    }

    private boolean applyConcurrentUpdateQueue(int queueThreshold, long currentlyIndexedNodeId) {
        int queueSize = this.concurrentUpdateQueue.size();
        if (queueSize > 0 && queueSize >= queueThreshold) {
            if (this.PRINT_DEBUG) {
                this.log.info("Populating from queue at %d", new Object[]{currentlyIndexedNodeId});
            }
            this.flushAll();
            try (MultipleIndexUpdater updater = this.newPopulatingUpdater(this.propertyAccessor);){
                do {
                    IndexEntryUpdate<?> update = this.concurrentUpdateQueue.poll();
                    this.storeScan.acceptUpdate(updater, update, currentlyIndexedNodeId);
                    if (!this.PRINT_DEBUG) continue;
                    this.log.info("Applied %s from queue" + update);
                } while (!this.concurrentUpdateQueue.isEmpty());
            }
            if (this.PRINT_DEBUG) {
                this.log.info("Done applying updates from queue");
            }
            return true;
        }
        return false;
    }

    private void forEachPopulation(ThrowingConsumer<IndexPopulation, Exception> action) {
        for (IndexPopulation population : this.populations) {
            try {
                action.accept((Object)population);
            }
            catch (Throwable failure) {
                this.fail(population, failure);
            }
        }
    }

    protected static class DelegatingStoreScan<E extends Exception>
    implements StoreScan<E> {
        private final StoreScan<E> delegate;

        DelegatingStoreScan(StoreScan<E> delegate) {
            this.delegate = delegate;
        }

        @Override
        public void run() throws E {
            this.delegate.run();
        }

        @Override
        public void stop() {
            this.delegate.stop();
        }

        @Override
        public void acceptUpdate(MultipleIndexUpdater updater, IndexEntryUpdate<?> update, long currentlyIndexedNodeId) {
            this.delegate.acceptUpdate(updater, update, currentlyIndexedNodeId);
        }

        @Override
        public PopulationProgress getProgress() {
            return this.delegate.getProgress();
        }

        @Override
        public void setPhaseTracker(PhaseTracker phaseTracker) {
            this.delegate.setPhaseTracker(phaseTracker);
        }
    }

    private class EntityPopulationVisitor
    implements Visitor<EntityUpdates, IndexPopulationFailedKernelException> {
        private EntityPopulationVisitor() {
        }

        public boolean visit(EntityUpdates updates) {
            this.addFromScan(updates);
            if (MultipleIndexPopulator.this.PRINT_DEBUG) {
                MultipleIndexPopulator.this.log.info("Added scan updates for entity %d", new Object[]{updates.getEntityId()});
            }
            return MultipleIndexPopulator.this.applyConcurrentUpdateQueueBatched(updates.getEntityId());
        }

        private void addFromScan(EntityUpdates updates) {
            for (IndexEntryUpdate indexUpdate : updates.forIndexKeys(MultipleIndexPopulator.this.populations)) {
                ((IndexPopulation)indexUpdate.indexKey()).onUpdateFromScan(indexUpdate);
            }
        }
    }

    public class IndexPopulation
    implements SchemaDescriptorSupplier {
        public final IndexPopulator populator;
        final FlippableIndexProxy flipper;
        private final long indexId;
        private final IndexDescriptor indexDescriptor;
        private final FailedIndexProxyFactory failedIndexProxyFactory;
        private final String indexUserDescription;
        private boolean populationOngoing = true;
        private final ReentrantLock populatorLock = new ReentrantLock();
        List<IndexEntryUpdate<?>> batchedUpdatesFromScan;

        IndexPopulation(IndexPopulator populator, IndexDescriptor indexDescriptor, FlippableIndexProxy flipper, FailedIndexProxyFactory failedIndexProxyFactory, String indexUserDescription) {
            this.populator = populator;
            this.indexDescriptor = indexDescriptor;
            this.indexId = indexDescriptor.getId();
            this.flipper = flipper;
            this.failedIndexProxyFactory = failedIndexProxyFactory;
            this.indexUserDescription = indexUserDescription;
            this.batchedUpdatesFromScan = new ArrayList(MultipleIndexPopulator.this.BATCH_SIZE_SCAN);
        }

        private void flipToFailed(IndexPopulationFailure failure) {
            this.flipper.flipTo(new FailedIndexProxy(this.indexDescriptor, this.indexUserDescription, (IndexDropper)this.populator, failure, MultipleIndexPopulator.this.indexStatisticsStore, MultipleIndexPopulator.this.logProvider));
        }

        void create() {
            this.populatorLock.lock();
            try {
                if (this.populationOngoing) {
                    this.populator.create();
                }
            }
            finally {
                this.populatorLock.unlock();
            }
        }

        void cancel() {
            this.cancel(() -> this.populator.close(false));
        }

        void cancelAndDrop() {
            this.cancel(() -> ((IndexPopulator)this.populator).drop());
        }

        private void cancel(Runnable specificPopulatorOperation) {
            this.populatorLock.lock();
            try {
                if (this.populationOngoing) {
                    MultipleIndexPopulator.this.removeFromOngoingPopulations(this);
                    specificPopulatorOperation.run();
                    MultipleIndexPopulator.this.resetIndexCountsForPopulation(this);
                    this.populationOngoing = false;
                }
            }
            finally {
                this.populatorLock.unlock();
            }
        }

        private void onUpdateFromScan(IndexEntryUpdate<?> update) {
            this.populator.includeSample(update);
            if (this.addToBatchFromScan(update)) {
                MultipleIndexPopulator.this.flush(this);
            }
        }

        void flip(boolean verifyBeforeFlipping) throws FlipFailedKernelException {
            MultipleIndexPopulator.this.phaseTracker.enterPhase(PhaseTracker.Phase.FLIP);
            this.flipper.flip(() -> {
                this.populatorLock.lock();
                try {
                    if (this.populationOngoing) {
                        this.populator.add(this.takeCurrentBatchFromScan());
                        MultipleIndexPopulator.this.applyConcurrentUpdateQueue(0, Long.MAX_VALUE);
                        if (MultipleIndexPopulator.this.populations.contains(this)) {
                            if (verifyBeforeFlipping) {
                                this.populator.verifyDeferredConstraints(MultipleIndexPopulator.this.propertyAccessor);
                            }
                            IndexSample sample = this.populator.sampleResult();
                            MultipleIndexPopulator.this.indexStatisticsStore.replaceStats(this.indexId, sample.uniqueValues(), sample.sampleSize(), sample.indexSize());
                            this.populator.close(true);
                            MultipleIndexPopulator.this.schemaState.clear();
                            Boolean bl = true;
                            return bl;
                        }
                    }
                    Boolean bl = false;
                    return bl;
                }
                finally {
                    this.populationOngoing = false;
                    this.populatorLock.unlock();
                }
            }, this.failedIndexProxyFactory);
            MultipleIndexPopulator.this.removeFromOngoingPopulations(this);
            this.logCompletionMessage();
        }

        private void logCompletionMessage() {
            InternalIndexState postPopulationState = this.flipper.getState();
            String messageTemplate = this.isIndexPopulationOngoing(postPopulationState) ? "Index created. Starting data checks. Index [%s] is %s." : "Index creation finished. Index [%s] is %s.";
            MultipleIndexPopulator.this.log.info(messageTemplate, new Object[]{this.indexUserDescription, postPopulationState.name()});
        }

        private boolean isIndexPopulationOngoing(InternalIndexState postPopulationState) {
            return InternalIndexState.POPULATING == postPopulationState;
        }

        public SchemaDescriptor schema() {
            return this.indexDescriptor.schema();
        }

        public String userDescription(TokenNameLookup tokenNameLookup) {
            return this.indexUserDescription;
        }

        boolean addToBatchFromScan(IndexEntryUpdate<?> update) {
            this.batchedUpdatesFromScan.add(update);
            return this.batchedUpdatesFromScan.size() >= MultipleIndexPopulator.this.BATCH_SIZE_SCAN;
        }

        List<IndexEntryUpdate<?>> takeCurrentBatchFromScan() {
            if (this.batchedUpdatesFromScan.isEmpty()) {
                return Collections.emptyList();
            }
            List<IndexEntryUpdate<?>> batch = this.batchedUpdatesFromScan;
            this.batchedUpdatesFromScan = new ArrayList(MultipleIndexPopulator.this.BATCH_SIZE_SCAN);
            return batch;
        }

        void scanCompleted() throws IndexEntryConflictException {
            this.populator.scanCompleted(MultipleIndexPopulator.this.phaseTracker);
        }

        PopulationProgress progress(PopulationProgress storeScanProgress) {
            return this.populator.progress(storeScanProgress);
        }
    }

    public static class MultipleIndexUpdater
    implements IndexUpdater {
        private final Map<SchemaDescriptor, Pair<IndexPopulation, IndexUpdater>> populationsWithUpdaters;
        private final MultipleIndexPopulator multipleIndexPopulator;
        private final Log log;

        MultipleIndexUpdater(MultipleIndexPopulator multipleIndexPopulator, Map<SchemaDescriptor, Pair<IndexPopulation, IndexUpdater>> populationsWithUpdaters, LogProvider logProvider) {
            this.multipleIndexPopulator = multipleIndexPopulator;
            this.populationsWithUpdaters = populationsWithUpdaters;
            this.log = logProvider.getLog(this.getClass());
        }

        public void process(IndexEntryUpdate<?> update) {
            Pair<IndexPopulation, IndexUpdater> pair = this.populationsWithUpdaters.get(update.indexKey().schema());
            if (pair != null) {
                IndexPopulation population = (IndexPopulation)pair.first();
                IndexUpdater updater = (IndexUpdater)pair.other();
                try {
                    population.populator.includeSample(update);
                    updater.process(update);
                }
                catch (Throwable t) {
                    try {
                        updater.close();
                    }
                    catch (Throwable ce) {
                        this.log.error(String.format("Failed to close index updater: [%s]", updater), ce);
                    }
                    this.populationsWithUpdaters.remove(update.indexKey().schema());
                    this.multipleIndexPopulator.fail(population, t);
                }
            }
        }

        public void close() {
            for (Pair<IndexPopulation, IndexUpdater> pair : this.populationsWithUpdaters.values()) {
                IndexPopulation population = (IndexPopulation)pair.first();
                IndexUpdater updater = (IndexUpdater)pair.other();
                try {
                    updater.close();
                }
                catch (Throwable t) {
                    this.multipleIndexPopulator.fail(population, t);
                }
            }
            this.populationsWithUpdaters.clear();
        }
    }
}

