/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.diagnostics.providers;

import java.util.Map;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.SettingImpl;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.internal.diagnostics.NamedDiagnosticsProvider;
import org.neo4j.logging.Logger;

public class ConfigDiagnostics
extends NamedDiagnosticsProvider {
    private final Config config;

    public ConfigDiagnostics(Config config) {
        super("DBMS config");
        this.config = config;
    }

    public void dump(Logger logger) {
        if (this.config.getDeclaredSettings().values().stream().noneMatch(arg_0 -> ((Config)this.config).isExplicitlySet(arg_0))) {
            logger.log("No provided DBMS settings.");
            return;
        }
        logger.log("DBMS provided settings:");
        this.config.getDeclaredSettings().entrySet().stream().filter(entry -> this.config.isExplicitlySet((Setting)entry.getValue())).sorted(Map.Entry.comparingByKey()).forEachOrdered(e -> {
            String value = ((SettingImpl)e.getValue()).valueToString(this.config.get((Setting)e.getValue()));
            logger.log("%s=%s", new Object[]{e.getKey(), value});
        });
    }
}

