/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.scheduler;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.neo4j.scheduler.CancelListener;
import org.neo4j.scheduler.JobHandle;

final class PooledJobHandle
implements JobHandle {
    private final Future<?> future;
    private final Object registryKey;
    private final ConcurrentHashMap<Object, Future<?>> registry;
    private final List<CancelListener> cancelListeners = new CopyOnWriteArrayList<CancelListener>();

    PooledJobHandle(Future<?> future, Object registryKey, ConcurrentHashMap<Object, Future<?>> registry) {
        this.future = future;
        this.registryKey = registryKey;
        this.registry = registry;
    }

    public void cancel() {
        this.future.cancel(false);
        for (CancelListener cancelListener : this.cancelListeners) {
            cancelListener.cancelled();
        }
        this.registry.remove(this.registryKey);
    }

    public void waitTermination() throws InterruptedException, ExecutionException {
        this.future.get();
    }

    public void waitTermination(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        this.future.get(timeout, unit);
    }

    public void registerCancelListener(CancelListener listener) {
        this.cancelListeners.add(listener);
    }
}

