/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state.storeview;

import org.neo4j.internal.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.io.IOUtils;
import org.neo4j.storageengine.api.NodePropertyAccessor;
import org.neo4j.storageengine.api.StorageNodeCursor;
import org.neo4j.storageengine.api.StoragePropertyCursor;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class DefaultNodePropertyAccessor
implements NodePropertyAccessor {
    private final StorageReader reader;
    private final StorageNodeCursor nodeCursor;
    private final StoragePropertyCursor propertyCursor;

    public DefaultNodePropertyAccessor(StorageReader reader) {
        this.reader = reader;
        this.nodeCursor = reader.allocateNodeCursor();
        this.propertyCursor = reader.allocatePropertyCursor();
    }

    public Value getNodePropertyValue(long nodeId, int propertyKeyId) throws EntityNotFoundException {
        this.nodeCursor.single(nodeId);
        if (this.nodeCursor.next() && this.nodeCursor.hasProperties()) {
            this.nodeCursor.properties(this.propertyCursor);
            while (this.propertyCursor.next()) {
                if (this.propertyCursor.propertyKey() != propertyKeyId) continue;
                return this.propertyCursor.propertyValue();
            }
        }
        return Values.NO_VALUE;
    }

    public void close() {
        IOUtils.closeAllUnchecked((AutoCloseable[])new AutoCloseable[]{this.nodeCursor, this.propertyCursor, this.reader});
    }
}

